/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model.util;

import java.awt.geom.Point2D;
import ome.model.units.BigResult;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;

public class UnitPoint {
    public Length x;
    public Length y;

    public UnitPoint() {
    }

    public UnitPoint(Length x, Length y) {
        if (!x.getUnit().equals((Object)y.getUnit())) {
            try {
                new LengthI(y, x.getUnit());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Units " + LengthI.lookupSymbol((UnitsLength)x.getUnit()) + " and " + LengthI.lookupSymbol((UnitsLength)y.getUnit()) + " are not compatible!");
            }
        }
        this.x = x;
        this.y = y;
    }

    public UnitsLength getUnit() {
        return this.x.getUnit();
    }

    public Point2D getValue() {
        return new Point2D.Double(this.x.getValue(), this.y.getValue());
    }

    public Length getDistance(UnitPoint other) {
        try {
            LengthI myX = new LengthI(this.x, this.x.getUnit());
            LengthI myY = new LengthI(this.y, this.x.getUnit());
            LengthI otherX = new LengthI(other.x, this.x.getUnit());
            LengthI otherY = new LengthI(other.y, this.x.getUnit());
            Point2D.Double p1 = new Point2D.Double(myX.getValue(), myY.getValue());
            Point2D.Double p2 = new Point2D.Double(otherX.getValue(), otherY.getValue());
            return new LengthI(p1.distance(p2), this.getUnit());
        }
        catch (BigResult result) {
            return new LengthI(Double.POSITIVE_INFINITY, this.getUnit());
        }
    }

    public void setLocation(double x, double y) {
        this.x.setValue(x);
        this.y.setValue(y);
    }
}

