/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OSMenuAdapter
implements InvocationHandler {
    private static final String APPLE_CLASS = "com.apple.eawt.Application";
    private static final String APPLE_CLASS_LISTENER = "com.apple.eawt.ApplicationListener";
    private Object targetObject;
    private Method targetMethod;
    private String proxySignature;
    private static Object macOSXApplication;

    public static void setQuitHandler(Object target, Method handler) throws Throwable {
        OSMenuAdapter.setHandler(new OSMenuAdapter("handleQuit", target, handler));
    }

    public static void setAboutHandler(Object target, Method handler) throws Throwable {
        boolean enableAboutMenu;
        boolean bl = enableAboutMenu = target != null && handler != null;
        if (enableAboutMenu) {
            OSMenuAdapter.setHandler(new OSMenuAdapter("handleAbout", target, handler));
        }
        Method enableAboutMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
        enableAboutMethod.invoke(macOSXApplication, enableAboutMenu);
    }

    private OSMenuAdapter(String proxySignature, Object target, Method handler) {
        this.proxySignature = proxySignature;
        this.targetObject = target;
        this.targetMethod = handler;
    }

    private static void setHandler(OSMenuAdapter adapter) throws Throwable {
        Class<?> klass = Class.forName(APPLE_CLASS);
        if (macOSXApplication == null) {
            macOSXApplication = klass.getConstructor(null).newInstance(null);
        }
        Class<?> listenerClass = Class.forName(APPLE_CLASS_LISTENER);
        Method addListenerMethod = klass.getDeclaredMethod("addApplicationListener", listenerClass);
        Object proxy = Proxy.newProxyInstance(OSMenuAdapter.class.getClassLoader(), new Class[]{listenerClass}, (InvocationHandler)adapter);
        addListenerMethod.invoke(macOSXApplication, proxy);
    }

    private boolean callTarget(Object event) throws InvocationTargetException, IllegalAccessException {
        Object result = this.targetMethod.invoke(this.targetObject, (Object[])null);
        if (result == null) {
            return !this.proxySignature.equals("handleQuit");
        }
        return Boolean.valueOf(result.toString());
    }

    private boolean isCorrectMethod(Method method, Object[] args) {
        return this.targetMethod != null && this.proxySignature.equals(method.getName()) && args.length == 1;
    }

    private void setApplicationEventHandled(Object event, boolean handled) throws Throwable {
        if (event == null) {
            return;
        }
        Class<?> klass = event.getClass();
        Method setHandledMethod = klass.getDeclaredMethod("setHandled", Boolean.TYPE);
        setHandledMethod.invoke(event, handled);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isCorrectMethod(method, args)) {
            this.setApplicationEventHandled(args[0], this.callTarget(args[0]));
        }
        return null;
    }
}

