/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.OMETextField;
import org.openmicroscopy.shoola.util.ui.border.TitledLineBorder;

public class UIUtilities {
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String HINTS_PROPERTY = "awt.font.desktophints";
    public static final Color TOOLTIP_COLOR = new Color(255, 252, 180, 200);
    public static final int DEFAULT_NUMBER_OF_CHARACTERS = 30;
    public static final int RED_COLOR = 0;
    public static final int GREEN_COLOR = 1;
    public static final int BLUE_COLOR = 2;
    public static final int BYTES = 1024;
    public static final double EPSILON = 1.0E-5;
    public static final int MAX_LINES_EXCEPTION = 20;
    public static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    public static final Map<Integer, String> LETTERS;
    public static final int MAX_CHARACTER = 40;
    public static final Color LIGHT_GREY;
    public static final int DEFAULT_ICON_WIDTH = 16;
    public static final int DEFAULT_ICON_HEIGHT = 16;
    public static final Color HYPERLINK_COLOR;
    public static final Color BACKGROUND_COLOR;
    public static final Color REQUIRED_FIELDS_COLOR;
    public static final Color WINDOW_BACKGROUND_COLOR;
    public static final Color EDITED_COLOR;
    public static final Color DEFAULT_FONT_COLOR;
    public static final String COLLAPSED_PROPERTY_JXTASKPANE = "collapsed";
    public static final Color INNER_BORDER_HIGHLIGHT;
    public static final Color INNER_BORDER_SHADOW;
    public static final String DATE_FORMAT = "yy/MM/dd";
    public static final Color BACKGROUND_COLOUR_EVEN;
    public static final Color BACKGROUND_COLOUR_ODD;
    public static final Color SELECTED_BACKGROUND_COLOUR;
    public static final Color FOREGROUND_COLOUR;
    public static final Color TRACK_GRADIENT_START;
    public static final Color TRACK_GRADIENT_END;
    public static final Color LINE_COLOR;
    public static final long DAY = 86400000L;
    public static final String SQUARED_SYMBOL = "\u00b2";
    public static final String DELTA_SYMBOL = "\u0394";
    public static final String PIXELS_SYMBOL = "px";
    public static final String DEGREE_SYMBOL = "\u00b0";
    public static final Color HIGHLIGHT;
    public static final Color BACKGROUND;
    public static final Color BACKGROUND_ONE;
    public static final String DOTS = "...";
    public static final Color STEELBLUE;
    public static final Color DEFAULT_TEXT;
    public static final int DIALOG_WIDTH = 500;
    public static final int DIALOG_HEIGHT = 500;
    public static final int SEPARATOR_WIDTH = 2;
    public static final int TABLE_WIDTH = 200;
    public static final int INCREMENT = 15;
    public static final long MEGABYTE = 0x100000L;
    private static final String DEFAULT_FOLDER = "defaultFolder";
    public static final String WDMY_FORMAT = "E dd MMM yyyy, HH:mm:ss";
    public static final String D_M_Y_FORMAT = "dd-MM-yyyy";
    private static final String DATE_TOOLTIP = "Bring up a calendar.";
    private static final int WRAP_UP_MAX_WIDTH = 50;
    private static final List<String> CHARACTERS;
    private static final Map<String, String> FONTS;
    private static final boolean GNOME;

    private static boolean isTextOnly(String value) {
        Iterator<String> i = CHARACTERS.iterator();
        while (i.hasNext()) {
            if (!value.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public static void centerOnScreen(Component window) {
        if (window == null) {
            return;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle ed = window.getBounds();
        window.setLocation((screenSize.width - ed.width) / 2, (screenSize.height - ed.height) / 2);
    }

    public static void showOnScreen(Component window, Point location) {
        if (window == null) {
            return;
        }
        if (location == null) {
            UIUtilities.centerAndShow(window);
        } else {
            window.setLocation(location);
            window.setVisible(true);
        }
    }

    public static void centerAndShow(Component window) {
        UIUtilities.centerOnScreen(window);
        window.setVisible(true);
        UIUtilities.applyGnome3Workaround(window);
    }

    public static void centerAndShow(Component parent, Component child) {
        if (parent == null || child == null) {
            return;
        }
        Rectangle bounds = parent.getBounds();
        Rectangle ed = child.getBounds();
        child.setLocation(bounds.x + (bounds.width - ed.width) / 2, bounds.y + (bounds.height - ed.height) / 2);
        child.setVisible(true);
    }

    public static void setLocationRelativeToAndShow(Component parent, Component child) {
        UIUtilities.setLocationRelativeTo(parent, child);
    }

    public static void setLocationRelativeTo(Component parent, Component child) {
        Dimension screenSize;
        if (parent == null || child == null) {
            return;
        }
        int x = parent.getX() + parent.getWidth();
        int y = parent.getY();
        int childWidth = child.getWidth();
        if ((double)(x + childWidth) > (screenSize = Toolkit.getDefaultToolkit().getScreenSize()).getWidth()) {
            x = childWidth < parent.getX() ? parent.getX() - childWidth : (int)(screenSize.getWidth() - (double)childWidth);
        }
        child.setLocation(x, y);
        child.setVisible(true);
    }

    public static void setLocationRelativeToAndSizeToWindow(Component parent, Component child, Dimension max) {
        UIUtilities.setLocationRelativeToAndSizeToWindow(parent.getBounds(), child, max);
    }

    public static void setLocationRelativeToAndSizeToWindow(Rectangle parentBounds, Component child, Dimension max) {
        if (child == null) {
            return;
        }
        if (parentBounds == null) {
            parentBounds = new Rectangle(0, 0, 5, 5);
        }
        if (max == null) {
            max = new Dimension(5, 5);
        }
        int x = (int)(parentBounds.getX() + parentBounds.getWidth());
        int y = (int)parentBounds.getY();
        int childWidth = child.getWidth();
        int childHeight = child.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)(x + childWidth) > screenSize.getWidth()) {
            x = (double)childWidth < parentBounds.getX() ? (int)parentBounds.getX() - childWidth : (int)(screenSize.getWidth() - (double)childWidth);
        }
        child.setLocation(x, y);
        int newHeight = (int)screenSize.getHeight() - y - 10;
        int newWidth = (int)screenSize.getWidth() - x - 10;
        if (newWidth > childWidth) {
            childWidth = newWidth;
        }
        if (newHeight > childHeight) {
            childHeight = newHeight;
        }
        if ((double)childWidth > max.getWidth()) {
            childWidth = (int)max.getWidth();
        }
        if ((double)childHeight > max.getHeight()) {
            childHeight = (int)max.getHeight();
        }
        child.setSize(childWidth, childHeight);
        child.setVisible(true);
    }

    public static void setLocationRelativeTo(Rectangle parentBounds, Component child) {
        Dimension screenSize;
        if (child == null) {
            return;
        }
        if (parentBounds == null) {
            parentBounds = new Rectangle(0, 0, 5, 5);
        }
        int x = parentBounds.x + parentBounds.width;
        int y = parentBounds.y;
        int childWidth = child.getWidth();
        if ((double)(x + childWidth) > (screenSize = Toolkit.getDefaultToolkit().getScreenSize()).getWidth()) {
            x = childWidth < parentBounds.x ? parentBounds.x - childWidth : (int)(screenSize.getWidth() - (double)childWidth);
        }
        child.setLocation(x, y);
        child.setVisible(true);
    }

    public static void incrementRelativeToAndShow(Rectangle bounds, Component child) {
        if (bounds == null) {
            UIUtilities.centerAndShow(child);
            return;
        }
        child.setLocation(bounds.x + 15, bounds.y + 15);
        child.setVisible(true);
    }

    public static void makeForDialog(Component parent, String title, JComponent c) {
        if (c == null) {
            return;
        }
        JDialog dialog = null;
        if (parent instanceof Frame) {
            dialog = new JDialog((Frame)parent);
        } else if (parent instanceof Dialog) {
            dialog = new JDialog((Dialog)parent);
        } else if (dialog == null) {
            dialog = new JDialog();
        }
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setTitle(title);
        dialog.setSize(500, 500);
        Container container = dialog.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)c, "Center");
        UIUtilities.centerAndShow(dialog);
    }

    public static void makeForDialog(Component parent, JComponent c) {
        UIUtilities.makeForDialog(parent, "", c);
    }

    public static String formatToolTipText(String toolTipText) {
        return toolTipText;
    }

    public static String formatStringListToTable(List<String> columnNames, List<String[]> rows) {
        if (columnNames == null || rows == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<table>");
        sb.append("<tr>");
        for (String column : columnNames) {
            sb.append("<th>" + column + "</th>");
        }
        sb.append("</tr>");
        for (String[] rowColumns : rows) {
            sb.append("<tr>");
            for (int i = 0; i < rowColumns.length; ++i) {
                sb.append("<td>");
                sb.append(rowColumns[i]);
                sb.append("</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</table>");
        return UIUtilities.formatToolTipText(sb.toString());
    }

    public static String formatToolTipText(List<String> toolTipText) {
        if (toolTipText == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        buf.append("<font face=Arial size=2>");
        Iterator<String> i = toolTipText.iterator();
        buf.append("<p>");
        while (i.hasNext()) {
            buf.append(i.next());
            buf.append("<br>");
        }
        buf.append("</p>");
        buf.append("</font></body></html>");
        return buf.toString();
    }

    public static String formatToolTipText(String[] toolTipText) {
        if (toolTipText == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        buf.append("<font face=Arial size=2>");
        buf.append("<p>");
        for (int i = 0; i < toolTipText.length; ++i) {
            buf.append(toolTipText[i]);
            buf.append("<br>");
        }
        buf.append("</p>");
        buf.append("</font></body></html>");
        return buf.toString();
    }

    public static String makeParagraph(String title, String body, int maxWidth) {
        if (title != null && body == null) {
            return UIUtilities.formatToolTipText(title);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body bgcolor=#FFFCB7 text=#AD5B00>");
        if (title != null && body != null) {
            String s = "<table width=" + maxWidth + "><tr>";
            buf.append(s);
            buf.append("<td><b>");
            buf.append(title);
            buf.append("</b><hr size=1>");
            buf.append("<font face=Arial size=2>");
            buf.append(body);
            buf.append("</font>");
            buf.append("</td></tr></table>");
        } else if (title == null && body != null) {
            String s = "<table width=" + maxWidth + "><tr>";
            buf.append(s);
            buf.append("<td>");
            buf.append("<font face=Arial size=2>");
            buf.append(body);
            buf.append("</font>");
            buf.append("</td></tr></table>");
        }
        buf.append("</body></html>");
        return buf.toString();
    }

    public static JSeparator toolBarSeparator(JButton button, Icon icon) {
        JSeparator separator = new JSeparator(1);
        if (button == null) {
            return separator;
        }
        Insets i = button.getInsets();
        int h = 0;
        if (icon != null) {
            h = icon.getIconHeight();
        }
        Dimension d = new Dimension(2, i.top + h + i.bottom);
        separator.setPreferredSize(d);
        separator.setSize(d);
        return separator;
    }

    public static JLabel setTextFont(String s) {
        return UIUtilities.setTextFont(s, 1);
    }

    public static JLabel setTextFontX(String s) {
        return UIUtilities.setTextFontX(s, 1);
    }

    public static JLabel setTextFont(String s, int fontStyle) {
        if (s == null) {
            s = "";
        }
        JLabel label = new JLabel(s);
        Font font = label.getFont();
        Font newFont = font.deriveFont(fontStyle);
        label.setFont(newFont);
        return label;
    }

    public static JLabel setTextFontX(String s, int fontStyle) {
        if (s == null) {
            s = "";
        }
        JXLabel label = new JXLabel(s);
        label.setLineWrap(true);
        Font font = label.getFont();
        Font newFont = font.deriveFont(fontStyle);
        label.setFont(newFont);
        return label;
    }

    public static JLabel setTextFontX(String s, int fontStyle, int fontSize) {
        if (s == null) {
            s = "";
        }
        JXLabel label = new JXLabel(s);
        label.setLineWrap(true);
        Font font = label.getFont();
        label.setFont(font.deriveFont(fontStyle, fontSize));
        return label;
    }

    public static JLabel setTextFont(String s, int fontStyle, int fontSize) {
        if (s == null) {
            s = "";
        }
        JLabel label = new JLabel(s);
        Font font = label.getFont();
        label.setFont(font.deriveFont(fontStyle, fontSize));
        return label;
    }

    public static JPanel buildComponentPanel(JComponent component) {
        return UIUtilities.buildComponentPanel(component, 5, 5, true);
    }

    public static JPanel buildComponentPanel(JComponent component, boolean isOpaque) {
        return UIUtilities.buildComponentPanel(component, 5, 5, isOpaque);
    }

    public static JPanel buildComponentPanel(JComponent component, int hgap, int vgap) {
        return UIUtilities.buildComponentPanel(component, hgap, vgap, true);
    }

    public static JPanel buildComponentPanel(JComponent component, int hgap, int vgap, boolean isOpaque) {
        JPanel p = new JPanel();
        if (component == null) {
            return p;
        }
        if (hgap < 0) {
            hgap = 0;
        }
        if (vgap < 0) {
            vgap = 0;
        }
        p.setLayout(new FlowLayout(0, hgap, vgap));
        p.add(component);
        p.setOpaque(isOpaque);
        return p;
    }

    public static JPanel buildComponentPanelRight(JComponent component) {
        return UIUtilities.buildComponentPanelRight(component, true);
    }

    public static JPanel buildComponentPanelRight(JComponent component, int hgap, int vgap, boolean isOpaque) {
        JPanel p = new JPanel();
        if (component == null) {
            return p;
        }
        if (hgap < 0) {
            hgap = 0;
        }
        if (vgap < 0) {
            vgap = 0;
        }
        p.setLayout(new FlowLayout(2, hgap, vgap));
        p.add(component);
        p.setOpaque(isOpaque);
        return p;
    }

    public static JPanel buildComponentPanelRight(JComponent component, boolean isOpaque) {
        return UIUtilities.buildComponentPanelRight(component, 5, 5, isOpaque);
    }

    public static JPanel buildComponentPanelCenter(JComponent component, int hgap, int vgap) {
        return UIUtilities.buildComponentPanelCenter(component, hgap, vgap, true);
    }

    public static JPanel buildComponentPanelCenter(JComponent component, int hgap, int vgap, boolean opaque) {
        JPanel p = new JPanel();
        if (component == null) {
            return p;
        }
        if (hgap < 0) {
            hgap = 0;
        }
        if (vgap < 0) {
            vgap = 0;
        }
        p.setLayout(new FlowLayout(1, hgap, vgap));
        p.add(component);
        p.setOpaque(opaque);
        return p;
    }

    public static JPanel buildComponentPanelCenter(JComponent component) {
        return UIUtilities.buildComponentPanelCenter(component, 5, 5);
    }

    public static void unifiedButtonLookAndFeel(JComponent b) {
        if (b == null) {
            return;
        }
        b.setOpaque(false);
        b.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    public static void opacityCheck(AbstractButton b) {
        if (b == null) {
            return;
        }
        b.setContentAreaFilled(!UIUtilities.isMacOS());
    }

    public static void setTextAreaDefault(JComponent area) {
        if (area == null) {
            return;
        }
        area.setBorder(BorderFactory.createBevelBorder(1));
        area.setBackground(BACKGROUND);
        area.setOpaque(true);
        if (area instanceof JTextComponent) {
            ((JTextComponent)area).setEditable(true);
        }
    }

    public static String twoDecimalPlaces(double val) {
        double v;
        double c = v = val;
        if (v < 0.0) {
            return null;
        }
        String value = c - Math.floor(c) > 0.0 ? "" + (float)Math.round(c * 100.0) / 100.0f : "" + (int)c;
        if (value.equals("0")) {
            return null;
        }
        return value;
    }

    public static Number twoDecimalPlacesAsNumber(double val) {
        double v;
        double c = v = val;
        if (v < 0.0) {
            return null;
        }
        Number value = c - Math.floor(c) > 0.0 ? (Number)Float.valueOf((float)Math.round(c * 100.0) / 100.0f) : (Number)((int)c);
        return value;
    }

    public static JTextPane buildTextPane(String text) {
        return UIUtilities.buildTextPane(text, null);
    }

    public static JEditorPane buildTextEditorPane(String text) {
        if (text == null) {
            text = "";
        }
        JEditorPane textPane = new JEditorPane();
        textPane.setContentType("text/html");
        textPane.setText(text);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setFocusable(false);
        return textPane;
    }

    public static JTextPane buildTextPane(String text, Color foreground) {
        if (text == null) {
            text = "";
        }
        StyleContext context = new StyleContext();
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        Style style = context.getStyle("default");
        StyleConstants.setAlignment(style, 0);
        if (foreground != null) {
            StyleConstants.setForeground(style, foreground);
        }
        try {
            document.insertString(document.getLength(), text, style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setFocusable(false);
        return textPane;
    }

    public static void enterPressesWhenFocused(JButton button) {
        if (button == null) {
            return;
        }
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    public static String getDefaultFolderAsString() {
        Preferences prefs = Preferences.userNodeForPackage(UIUtilities.class);
        if (prefs == null) {
            return null;
        }
        return prefs.get(DEFAULT_FOLDER, null);
    }

    public static void setDefaultFolder(String f) {
        Preferences prefs = Preferences.userNodeForPackage(UIUtilities.class);
        if (prefs == null) {
            return;
        }
        if (f == null) {
            f = "";
        }
        prefs.put(DEFAULT_FOLDER, f);
    }

    public static File getDefaultFolder() {
        String f = UIUtilities.getDefaultFolderAsString();
        if (CommonsLangUtils.isEmpty(f)) {
            return null;
        }
        return new File(f);
    }

    public static void setDefaultSize(Component component, Dimension dim) {
        if (component == null) {
            return;
        }
        if (dim == null) {
            dim = new Dimension(5, 5);
        }
        component.setPreferredSize(dim);
        component.setMaximumSize(dim);
        component.setMinimumSize(dim);
    }

    public static Component findComponent(Component comp, Class c) {
        if (c == null || comp == null) {
            throw new IllegalArgumentException("The parameters cannot be null");
        }
        if (c.isAssignableFrom(comp.getClass())) {
            return comp;
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component child = UIUtilities.findComponent(comps[i], c);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    public static List<Component> findComponents(Component comp, Class c) {
        ArrayList<Component> l = null;
        if (c == null || comp == null) {
            throw new IllegalArgumentException("The parameters cannot be null");
        }
        if (c.isAssignableFrom(comp.getClass())) {
            l = new ArrayList<Component>(1);
            l.add(comp);
            return l;
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            l = new ArrayList(comps.length);
            for (int i = 0; i < comps.length; ++i) {
                Component child = UIUtilities.findComponent(comps[i], c);
                if (child == null) continue;
                l.add(child);
            }
            return l;
        }
        return null;
    }

    public static boolean isDarkColor(Color c) {
        if (c == null) {
            return false;
        }
        return (c.getRed() + c.getGreen() + c.getBlue()) / 3 < 128;
    }

    public static Timestamp getDefaultTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    public static String formatTime(Timestamp time) {
        if (time == null) {
            return "";
        }
        return DateFormat.getDateInstance().format(time);
    }

    public static String formatShortDateTime(Timestamp time) {
        if (time == null) {
            time = UIUtilities.getDefaultTimestamp();
        }
        return DateFormat.getDateTimeInstance(3, 3, Locale.getDefault()).format(time);
    }

    public static String formatDefaultDate(Timestamp time) {
        if (time == null) {
            time = UIUtilities.getDefaultTimestamp();
        }
        return DEFAULT_DATE_FORMAT.format(time);
    }

    public static String formatDefaultDate(Date date) {
        if (date == null) {
            return UIUtilities.formatDefaultDate(null);
        }
        return DEFAULT_DATE_FORMAT.format(date);
    }

    public static String formatWDMYDate(Timestamp time) {
        return UIUtilities.formatDate(time, WDMY_FORMAT);
    }

    public static String formatDate(Timestamp time, String pattern) {
        if (time == null) {
            time = UIUtilities.getDefaultTimestamp();
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = WDMY_FORMAT;
        }
        DateFormat df = WDMY_FORMAT.equals(pattern) ? DateFormat.getDateTimeInstance(0, 1, Locale.getDefault()) : DateFormat.getDateInstance(3, Locale.getDefault());
        return df.format(time);
    }

    public static String calculateHMSFromMilliseconds(long timeInMilliSeconds) {
        return UIUtilities.calculateHMS((int)(timeInMilliSeconds / 1000L), false);
    }

    public static String calculateHMSFromMilliseconds(long timeInMilliSeconds, boolean shortUnit) {
        return UIUtilities.calculateHMS((int)(timeInMilliSeconds / 1000L), shortUnit);
    }

    public static String calculateHMS(int timeInSeconds, boolean shortUnit) {
        int hours = timeInSeconds / 3600;
        int minutes = (timeInSeconds -= hours * 3600) / 60;
        int seconds = timeInSeconds -= minutes * 60;
        StringBuffer text = new StringBuffer();
        if (hours > 0) {
            text.append(hours);
            if (shortUnit) {
                text.append("h");
            } else {
                text.append(" hour");
                if (hours > 1) {
                    text.append("s");
                }
            }
        }
        if (minutes > 0) {
            text.append(" ");
            text.append(minutes);
            if (shortUnit) {
                text.append("min");
            } else {
                text.append(" minute");
                if (minutes > 1) {
                    text.append("s");
                }
            }
        }
        if (seconds > 0) {
            text.append(" ");
            text.append(seconds);
            if (shortUnit) {
                text.append("s");
            } else {
                text.append(" second");
                if (seconds > 1) {
                    text.append("s");
                }
            }
        }
        return text.toString();
    }

    public static String calculateHMS(int timeInSeconds) {
        return UIUtilities.calculateHMS(timeInSeconds, false);
    }

    public static String formatToDecimal(double value) {
        try {
            return String.format("%.2f", value);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static double roundTwoDecimals(double value) {
        return UIUtilities.round(value, 2);
    }

    public static final int findDecimal(double value, int decimal) {
        double testValue = Math.abs(value);
        double v = UIUtilities.round(testValue, decimal);
        if (v > 0.0) {
            return decimal;
        }
        return UIUtilities.findDecimal(testValue, ++decimal);
    }

    public static double ceil(double value, int decimal) {
        if (decimal <= 0) {
            return value;
        }
        double p = Math.pow(10.0, decimal);
        return Math.ceil(value *= p) / p;
    }

    public static double floor(double value, int decimal) {
        if (decimal <= 0) {
            return value;
        }
        double p = Math.pow(10.0, decimal);
        return Math.floor(value *= p) / p;
    }

    public static double round(double value, int decimal) {
        if (decimal <= 0) {
            return value;
        }
        double p = Math.pow(10.0, decimal);
        return (double)Math.round(value *= p) / p;
    }

    public static String[] splitString(String originalName) {
        String[] l = null;
        if (originalName == null) {
            return l;
        }
        if (Pattern.compile("/").matcher(originalName).find()) {
            l = originalName.split("/", 0);
        } else if (Pattern.compile("\\\\").matcher(originalName).find()) {
            l = originalName.split("\\\\", 0);
        }
        return l;
    }

    public static String getStringSeparator(String originalName) {
        if (originalName == null) {
            return null;
        }
        String[] l = null;
        if (Pattern.compile("/").matcher(originalName).find()) {
            l = originalName.split("/", 0);
            if (l.length > 0) {
                return "/";
            }
        } else if (Pattern.compile("\\\\").matcher(originalName).find() && (l = originalName.split("\\\\", 0)).length > 0) {
            return "\\";
        }
        return null;
    }

    public static JPanel buildCollapsePanel(String title) {
        if (title == null) {
            title = "";
        }
        JPanel p = new JPanel();
        p.setBorder(new TitledLineBorder(title));
        return p;
    }

    public static void setBoldTitledBorder(String title, JComponent p) {
        if (title == null) {
            title = "";
        }
        if (p == null) {
            return;
        }
        TitledBorder border = new TitledBorder(title);
        border.setTitleFont(p.getFont().deriveFont(1));
        p.setBorder(border);
    }

    public static String formatURL(String url) {
        if (url == null) {
            url = "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        buf.append("<a href=\"");
        buf.append(url);
        buf.append("\"");
        buf.append(">");
        buf.append(url);
        buf.append("</a>");
        buf.append("</body></html>");
        return buf.toString();
    }

    public static String formatFileSize(long v) {
        return FileUtils.byteCountToDisplaySize((long)v);
    }

    public static JXDatePicker createDatePicker(boolean editable, String dateFormat) {
        String[] dateFormats = new String[]{dateFormat};
        JXDatePicker picker = new JXDatePicker();
        picker.setToolTipText(DATE_TOOLTIP);
        picker.setFormats(dateFormats);
        picker.getEditor().setBackground(BACKGROUND);
        picker.getEditor().setEditable(editable);
        return picker;
    }

    public static JXDatePicker createDatePicker() {
        return UIUtilities.createDatePicker(true);
    }

    public static JXDatePicker createDatePicker(boolean editable) {
        return UIUtilities.createDatePicker(editable, DATE_FORMAT);
    }

    public static List<String> wrapStyleWord(String text) {
        return UIUtilities.wrapStyleWord(text, 50);
    }

    public static List<String> wrapStyleWord(String text, int maxWidth) {
        ArrayList<String> l = new ArrayList<String>();
        if (text == null) {
            return l;
        }
        text = text.trim();
        if (maxWidth <= 0) {
            maxWidth = 50;
        }
        String sep = " ";
        String[] values = text.split(sep);
        Object v = "";
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            String tmp = (String)v + sep + value;
            if (tmp.length() < maxWidth) {
                v = (String)v + sep + value;
                continue;
            }
            l.add((String)v);
            v = value;
        }
        if (!((String)v).equals("")) {
            l.add((String)v);
        }
        return l;
    }

    public static JXTaskPane createTaskPane(String title, Color background) {
        JXTaskPane taskPane = new JXTaskPane();
        taskPane.setAnimated(false);
        Container c = taskPane.getContentPane();
        if (background != null) {
            c.setBackground(background);
            taskPane.setBackground(background);
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        taskPane.setTitle(title);
        taskPane.setCollapsed(true);
        Font font = taskPane.getFont();
        taskPane.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        return taskPane;
    }

    public static JLabel createComponent(Color c) {
        return (JLabel)UIUtilities.createComponent(JLabel.class, c);
    }

    public static JComponent createComponent(Class type, Color color) {
        if (type == null) {
            type = JLabel.class;
        }
        JComponent comp = null;
        if (JLabel.class.equals(type)) {
            comp = new JLabel();
        } else if (OMETextField.class.equals(type)) {
            comp = new OMETextField();
        } else if (OMETextArea.class.equals(type)) {
            comp = new OMETextArea();
        } else if (NumericalTextField.class.equals(type)) {
            comp = new NumericalTextField();
            ((NumericalTextField)comp).setHorizontalAlignment(2);
            ((NumericalTextField)comp).setNegativeAccepted(true);
            comp.setBorder(null);
        }
        if (comp == null) {
            comp = new JLabel();
        }
        comp.setBackground(BACKGROUND_COLOR);
        Font font = comp.getFont();
        comp.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        if (color != null) {
            comp.setForeground(color);
        }
        return comp;
    }

    public static Number extractNumber(String value, Class type) {
        if (value == null) {
            return null;
        }
        try {
            if (Integer.class.equals((Object)type)) {
                return Integer.parseInt(value);
            }
            if (Float.class.equals((Object)type)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (Double.class.equals((Object)type)) {
                return Double.parseDouble(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static long getFreeMemory() {
        Runtime r = Runtime.getRuntime();
        return r.freeMemory();
    }

    public static long getTotalMemory() {
        Runtime r = Runtime.getRuntime();
        return r.totalMemory();
    }

    public static long getUsedMemory() {
        return UIUtilities.getTotalMemory() - UIUtilities.getFreeMemory();
    }

    public static JSeparator createSeparator(int h) {
        if (h <= 0) {
            h = 16;
        }
        JSeparator s = new JSeparator(1);
        Dimension d = s.getPreferredSize();
        s.setMaximumSize(new Dimension(d.width, h));
        return s;
    }

    public static String removeFileExtension(String originalName) {
        return FilenameUtils.removeExtension((String)originalName);
    }

    public static String getDisplayedFileName(String fullPath, Integer number) {
        if (fullPath == null) {
            return fullPath;
        }
        if (number == null || number < 0) {
            return fullPath;
        }
        String[] l = UIUtilities.splitString(fullPath);
        String extension = null;
        if (fullPath.endsWith("\\")) {
            extension = "\\";
        } else if (fullPath.endsWith("/")) {
            extension = "/";
        }
        String start = null;
        if (fullPath.startsWith("\\")) {
            start = "\\";
        } else if (fullPath.startsWith("/")) {
            start = "/";
        }
        String sep = UIUtilities.getStringSeparator(fullPath);
        if (sep == null) {
            sep = "";
        }
        Object text = "";
        int folder = -1;
        if (number != null && number >= 0) {
            folder = number;
        }
        if (folder == -1) {
            return null;
        }
        if (l != null && l.length > 1) {
            int n = 0;
            if (folder < l.length) {
                n = l.length - folder - 2;
            }
            if (n < 0) {
                n = 0;
            }
            int m = l.length - 1;
            for (int i = l.length - 1; i > n; --i) {
                text = i == m ? l[i] : l[i] + sep + (String)text;
            }
            if (n == 0 && start != null) {
                text = start + (String)text;
            }
            if (extension != null) {
                text = (String)text + extension;
            }
            return text;
        }
        return null;
    }

    public static String formatString(String name, int max) {
        if (name == null) {
            return "";
        }
        if (max <= 0) {
            max = 40;
        }
        StringBuffer buf = new StringBuffer();
        int index = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (index == max) {
                index = 0;
                buf.append("<br>");
            }
            buf.append(name.charAt(i));
            ++index;
        }
        return buf.toString();
    }

    public static boolean isMacOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("mac");
    }

    public static boolean isWindowsOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("windows");
    }

    public static boolean isLinuxOS() {
        return !UIUtilities.isMacOS() && !UIUtilities.isWindowsOS();
    }

    public static String getPartialName(String originalName) {
        if (originalName == null) {
            return null;
        }
        String[] l = UIUtilities.splitString(originalName);
        String extension = null;
        if (originalName.endsWith("\\")) {
            extension = "\\";
        } else if (originalName.endsWith("/")) {
            extension = "/";
        }
        String sep = UIUtilities.getStringSeparator(originalName);
        if (sep == null) {
            sep = "";
        }
        if (l != null) {
            int n = l.length;
            switch (n) {
                case 0: {
                    return originalName;
                }
                case 1: {
                    if (extension != null) {
                        return l[0] + extension;
                    }
                    return l[0];
                }
                case 2: {
                    if (extension != null) {
                        return l[n - 2] + sep + l[n - 1] + extension;
                    }
                    return l[n - 2] + sep + l[n - 1];
                }
            }
            for (int i = 0; i < l.length; ++i) {
                if (UIUtilities.isTextOnly(l[i])) continue;
                return originalName;
            }
            if (extension != null) {
                return DOTS + l[n - 2] + sep + l[n - 1] + extension;
            }
            return DOTS + l[n - 2] + sep + l[n - 1];
        }
        return originalName;
    }

    public static int convertColor(Color c) {
        int alpha = c.getAlpha();
        if (alpha == 0) {
            alpha = 255;
        }
        return (alpha & 0xFF) << 24 | (c.getRed() & 0xFF) << 16 | (c.getGreen() & 0xFF) << 8 | (c.getBlue() & 0xFF) << 0;
    }

    public static String listToCSV(List<String> list) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            buffer.append(list.get(i));
            if (i >= list.size() - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    public static List<String> CSVToList(String str) {
        String[] valueString;
        ArrayList<String> list = new ArrayList<String>();
        for (String value : valueString = str.split(",")) {
            if (value.equals("[]")) continue;
            list.add(value);
        }
        return list;
    }

    public static String toUnix(String path) {
        return path.replace('\\', '/');
    }

    public static int ceilingPow2(int n) {
        int pow2;
        for (pow2 = 1; n > pow2; pow2 <<= 1) {
        }
        return pow2;
    }

    public static String printErrorText(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static String formatExceptionForToolTip(Throwable ex) {
        return UIUtilities.formatExceptionForToolTip(ex, 20);
    }

    public static String formatExceptionForToolTip(Throwable ex, int n) {
        String[] values;
        if (ex == null) {
            return "";
        }
        if (n <= 0) {
            n = 20;
        }
        String s = ex.getCause() != null ? UIUtilities.printErrorText(ex.getCause()) : UIUtilities.printErrorText(ex);
        String[] lines = values = s.split("\n");
        if (values.length > 20) {
            lines = new String[21];
            for (int i = 0; i < lines.length - 1; ++i) {
                lines[i] = values[i];
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(DOTS);
            buffer.append(values.length - 20);
            buffer.append(" more");
            lines[lines.length - 1] = buffer.toString();
        }
        return UIUtilities.formatToolTipText(lines);
    }

    public static boolean isSameColors(Color c1, Color c2, boolean alpha) {
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.getRed() != c2.getRed()) {
            return false;
        }
        if (c1.getGreen() != c2.getGreen()) {
            return false;
        }
        if (c1.getBlue() != c2.getBlue()) {
            return false;
        }
        return !alpha || c1.getAlpha() == c2.getAlpha();
    }

    public static JButton createHyperLinkButton(String text) {
        if (text == null || text.trim().length() == 0) {
            text = "hyperlink";
        }
        JButton b = new JButton(text);
        Font f = b.getFont();
        b.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        b.setOpaque(false);
        b.setForeground(HYPERLINK_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(b);
        return b;
    }

    public static JMenuItem createHyperLinkMenuItem(String text) {
        if (text == null || text.trim().length() == 0) {
            text = "hyperlink";
        }
        JMenuItem b = new JMenuItem(text);
        b.setOpaque(false);
        b.setForeground(HYPERLINK_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(b);
        return b;
    }

    public static String convertFont(String family) {
        if (family == null) {
            return "";
        }
        String value = FONTS.get(family);
        if (CommonsLangUtils.isBlank(value)) {
            return "";
        }
        return value;
    }

    public static JTextPane buildExceptionArea() {
        StyleContext context = new StyleContext();
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        ArrayList<TabStop> list = new ArrayList<TabStop>();
        float pos = 15.0f;
        int align = 0;
        int leader = 0;
        TabStop tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 1;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 2;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 4;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        TabSet tabs = new TabSet(list.toArray(new TabStop[0]));
        Style style = textPane.getLogicalStyle();
        StyleConstants.setTabSet(style, tabs);
        textPane.setLogicalStyle(style);
        Style debugStyle = document.addStyle("StyleName", null);
        StyleConstants.setForeground(debugStyle, Color.BLACK);
        StyleConstants.setFontFamily(debugStyle, "SansSerif");
        StyleConstants.setFontSize(debugStyle, 12);
        StyleConstants.setBold(debugStyle, false);
        return textPane;
    }

    public static int convertRgbaToArgb(int rgba) {
        return rgba >>> 8 | rgba << 24;
    }

    public static int convertArgbToRgba(int argb) {
        return argb << 8 | argb >>> 24;
    }

    public static int getColorRange(Color color) {
        if (color == null) {
            return -1;
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        if (g < r / 2 && b < r / 2) {
            return 0;
        }
        if (r < g / 2 && b < g / 2) {
            return 1;
        }
        return 2;
    }

    public static String formatPartialName(String name, int numberOfCharacters) {
        if (name == null) {
            return null;
        }
        int n = DOTS.length() + numberOfCharacters;
        int m = name.length();
        if (m <= n) {
            return name;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(DOTS);
        buffer.append(name.substring(m - n, m));
        return buffer.toString();
    }

    public static String formatPartialName2(String name, int numberOfCharacters) {
        if (name == null) {
            return null;
        }
        if (name.length() <= numberOfCharacters) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfCharacters - 3; ++i) {
            sb.append(name.charAt(i));
        }
        sb.append(DOTS);
        return sb.toString();
    }

    public static String formatPartialName(String name) {
        return UIUtilities.formatPartialName(name, 30);
    }

    public static JButton formatButtonFromAction(Action a) {
        JButton button = new JButton();
        button.setToolTipText((String)a.getValue("ShortDescription"));
        button.setIcon((Icon)a.getValue("SmallIcon"));
        return button;
    }

    public static Length transformSize(double value) {
        return UIUtilities.transformSize((Length)new LengthI(value, UnitsLength.MICROMETER));
    }

    public static Length transformSize(Length value) {
        if (value.getUnit().equals((Object)UnitsLength.MICROMETER)) {
            double v = value.getValue();
            UnitsLength unit = UnitsLength.MICROMETER;
            if (v > 0.0 && v < 0.1) {
                unit = UnitsLength.NANOMETER;
                if ((v *= 1000.0) < 1.0) {
                    unit = UnitsLength.ANGSTROM;
                    v *= 10.0;
                }
                return new LengthI(v, unit);
            }
            if (v > 1000.0) {
                unit = UnitsLength.MILLIMETER;
                v /= 1000.0;
            }
            if (v > 1000.0) {
                unit = UnitsLength.CENTIMETER;
                v /= 1000.0;
            }
            if (v > 1000.0) {
                unit = UnitsLength.METER;
                v /= 1000.0;
            }
            return new LengthI(v, unit);
        }
        return value;
    }

    public static Length transformSquareSize(Length value) {
        if (value.getUnit().equals((Object)UnitsLength.MICROMETER)) {
            double v = value.getValue();
            double pow = Math.pow(10.0, 6.0);
            UnitsLength unit = UnitsLength.MICROMETER;
            if (v > 0.0 && v < 0.1) {
                unit = UnitsLength.NANOMETER;
                if ((v *= pow) < 100.0) {
                    unit = UnitsLength.ANGSTROM;
                    v *= 100.0;
                }
                return new LengthI(v, unit);
            }
            if (v > pow) {
                unit = UnitsLength.MILLIMETER;
                v /= pow;
            }
            if (v > pow) {
                unit = UnitsLength.CENTIMETER;
                v /= pow;
            }
            if (v > pow) {
                unit = UnitsLength.METER;
                v /= pow;
            }
            return new LengthI(v, unit);
        }
        return value;
    }

    public static String formatValue(Length value) {
        return UIUtilities.formatValue(value, false);
    }

    public static String formatValue(double value) {
        return UIUtilities.formatValue((Length)new LengthI(value, UnitsLength.MICROMETER), false);
    }

    public static String formatValue(Length value, boolean squared) {
        Length converted;
        Length length = converted = squared ? UIUtilities.transformSquareSize(value) : UIUtilities.transformSize(value);
        Object v = value.getUnit().equals((Object)UnitsLength.PIXEL) ? (value.getValue() == 0.0 ? null : "" + (int)value.getValue()) : UIUtilities.twoDecimalPlaces(converted.getValue());
        if (v == null) {
            return "";
        }
        v = (String)v + ((LengthI)converted).getSymbol();
        if (squared && !value.getUnit().equals((Object)UnitsLength.PIXEL)) {
            v = (String)v + SQUARED_SYMBOL;
        }
        return v;
    }

    public static String formatValueNoUnit(Length value, boolean squared) {
        Length converted;
        Length length = converted = squared ? UIUtilities.transformSquareSize(value) : UIUtilities.transformSize(value);
        Object v = value.getUnit().equals((Object)UnitsLength.PIXEL) ? (value.getValue() == 0.0 ? null : "" + (int)value.getValue()) : UIUtilities.twoDecimalPlaces(converted.getValue());
        if (v == null) {
            return "";
        }
        return v;
    }

    public static Number formatValueNoUnitAsNumber(Length value, boolean squared) {
        Length converted;
        Length length = converted = squared ? UIUtilities.transformSquareSize(value) : UIUtilities.transformSize(value);
        if (value.getUnit().equals((Object)UnitsLength.PIXEL)) {
            return value.getValue() == 0.0 ? null : Double.valueOf(value.getValue());
        }
        Number n = UIUtilities.twoDecimalPlacesAsNumber(converted.getValue());
        if (n.doubleValue() == 0.0) {
            return null;
        }
        return n;
    }

    public static String formatTimeInSeconds(int v) {
        if (v <= 0) {
            return "";
        }
        int hours = v / 3600;
        int remainder = v % 3600;
        int minutes = remainder / 60;
        int seconds = remainder % 60;
        StringBuffer text = new StringBuffer();
        if (hours > 0) {
            text.append(hours);
            text.append("h");
        }
        if (minutes > 0) {
            text.append(minutes);
            text.append("min");
            if (seconds > 0) {
                text.append(seconds);
                text.append("s");
            }
        } else {
            text.append(seconds);
            text.append("s");
        }
        return text.toString();
    }

    public static String truncate(String name, int maxLength, boolean start) {
        if (name == null) {
            return "";
        }
        int v = maxLength + DOTS.length();
        int n = name.length();
        if (n > v) {
            --n;
            if (start) {
                return DOTS + name.substring(n - maxLength, n);
            }
            return name.substring(0, maxLength) + DOTS;
        }
        return name;
    }

    public static File generateFileName(File folder, String name, String ext) {
        int i = 0;
        File file = new File(folder, name + "." + ext);
        while (file.exists()) {
            file = new File(folder, name + "(" + ++i + ")." + ext);
        }
        return file;
    }

    public static void addFiller(JComponent component, GridBagConstraints c, boolean vertical) {
        if (!(component.getLayout() instanceof GridBagLayout)) {
            throw new IllegalArgumentException("Component does not use GridBagLayout!");
        }
        double weightx = c.weightx;
        double weighty = c.weighty;
        int fill = c.fill;
        c.weightx = vertical ? c.weightx : 1.0;
        c.weighty = vertical ? 1.0 : c.weighty;
        c.fill = 1;
        JPanel filler = new JPanel();
        filler.setBackground(BACKGROUND_COLOR);
        component.add((Component)filler, c);
        c.weightx = weightx;
        c.weighty = weighty;
        c.fill = fill;
        if (vertical) {
            ++c.gridy;
        } else {
            ++c.gridx;
        }
    }

    public static Component findParent(Component comp, Class c) {
        if (c == null || comp == null) {
            throw new IllegalArgumentException("The parameters cannot be null");
        }
        if (c.isAssignableFrom(comp.getClass())) {
            return comp;
        }
        if (comp instanceof Container) {
            Container parent = ((Container)comp).getParent();
            if (parent == null) {
                return null;
            }
            if (parent.getClass().equals(c)) {
                return parent;
            }
            return UIUtilities.findParent(parent, c);
        }
        return null;
    }

    public static void copyToClipboard(String value) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        StringSelection strSel = new StringSelection(value);
        clipboard.setContents(strSel, null);
    }

    public static String replaceWindowsPathSeparator(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static String replaceNonWordCharacters(String name) {
        return name.replaceAll("\\W", "_");
    }

    public static void applyGnome3Workaround(Component c) {
        if (!GNOME) {
            return;
        }
        boolean undecorated = false;
        if (c instanceof Dialog) {
            undecorated = ((Dialog)c).isUndecorated();
        }
        if (c instanceof Frame) {
            undecorated = ((Frame)c).isUndecorated();
        }
        if (undecorated) {
            Dimension size = c.getSize();
            c.setSize(new Dimension(size.width + 1, size.height + 1));
        }
    }

    static {
        LIGHT_GREY = new Color(200, 200, 200);
        HYPERLINK_COLOR = Color.BLUE;
        BACKGROUND_COLOR = Color.WHITE;
        REQUIRED_FIELDS_COLOR = Color.RED;
        WINDOW_BACKGROUND_COLOR = new Color(248, 248, 248);
        EDITED_COLOR = Color.red;
        DEFAULT_FONT_COLOR = Color.GRAY;
        INNER_BORDER_HIGHLIGHT = new Color(240, 240, 240);
        INNER_BORDER_SHADOW = new Color(200, 200, 200);
        BACKGROUND_COLOUR_EVEN = new Color(232, 242, 254);
        BACKGROUND_COLOUR_ODD = new Color(255, 255, 255);
        SELECTED_BACKGROUND_COLOUR = new Color(180, 213, 255);
        FOREGROUND_COLOUR = new Color(0, 0, 0);
        TRACK_GRADIENT_START = new Color(76, 76, 76);
        TRACK_GRADIENT_END = new Color(176, 176, 176);
        LINE_COLOR = Color.BLACK;
        HIGHLIGHT = new Color(204, 255, 204);
        BACKGROUND = Color.WHITE;
        BACKGROUND_ONE = new Color(236, 243, 254);
        STEELBLUE = new Color(4620980);
        DEFAULT_TEXT = Color.WHITE;
        CHARACTERS = new ArrayList<String>();
        CHARACTERS.add("[");
        CHARACTERS.add("]");
        CHARACTERS.add("\"");
        LETTERS = new HashMap<Integer, String>();
        LETTERS.put(1, "A");
        LETTERS.put(2, "B");
        LETTERS.put(3, "C");
        LETTERS.put(4, "D");
        LETTERS.put(5, "E");
        LETTERS.put(6, "F");
        LETTERS.put(7, "G");
        LETTERS.put(8, "H");
        LETTERS.put(9, "I");
        LETTERS.put(10, "J");
        LETTERS.put(11, "K");
        LETTERS.put(12, "L");
        LETTERS.put(13, "M");
        LETTERS.put(14, "N");
        LETTERS.put(15, "O");
        LETTERS.put(16, "P");
        LETTERS.put(17, "Q");
        LETTERS.put(18, "R");
        LETTERS.put(19, "S");
        LETTERS.put(20, "T");
        LETTERS.put(21, "U");
        LETTERS.put(22, "V");
        LETTERS.put(23, "W");
        LETTERS.put(24, "X");
        LETTERS.put(25, "Y");
        LETTERS.put(26, "Z");
        LETTERS.put(27, "AA");
        LETTERS.put(28, "AB");
        LETTERS.put(29, "AC");
        LETTERS.put(30, "AD");
        LETTERS.put(31, "AE");
        LETTERS.put(32, "AF");
        LETTERS.put(33, "AG");
        LETTERS.put(34, "AH");
        LETTERS.put(35, "AI");
        LETTERS.put(36, "AJ");
        LETTERS.put(37, "AK");
        LETTERS.put(38, "AL");
        LETTERS.put(39, "AM");
        LETTERS.put(40, "AN");
        LETTERS.put(41, "AO");
        LETTERS.put(42, "AP");
        LETTERS.put(43, "AQ");
        LETTERS.put(44, "AR");
        LETTERS.put(45, "AS");
        LETTERS.put(46, "AT");
        LETTERS.put(47, "AU");
        LETTERS.put(48, "AV");
        LETTERS.put(49, "AW");
        LETTERS.put(50, "AX");
        LETTERS.put(51, "AY");
        LETTERS.put(52, "AZ");
        LETTERS.put(53, "BA");
        LETTERS.put(54, "BB");
        LETTERS.put(55, "BC");
        LETTERS.put(56, "BD");
        LETTERS.put(57, "BE");
        LETTERS.put(58, "BF");
        LETTERS.put(59, "BG");
        LETTERS.put(60, "BH");
        LETTERS.put(61, "BI");
        LETTERS.put(62, "BJ");
        LETTERS.put(63, "BK");
        LETTERS.put(64, "BL");
        LETTERS.put(65, "BM");
        LETTERS.put(66, "BN");
        LETTERS.put(67, "BO");
        LETTERS.put(68, "BP");
        LETTERS.put(69, "BQ");
        LETTERS.put(70, "BR");
        LETTERS.put(71, "BS");
        LETTERS.put(72, "BT");
        LETTERS.put(73, "BU");
        LETTERS.put(74, "BV");
        LETTERS.put(75, "BW");
        LETTERS.put(76, "BX");
        LETTERS.put(77, "BY");
        LETTERS.put(78, "BZ");
        FONTS = new HashMap<String, String>();
        FONTS.put("Arial", "sans-serif");
        FONTS.put("Arial Black", "sans-serif");
        FONTS.put("Book Antiqua", "serif");
        FONTS.put("Charcoal", "sans-serif");
        FONTS.put("Comic Sans", "cursive");
        FONTS.put("Comic Sans MS", "cursive");
        FONTS.put("Courier", "monospace");
        FONTS.put("Courier New", "monospace");
        FONTS.put("Gadget", "sans-serif");
        FONTS.put("Geneva", "sans-serif");
        FONTS.put("Georgia", "serif");
        FONTS.put("Helvetica", "sans-serif");
        FONTS.put("Impact", "sans-serif");
        FONTS.put("Lucida Console", "monospace");
        FONTS.put("Lucida Grande", "sans-serif");
        FONTS.put("Lucida Sans Unicode", "sans-serif");
        FONTS.put("Monaco", "monospace");
        FONTS.put("MS Sans Serif", "sans-serif");
        FONTS.put("MS Serif", "serif");
        FONTS.put("New York", "serif");
        FONTS.put("Palatino", "serif");
        FONTS.put("Palatino Linotype", "serif");
        FONTS.put("Tahoma", "sans-serif");
        FONTS.put("Times", "serif");
        FONTS.put("Times New Roman", "serif");
        FONTS.put("Trebuchet MS", "sans-serif");
        FONTS.put("Verdana", "sans-serif");
        FONTS.put("Roman", "serif");
        FONTS.put("Swis", "sans-serif");
        FONTS.put("Script", "cursive");
        FONTS.put("Decorative", "fantasy");
        FONTS.put("serif", "serif");
        FONTS.put("sans-serif", "sans-serif");
        FONTS.put("cursive", "cursive");
        FONTS.put("fantasy", "fantasy");
        FONTS.put("monospace", "monospace");
        FONTS.put("Andale Mono", "sans-serif");
        FONTS.put("Antiqua", "serif");
        FONTS.put("Avqest", "serif");
        FONTS.put("Blackletter", "serif");
        FONTS.put("Calibri", "sans-serif");
        FONTS.put("Fraktur", "serif");
        FONTS.put("Frosty", "serif");
        FONTS.put("Garamond", "serif");
        FONTS.put("Minion", "serif");
        FONTS.put("Monotype.com", "sans-serif");
        FONTS.put("Bitstream Vera Sans", "sans-serif");
        FONTS.put("Bitstream Vera Sans Mono", "monospace");
        FONTS.put("Bitstream Vera Serif", "serif");
        FONTS.put("Caslon Roman", "serif");
        FONTS.put("Charis SIL", "serif");
        FONTS.put("DejaVu Sans", "sans-serif");
        FONTS.put("DejaVu Sans Mono", "monospace");
        FONTS.put("DejaVu Serif", "serif");
        FONTS.put("Doulos SIL", "serif");
        FONTS.put("Droid Sans", "sans-serif");
        FONTS.put("Droid Sans Mono", "monospace");
        FONTS.put("Droid Serif", "serif");
        FONTS.put("FreeMono", "monospace");
        FONTS.put("FreeSans", "sans-serif");
        FONTS.put("FreeSerif", "serif");
        FONTS.put("Gentium", "serif");
        FONTS.put("GNU Unifont", "monospace");
        FONTS.put("Junicode", "serif");
        FONTS.put("Liberation Mono", "monospace");
        FONTS.put("Liberation Sans", "sans-serif");
        FONTS.put("Liberation Sans Narrow", "sans-serif");
        FONTS.put("Liberation Serif", "serif");
        FONTS.put("Linux Biolinum", "sans-serif");
        FONTS.put("Linux Libertine", "serif");
        FONTS.put("Luxi Mono", "monospace");
        FONTS.put("Luxi Sans", "sans-serif");
        FONTS.put("Luxi Serif", "serif");
        FONTS.put("American Typewriter", "serif");
        FONTS.put("Apple Casual", "cursive");
        FONTS.put("Apple Chancery", "cursive");
        FONTS.put("Apple Garamond", "serif");
        FONTS.put("Baskerville", "serif");
        FONTS.put("Big Caslon", "serif");
        FONTS.put("Brush Script", "cursive");
        FONTS.put("Chalkboard", "sans-serif");
        FONTS.put("Chicago", "sans-serif");
        FONTS.put("Cochin", "serif");
        FONTS.put("Cooper", "serif");
        FONTS.put("Copperplate", "serif");
        FONTS.put("Didot", "serif");
        FONTS.put("Futura", "sans-serif");
        FONTS.put("Gill Sans", "sans-serif");
        FONTS.put("Helvetica Neue", "sans-serif");
        FONTS.put("Herculanum", "cursive");
        FONTS.put("Hoefler Text", "serif");
        FONTS.put("LiSong Pro", "serif");
        FONTS.put("Marker Felt", "cursive");
        FONTS.put("Menlo", "sans-serif");
        FONTS.put("New York", "sans-serif");
        FONTS.put("Optima", "sans-serif");
        FONTS.put("Papyrus", "sans-serif");
        FONTS.put("Sand", "cursive");
        FONTS.put("Skia", "sans-serif");
        FONTS.put("Techno", "sans-serif");
        FONTS.put("Textile", "cursive");
        FONTS.put("Zapf Chancery", "cursive");
        FONTS.put("Zapfino", "cursive");
        String desktop = System.getenv("XDG_CURRENT_DESKTOP");
        GNOME = desktop != null && desktop.toLowerCase().contains("gnome");
    }
}

