/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2D;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.FigureUtil;
import org.openmicroscopy.shoola.util.ui.drawingtools.texttools.DrawingTextTool;

public class RectangleTextFigure
extends RectangleFigure
implements TextHolderFigure {
    private boolean fromAttributeUpdate;
    private boolean editable;
    private Rectangle2D.Double textBounds;

    public RectangleTextFigure() {
        this("", 0.0, 0.0, 0.0, 0.0);
    }

    public RectangleTextFigure(String text) {
        this(text, 0.0, 0.0, 0.0, 0.0);
    }

    public RectangleTextFigure(String text, double x, double y, double w, double h) {
        super(x, y, w, h);
        this.setAttributeEnabled(AttributeKeys.TEXT_COLOR, true);
        this.setAttribute(AttributeKeys.TEXT, text);
        this.textBounds = null;
        this.editable = true;
        this.fromAttributeUpdate = false;
    }

    protected Rectangle2D.Double getTextBounds() {
        if (this.textBounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return this.textBounds;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    protected void drawFill(Graphics2D g) {
        super.drawFill(g);
        this.drawText(g);
    }

    public void setAttribute(AttributeKey key, Object newValue) {
        Rectangle2D.Double newBounds;
        Rectangle2D.Double bounds;
        super.setAttribute(key, newValue);
        if (MeasurementAttributes.HEIGHT.getKey().equals(key.getKey())) {
            double newHeight = (Double)MeasurementAttributes.HEIGHT.get((Figure)this);
            bounds = this.getBounds();
            double centreY = bounds.getCenterY();
            double diffHeight = newHeight / 2.0;
            newBounds = new Rectangle2D.Double(bounds.getX(), centreY - diffHeight, bounds.getWidth(), newHeight);
            this.fromAttributeUpdate = true;
            this.setBounds(newBounds);
            this.fromAttributeUpdate = false;
        }
        if (MeasurementAttributes.WIDTH.getKey().equals(key.getKey())) {
            double newWidth = (Double)MeasurementAttributes.WIDTH.get((Figure)this);
            bounds = this.getBounds();
            double centreX = bounds.getCenterX();
            double diffWidth = newWidth / 2.0;
            newBounds = new Rectangle2D.Double(centreX - diffWidth, bounds.getY(), newWidth, bounds.getHeight());
            this.fromAttributeUpdate = true;
            this.setBounds(newBounds);
            this.fromAttributeUpdate = false;
        }
    }

    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        super.setBounds(anchor, lead);
        if (!this.fromAttributeUpdate) {
            MeasurementAttributes.HEIGHT.set((Figure)this, (Object)this.getBounds().getHeight());
            MeasurementAttributes.WIDTH.set((Figure)this, (Object)this.getBounds().getWidth());
        }
    }

    protected void drawText(Graphics2D g) {
        if (!((Boolean)DrawingAttributes.SHOWTEXT.get((Figure)this)).booleanValue()) {
            return;
        }
        String text = this.getText();
        if (text != null) {
            double textWidth;
            if ((text = text.trim()).length() == 0) {
                return;
            }
            Font font = (Font)AttributeKeys.FONT_FACE.get((Figure)this);
            font = font.deriveFont(((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).floatValue());
            FontMetrics fm = g.getFontMetrics(font);
            double width = textWidth = (double)fm.stringWidth(text);
            double avgCharWidth = textWidth / (double)text.length();
            double maxTextWidth = avgCharWidth * 100.0;
            if (textWidth > maxTextWidth) {
                width = maxTextWidth;
            }
            double textHeight = (textWidth / width + 1.0) * (double)(fm.getAscent() + fm.getDescent() + fm.getLeading());
            double x = this.rectangle.x + this.rectangle.width / 2.0 - width / 2.0;
            double y = this.rectangle.y + textHeight / 2.0;
            this.textBounds = new Rectangle2D.Double(x, y, width, textHeight);
            FontRenderContext frc = g.getFontRenderContext();
            AttributedString styledText = new AttributedString(text);
            FigureUtil.formatLayout(font, styledText, (Figure)this);
            AttributedCharacterIterator i = styledText.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(i, frc);
            Color c = (Color)AttributeKeys.STROKE_COLOR.get((Figure)this);
            if (c != null) {
                g.setColor(c);
            }
            int w = (int)width;
            while (measurer.getPosition() < text.length()) {
                TextLayout layout = measurer.nextLayout(w);
                layout.draw(g, (float)x, (float)(y += (double)layout.getAscent()));
                y += (double)(layout.getDescent() + layout.getLeading());
            }
        }
    }

    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        double grow = AttributeKeys.getPerpendicularHitGrowth((Figure)this) + 1.0;
        Geom.grow((Rectangle2D.Double)r, (double)grow, (double)grow);
        r.add(this.getTextBounds());
        return r;
    }

    public void invalidate() {
        super.invalidate();
    }

    public void validate() {
        super.validate();
    }

    public Tool getTool(Point2D.Double p) {
        if (this.isEditable() && this.contains(p)) {
            this.invalidate();
            return new DrawingTextTool(this);
        }
        return null;
    }

    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    public void setText(String newText) {
        boolean b = newText != null && newText.trim().length() > 0;
        this.setAttribute(DrawingAttributes.SHOWTEXT, b);
        this.setAttribute(AttributeKeys.TEXT, newText);
    }

    public int getTextColumns() {
        String t = this.getText();
        int n = 4;
        return t == null ? n : Math.max(t.length(), n);
    }

    public int getTabSize() {
        return 8;
    }

    public TextHolderFigure getLabelFor() {
        return this;
    }

    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    public Font getFont() {
        return AttributeKeys.getFont((Figure)this);
    }

    public Color getTextColor() {
        return (Color)AttributeKeys.TEXT_COLOR.get((Figure)this);
    }

    public Color getFillColor() {
        return (Color)AttributeKeys.FILL_COLOR.get((Figure)this);
    }

    public float getFontSize() {
        return ((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).floatValue();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setFontSize(float size) {
    }

    public boolean isTextOverflow() {
        return false;
    }

    public RectangleTextFigure clone() {
        RectangleTextFigure that = (RectangleTextFigure)super.clone();
        that.setText(this.getText());
        return that;
    }
}

