/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.filechooser;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.RegExFileFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.filechooser.FileSaverUI;
import org.openmicroscopy.shoola.util.ui.filechooser.GenericFileChooser;

class CustomizedFileChooser
extends GenericFileChooser
implements DocumentListener,
KeyListener {
    private static final String LOAD_LABEL = "Load:";
    private static final String FOLDER_LABEL = "Save in:";
    private FileChooser model;
    private FileSaverUI view;
    private JTextField nameArea;
    private RegExFileFilter filter;
    private String originalName;

    private void initComponents(boolean accept) {
        this.originalName = "";
        this.setAcceptAllFileFilterUsed(accept);
        this.nameArea = (JTextField)UIUtilities.findComponent(this, JTextField.class);
        if (this.nameArea != null) {
            this.nameArea.setVisible(true);
            this.nameArea.getDocument().addDocumentListener(this);
        }
    }

    private void buildGUI() {
        this.setControlButtonsAreShown(this.nameArea == null);
        List<FileFilter> filters = this.model.getFilters();
        if (filters != null) {
            for (FileFilter filter : filters) {
                this.addChoosableFileFilter(filter);
            }
            if (!this.isAcceptAllFileFilterUsed()) {
                this.setFileFilter(filters.get(0));
            }
        }
        if (this.isAcceptAllFileFilterUsed()) {
            this.setFileFilter(this.getAcceptAllFileFilter());
        }
        try {
            File f = UIUtilities.getDefaultFolder();
            if (f != null) {
                this.setCurrentDirectory(f);
            }
        }
        catch (Exception f) {
            // empty catch block
        }
        switch (this.model.getChooserType()) {
            case 1: {
                this.setDialogType(1);
                this.setFileSelectionMode(0);
                break;
            }
            case 3: {
                this.setDialogType(1);
                this.setFileSelectionMode(2);
                this.setMultiSelectionEnabled(true);
                break;
            }
            case 0: {
                JLabel label = (JLabel)UIUtilities.findComponent(this, JLabel.class);
                if (label != null) {
                    label.setText(LOAD_LABEL);
                }
                this.setFileSelectionMode(0);
                break;
            }
            case 2: {
                JLabel label = (JLabel)UIUtilities.findComponent(this, JLabel.class);
                if (label != null) {
                    label.setText(FOLDER_LABEL);
                }
                this.setFileSelectionMode(1);
                this.setCurrentDirectory(this.getFileSystemView().getHomeDirectory());
            }
        }
        List<Component> comps = UIUtilities.findComponents(this, JComboBox.class);
        for (Component comp : comps) {
            JComboBox box = (JComboBox)comp;
            if (box.getItemCount() > 1) continue;
            box.setEnabled(false);
        }
    }

    private String getFormat(FileFilter selectedFilter) {
        List<FileFilter> filters = this.model.getFilters();
        if (filters == null) {
            return "";
        }
        for (FileFilter filter : filters) {
            if (!selectedFilter.equals(filter)) continue;
            return filter.getDescription();
        }
        return "";
    }

    private String getExtension(FileFilter selectedFilter) {
        List<FileFilter> filters = this.model.getFilters();
        if (filters == null) {
            return "";
        }
        for (FileFilter filter : filters) {
            if (!selectedFilter.equals(filter) || !(filter instanceof CustomizedFileFilter)) continue;
            return ((CustomizedFileFilter)filter).getExtension();
        }
        return "";
    }

    private void handleTextUpdate() {
        String text;
        if (this.nameArea == null) {
            return;
        }
        this.originalName = text = this.nameArea.getText();
        this.view.setControlsEnabled(CommonsLangUtils.isNotEmpty(text));
    }

    private Object setSelection() {
        File f = this.getSelectedFile();
        if (f == null) {
            return null;
        }
        String format = this.getExtension(this.getFileFilter());
        String fileName = f.getAbsolutePath();
        File[] l = this.getCurrentDirectory().listFiles();
        String n = this.model.getExtendedName(fileName, format);
        boolean exist = false;
        if (l != null) {
            for (int i = 0; i < l.length; ++i) {
                if (!l[i].getAbsolutePath().equals(n)) continue;
                exist = true;
                break;
            }
        }
        this.setSelectedFile(null);
        return exist;
    }

    CustomizedFileChooser(FileChooser model, FileSaverUI view, boolean accept) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.model = model;
        this.view = view;
        this.initComponents(accept);
        this.buildGUI();
    }

    void setOriginalName(String name) {
        this.originalName = name;
    }

    boolean areControlButtonsShown() {
        return this.nameArea == null;
    }

    void createFolder(String name) {
        File dir = this.getCurrentDirectory();
        new File(dir.getAbsolutePath(), name).mkdir();
    }

    File getFormattedSelectedFile() {
        File f = this.getSelectedFile();
        if (f != null) {
            String format = this.getExtension(this.getFileFilter());
            if (CommonsLangUtils.isEmpty(format)) {
                return f;
            }
            String fileName = f.getAbsolutePath();
            if (fileName.endsWith("." + format)) {
                return new File(fileName);
            }
            return new File(fileName + "." + format);
        }
        return f;
    }

    void requestFocusOnName() {
        if (this.nameArea != null) {
            String text = this.nameArea.getText();
            this.view.setControlsEnabled((text = text.trim()).length() > 0);
        }
    }

    void resetSelection() {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleTextUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleTextUpdate();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String filterString = this.nameArea.getText();
        try {
            if (this.filter == null) {
                this.filter = new RegExFileFilter(filterString, true);
                this.setFileHidingEnabled(true);
                this.setFileFilter(this.filter);
            } else {
                this.filter.setFilter(filterString, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void cancelSelection() {
        this.model.cancelSelection();
        super.cancelSelection();
    }

    @Override
    public void approveSelection() {
        if (this.model.getChooserType() == 2) {
            File f = this.getCurrentDirectory();
            if (f != null) {
                this.setSelectedFile(null);
                this.model.acceptSelection();
            }
        } else if (this.setSelection() != null) {
            this.model.acceptSelection();
        }
        super.approveSelection();
    }

    @Override
    public File getSelectedFile() {
        if (this.model == null) {
            return super.getSelectedFile();
        }
        if (this.model.getChooserType() == 2) {
            return super.getSelectedFile();
        }
        if (this.nameArea == null) {
            return super.getSelectedFile();
        }
        String name = this.nameArea.getText();
        if (CommonsLangUtils.isEmpty(name)) {
            return super.getSelectedFile();
        }
        return new File(this.getCurrentDirectory().toString(), name);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

