/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;

class LensAction
extends AbstractAction {
    static final int MAX = 11;
    static final int LENSDEFAULTSIZE = 0;
    static final int LENS40x40 = 1;
    static final int LENS50x50 = 2;
    static final int LENS60x60 = 3;
    static final int LENS70x70 = 4;
    static final int LENS80x80 = 5;
    static final int LENS90x90 = 6;
    static final int LENS100x100 = 7;
    static final int LENS120x120 = 8;
    static final int LENS150x150 = 9;
    static final int LENSMANUAL = 10;
    private static final int DEFAULT_SIZE = 50;
    private static final int SIZE_40 = 40;
    private static final int SIZE_50 = 50;
    private static final int SIZE_60 = 60;
    private static final int SIZE_70 = 70;
    private static final int SIZE_80 = 80;
    private static final int SIZE_90 = 90;
    private static final int SIZE_100 = 100;
    private static final int SIZE_120 = 120;
    private static final int SIZE_150 = 150;
    private LensComponent lens;
    private int index;
    private static String[] names = new String[11];

    private void checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported.");
    }

    static int sizeToIndex(int w, int h) {
        if (w != h) {
            return 10;
        }
        switch (w) {
            case 50: {
                return 2;
            }
            case 40: {
                return 1;
            }
            case 60: {
                return 3;
            }
            case 70: {
                return 4;
            }
            case 80: {
                return 5;
            }
            case 90: {
                return 6;
            }
            case 100: {
                return 7;
            }
            case 120: {
                return 8;
            }
            case 150: {
                return 9;
            }
        }
        return 10;
    }

    LensAction(LensComponent lens, int lensIndex) {
        if (lens == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.lens = lens;
        this.checkIndex(lensIndex);
        this.index = lensIndex;
        this.putValue("Name", names[this.index]);
    }

    int getIndex() {
        return this.index;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 0: {
                this.lens.setLensSize(50, 50);
                break;
            }
            case 1: {
                this.lens.setLensSize(40, 40);
                break;
            }
            case 2: {
                this.lens.setLensSize(50, 50);
                break;
            }
            case 3: {
                this.lens.setLensSize(60, 60);
                break;
            }
            case 4: {
                this.lens.setLensSize(70, 70);
                break;
            }
            case 5: {
                this.lens.setLensSize(80, 80);
                break;
            }
            case 6: {
                this.lens.setLensSize(90, 90);
                break;
            }
            case 7: {
                this.lens.setLensSize(100, 100);
                break;
            }
            case 8: {
                this.lens.setLensSize(120, 120);
                break;
            }
            case 9: {
                this.lens.setLensSize(150, 150);
            }
        }
    }

    static {
        LensAction.names[0] = "Default size";
        LensAction.names[1] = "40x40";
        LensAction.names[2] = "50x50";
        LensAction.names[3] = "60x60";
        LensAction.names[4] = "70x70";
        LensAction.names[5] = "80x80";
        LensAction.names[6] = "90x90";
        LensAction.names[7] = "100x100";
        LensAction.names[8] = "120x120";
        LensAction.names[9] = "150x150";
        LensAction.names[10] = "Manual";
    }
}

