/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openmicroscopy.shoola.util.ui.ColorMenuItem;
import org.openmicroscopy.shoola.util.ui.lens.DisplayAction;
import org.openmicroscopy.shoola.util.ui.lens.LensAction;
import org.openmicroscopy.shoola.util.ui.lens.LensColorAction;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;
import org.openmicroscopy.shoola.util.ui.lens.SaveAction;
import org.openmicroscopy.shoola.util.ui.lens.ZoomAction;

class LensMenu {
    private static final String POPUP_MENU_DESCRIPTION = "Magnifying Lens Options";
    private static final String POPUP_MENU_TOPOPTION = "Magnifying Lens Options";
    private static final String LENS_OPTIONS = "Lens";
    private static final String ZOOM_OPTIONS = "Zoom";
    private static final String DISPLAY_UNITS = "Units";
    private static final String LENS_COLOR_OPTIONS = "Lens Color";
    private LensComponent lensComponent;
    private JPopupMenu popupMenu;
    private JMenuBar menubar;
    private ButtonGroup lensGroup;
    private ButtonGroup zoomGroup;
    private Collection<DisplayAction> displayActions = new ArrayList<DisplayAction>();

    private JMenu createLensOptions() {
        JMenu lensOptions = new JMenu(LENS_OPTIONS);
        this.lensGroup = new ButtonGroup();
        for (int i = 0; i < 11; ++i) {
            LensAction a = new LensAction(this.lensComponent, i);
            JCheckBoxMenuItem setLensSize = new JCheckBoxMenuItem();
            setLensSize.setSelected(i == 0);
            setLensSize.setAction(a);
            this.lensGroup.add(setLensSize);
            lensOptions.add(setLensSize);
        }
        return lensOptions;
    }

    private JMenu createZoomOptions() {
        JMenu zoomOptions = new JMenu(ZOOM_OPTIONS);
        this.zoomGroup = new ButtonGroup();
        for (int i = 0; i < 11; ++i) {
            ZoomAction a = new ZoomAction(this.lensComponent, i);
            JCheckBoxMenuItem setLensZoom = new JCheckBoxMenuItem();
            setLensZoom.setSelected(i == 0);
            setLensZoom.setAction(a);
            this.zoomGroup.add(setLensZoom);
            zoomOptions.add(setLensZoom);
        }
        return zoomOptions;
    }

    private JMenu createLensColorOptions() {
        JMenu lensColorOptions = new JMenu(LENS_COLOR_OPTIONS);
        for (int indexCnt = 0; indexCnt < 12; ++indexCnt) {
            LensColorAction lensColorAction = new LensColorAction(this.lensComponent, indexCnt);
            ColorMenuItem lensColor = new ColorMenuItem(lensColorAction.getColor());
            lensColor.addActionListener(lensColorAction);
            lensColor.setText(lensColorAction.getName());
            lensColorOptions.add(lensColor);
        }
        return lensColorOptions;
    }

    private JMenu createDisplayOptions() {
        JMenu displayOptions = new JMenu(DISPLAY_UNITS);
        ButtonGroup displayUnits = new ButtonGroup();
        for (int i = 0; i < 2; ++i) {
            DisplayAction action = new DisplayAction(this.lensComponent, i);
            this.displayActions.add(action);
            JCheckBoxMenuItem setDisplayScale = new JCheckBoxMenuItem(action);
            displayUnits.add(setDisplayScale);
            displayOptions.add(setDisplayScale);
            setDisplayScale.setSelected(i == 1);
        }
        return displayOptions;
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.add(new JMenuItem(new SaveAction(this.lensComponent)));
        return menu;
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu("Magnifying Lens Options");
        this.popupMenu.add(new JMenuItem("Magnifying Lens Options"));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createFileMenu());
        this.popupMenu.add(this.createLensOptions());
        this.popupMenu.add(this.createZoomOptions());
        this.popupMenu.add(this.createDisplayOptions());
        this.popupMenu.add(this.createLensColorOptions());
    }

    private void createMenubarMenu() {
        this.menubar = new JMenuBar();
        this.menubar.add(this.createFileMenu());
        this.menubar.add(this.createLensOptions());
        this.menubar.add(this.createZoomOptions());
        this.menubar.add(this.createDisplayOptions());
        this.menubar.add(this.createLensColorOptions());
    }

    LensMenu(LensComponent lensComponent) {
        this.lensComponent = lensComponent;
        this.createPopupMenu();
        this.createMenubarMenu();
    }

    JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    JMenuBar getMenubar() {
        return this.menubar;
    }

    void setSelectedSize(int index) {
        Enumeration<AbstractButton> e = this.lensGroup.getElements();
        while (e.hasMoreElements()) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.nextElement();
            LensAction a = (LensAction)item.getAction();
            item.removeActionListener(a);
            item.setSelected(a.getIndex() == index);
            item.setAction(a);
        }
    }

    void setZoomIndex(int index) {
        Enumeration<AbstractButton> e = this.zoomGroup.getElements();
        while (e.hasMoreElements()) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.nextElement();
            ZoomAction a = (ZoomAction)item.getAction();
            item.removeActionListener(a);
            item.setSelected(a.getIndex() == index);
            item.setAction(a);
        }
    }

    void setMicronsMenuEnabled(boolean b) {
        for (DisplayAction action : this.displayActions) {
            if (action.getIndex() != 0) continue;
            action.setEnabled(b);
        }
    }
}

