/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.omeeditpane.ColourFormatter;
import org.openmicroscopy.shoola.util.ui.omeeditpane.ElementSelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.FormatSelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.Formatter;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEEditPane;
import org.openmicroscopy.shoola.util.ui.omeeditpane.SelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.URLLaunchAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiDataObject;

public class OMEWikiComponent
extends JPanel
implements ActionListener {
    public static final String WIKI_DATA_OBJECT_PROPERTY = "wikiDataObject";
    public static final String WIKI_DATA_OBJECT_ONE_CLICK_PROPERTY = "wikiDataObjectOneClick";
    public static final String TEXT_UPDATE_PROPERTY = "textUpdate";
    public static final String TEXTREGEX = "[-a-zA-Z0-9+&@#/%?~_|!:,.;\\\\]*";
    public static final String SENTENCEREGEX = "[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*";
    public static final String CHARACTERREGEX = "[a-zA-Z]+[a-zA-Z0-9]+";
    public static final String WIKILINKREGEX = "\\[\\[[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*\\]\\]";
    public static final String THUMBNAILREGEX = "\\[(Thumbnail|thumbnail):[ ]*[0-9]+[ ]*\\]";
    public static final String DATASETREGEX = "(Dataset|dataset)\\s?(ID|id)?:\\s?([0-9]+)";
    public static final String PROJECTREGEX = "(Project|project)\\s?(ID|id)?:\\s?([0-9]+)";
    public static final String IMAGEREGEX = "(Image|image|Image's)\\s?(ID|id)?:\\s?([0-9]+)";
    public static final String HEADINGREGEX = "(^[=]{3}[ ]+[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*[ ]+[=]{3}[ ]*$|^[=]{2}[ ]+[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*[ ]+[=]{2}[ ]*$|^[=]{1}[ ]+[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*[ ]+[=]{1}[ ]*$)";
    public static final String BULLETREGEX = "^\\*[ ]+[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*";
    public static final String BOLDREGEX = "'''[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*'''";
    public static final String ITALICREGEX = "''[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*''";
    public static final String ITALICBOLDREGEX = "'''''[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*'''''";
    public static final String INDENTREGEX = "^[:]+[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*$";
    public static final String URLREGEX = "(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    public static final String NAMEDLINKREGEX = "\\[(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|][ ]+[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*\\]";
    private static final int HYPERLINK = 0;
    private static final int IMAGE = 1;
    private static final int PROTOCOL = 2;
    private static final int COLUMNS = 45;
    private static Map<String, FormatSelectionAction> DEFAULT_FORMATTERS = new LinkedHashMap<String, FormatSelectionAction>();
    private OMEEditPane pane;
    private JToolBar toolBar;
    private List<JButton> toolBarActions;
    private String defaultText;
    private boolean allowOneClick;
    private boolean wrapWord;
    private int columns;

    public static String prepare(String value, boolean removeSpace) {
        String v = value.replaceAll(CommonsLangUtils.LINE_SEPARATOR, " ");
        if (removeSpace) {
            return v.replaceAll(" ", "");
        }
        return v;
    }

    private void installDefaultAction() {
        this.toolBarActions = new ArrayList<JButton>();
        IconManager icons = IconManager.getInstance();
        JButton b = new JButton(icons.getIcon(109));
        b.addActionListener(this);
        b.setActionCommand("0");
        b.setToolTipText("Create a Hyperlink");
        this.toolBarActions.add(b);
    }

    private void initComponents(Map<String, FormatSelectionAction> formatters, boolean toolbar) {
        this.columns = 45;
        this.wrapWord = true;
        this.defaultText = "";
        this.pane = new OMEEditPane(this, formatters);
        this.pane.setMaximumSize(new Dimension(100, 100));
        if (toolbar) {
            this.installDefaultAction();
            this.toolBar = new JToolBar();
            this.toolBar.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.toolBar.setBorder(null);
            this.toolBar.setFloatable(false);
            for (JButton button : this.toolBarActions) {
                this.toolBar.add(button);
            }
        }
        this.setBackground(UIUtilities.BACKGROUND);
    }

    private void buildGUI() {
        if (this.toolBar != null) {
            JPanel p = new JPanel();
            p.setBackground(UIUtilities.BACKGROUND_COLOR);
            p.setLayout(new BoxLayout(p, 1));
            p.add(Box.createVerticalStrut(5));
            JPanel bar = UIUtilities.buildComponentPanel(this.toolBar, 0, 0);
            bar.setBackground(UIUtilities.BACKGROUND_COLOR);
            p.add(bar);
            p.add(Box.createVerticalStrut(2));
            this.add((Component)p, "North");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.pane, "Center");
    }

    public OMEWikiComponent() {
        this(DEFAULT_FORMATTERS, true);
    }

    public OMEWikiComponent(boolean toolBar) {
        this(DEFAULT_FORMATTERS, toolBar);
    }

    String getDefaultText() {
        return this.defaultText;
    }

    public OMEWikiComponent(Map<String, FormatSelectionAction> formatters, boolean toolBar) {
        for (Map.Entry<String, FormatSelectionAction> formatterMap : DEFAULT_FORMATTERS.entrySet()) {
            String key = formatterMap.getKey();
            if (formatters.containsKey(key)) continue;
            formatters.put(key, formatterMap.getValue());
        }
        this.initComponents(formatters, toolBar);
        this.buildGUI();
    }

    void onSelection(SelectionAction action, String text, int count) {
        if (action == null) {
            return;
        }
        int ref = 2;
        if (!this.isEnabled()) {
            if (action instanceof URLLaunchAction && count == 1) {
                action.onSelection(text);
            } else if (action instanceof ElementSelectionAction) {
                action.onSelection(text);
                ElementSelectionAction a = (ElementSelectionAction)action;
                int index = a.getWikiDataObjectIndex();
                long id = a.getObjectID();
                if (id >= 0L) {
                    WikiDataObject object = new WikiDataObject(index, id);
                    if (this.allowOneClick) {
                        if (count == 1) {
                            this.firePropertyChange(WIKI_DATA_OBJECT_ONE_CLICK_PROPERTY, null, object);
                        } else if (count == 2) {
                            this.firePropertyChange(WIKI_DATA_OBJECT_PROPERTY, null, object);
                        }
                    } else if (count == 1) {
                        this.firePropertyChange(WIKI_DATA_OBJECT_PROPERTY, null, object);
                    }
                }
            }
        } else if (action instanceof ElementSelectionAction && count == ref) {
            action.onSelection(text);
            ElementSelectionAction a = (ElementSelectionAction)action;
            int index = a.getWikiDataObjectIndex();
            long id = a.getObjectID();
            if (id >= 0L) {
                WikiDataObject object = new WikiDataObject(index, id);
                this.firePropertyChange(WIKI_DATA_OBJECT_PROPERTY, null, object);
            }
        } else if (action instanceof URLLaunchAction) {
            if (this.allowOneClick) {
                ref = 1;
            }
            if (count == ref) {
                action.onSelection(text);
            }
        }
    }

    boolean isDefaultText(String text) {
        if (text == null) {
            return false;
        }
        return this.defaultText.equals(text.trim());
    }

    public void installObjectFormatters() {
        this.pane.addFormatter(IMAGEREGEX, new FormatSelectionAction(new ColourFormatter(Formatter.DEFAULT_LINK, false), new ElementSelectionAction(2)));
        this.pane.addFormatter(DATASETREGEX, new FormatSelectionAction(new ColourFormatter(Formatter.DEFAULT_LINK, false), new ElementSelectionAction(1)));
        this.pane.addFormatter(PROJECTREGEX, new FormatSelectionAction(new ColourFormatter(Formatter.DEFAULT_LINK, false), new ElementSelectionAction(0)));
    }

    public void setDefaultText(String text) {
        if (text == null) {
            return;
        }
        this.defaultText = text.trim();
    }

    public void selectAll() {
        this.pane.selectAll();
    }

    public void setCaretPosition(int n) {
        this.pane.setCaretPosition(n);
    }

    public void setText(String text) {
        this.pane.setText(text);
    }

    public String getText() {
        return this.pane.getText();
    }

    public void addDocumentListener(DocumentListener listener) {
        if (listener != null) {
            this.pane.getDocument().addDocumentListener(listener);
        }
    }

    public void removeDocumentListener(DocumentListener listener) {
        if (listener != null) {
            this.pane.getDocument().removeDocumentListener(listener);
        }
    }

    public void setComponentBorder(Border border) {
        this.pane.setBorder(border);
    }

    public void setAllowOneClick(boolean allowOneClick) {
        this.allowOneClick = allowOneClick;
    }

    public void setWrapWord(boolean wrapWord) {
        this.wrapWord = wrapWord;
    }

    public void wrapText(int width, String newLineStr) {
        if (this.pane == null) {
            return;
        }
        String value = this.getText();
        if (value == null) {
            return;
        }
        value = OMEWikiComponent.prepare(value, false);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int charWidth = fm.charWidth('m');
        this.columns = (int)(1.5 * (double)width) / charWidth;
        this.setText(CommonsLangUtils.wrap(value, this.columns, newLineStr, this.wrapWord));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.pane != null) {
            this.pane.setEditable(enabled);
        }
        if (this.toolBarActions != null) {
            for (JButton toolBarButton : this.toolBarActions) {
                toolBarButton.setEnabled(enabled);
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        int i;
        super.setBackground(color);
        Component[] comp = this.getComponents();
        if (comp != null) {
            for (i = 0; i < comp.length; ++i) {
                if (!(comp[i] instanceof JComponent)) continue;
                ((JComponent)comp[i]).setBackground(color);
            }
        }
        if (this.pane != null) {
            this.pane.setBackground(color);
        }
        if (this.toolBar != null) {
            this.toolBar.setBackground(color);
            comp = this.toolBar.getComponents();
            for (i = 0; i < comp.length; ++i) {
                if (!(comp[i] instanceof JComponent)) continue;
                ((JComponent)comp[i]).setBackground(color);
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        if (this.pane != null) {
            this.pane.setForeground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        if (this.pane != null) {
            this.pane.setFont(font);
        }
    }

    @Override
    public Font getFont() {
        if (this.pane == null) {
            return super.getFont();
        }
        return this.pane.getFont();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        String s = this.getText();
        switch (index) {
            case 1: {
                if (this.isDefaultText(s)) {
                    this.setText("[Image: 1]");
                } else {
                    this.setText(s + " [Image: 1]");
                }
                this.pane.requestFocus();
                break;
            }
            case 0: {
                if (this.isDefaultText(s)) {
                    this.setText("http://");
                } else {
                    this.setText(s + " http://");
                }
                this.pane.requestFocus();
                break;
            }
            case 2: {
                if (this.isDefaultText(s)) {
                    this.setText("[Protocol: 1]");
                } else {
                    this.setText(s + " [Protocol: 1]");
                }
                this.pane.requestFocus();
            }
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        this.pane.addFocusListener(l);
    }

    public Document getDocument() {
        return this.pane.getDocument();
    }

    void onUpdate() {
        this.firePropertyChange(TEXT_UPDATE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    static {
        DEFAULT_FORMATTERS.put(URLREGEX, new FormatSelectionAction(new ColourFormatter(Formatter.DEFAULT_URL, false), new URLLaunchAction()));
    }
}

