/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.DataType;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.VariableSimpleIF;

public class VariableSimpleBuilder {
    private final String name;
    private final String desc;
    private final String units;
    private final DataType dt;
    private final AttributeContainerMutable atts;
    private final ImmutableList<Dimension> dims;

    public static VariableSimpleBuilder fromMember(StructureMembers.Member m) {
        return new VariableSimpleBuilder(m.getName(), m.getDescription(), m.getUnitsString(), m.getDataType(), (List<Dimension>)Dimensions.makeDimensionsAnon(m.getShape()));
    }

    public static VariableSimpleBuilder makeScalar(String name, String desc, String units, DataType dt) {
        return new VariableSimpleBuilder(name, desc, units, dt, null);
    }

    public static VariableSimpleBuilder makeString(String name, String desc, String units, int str_len) {
        Dimension d = Dimension.builder(name + "_strlen", str_len).setIsShared(false).build();
        return new VariableSimpleBuilder(name, desc, units, DataType.CHAR, Collections.singletonList(d));
    }

    public VariableSimpleBuilder(String name, String desc, String units, DataType dt, List<Dimension> dims) {
        this.name = name;
        this.desc = desc;
        this.units = units;
        this.dt = dt;
        this.dims = dims == null || dims.size() == 0 ? ImmutableList.of() : ImmutableList.copyOf(dims);
        this.atts = new AttributeContainerMutable(name);
        if (units != null) {
            this.atts.addAttribute(new Attribute("units", units));
        }
        if (desc != null) {
            this.atts.addAttribute(new Attribute("long_name", desc));
        }
    }

    public VariableSimpleBuilder addAttribute(Attribute att) {
        this.atts.addAttribute(att);
        return this;
    }

    public VariableSimpleBuilder addAttribute(String name, String value) {
        this.atts.addAttribute(name, value);
        return this;
    }

    public VariableSimpleIF build() {
        return new VariableSimple(this);
    }

    @Immutable
    private static class VariableSimple
    implements VariableSimpleIF {
        private final String name;
        private final String desc;
        private final String units;
        private final DataType dt;
        private final AttributeContainer atts;
        private final ImmutableList<Dimension> dims;

        private VariableSimple(VariableSimpleBuilder builder) {
            this.name = builder.name;
            this.desc = builder.desc;
            this.units = builder.units;
            this.dt = builder.dt;
            this.atts = builder.atts.toImmutable();
            this.dims = builder.dims;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getFullName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getUnitsString() {
            return this.units;
        }

        @Override
        public int getRank() {
            return this.dims.size();
        }

        @Override
        public int[] getShape() {
            return Dimensions.makeShape(this.dims);
        }

        public ImmutableList<Dimension> getDimensions() {
            return this.dims;
        }

        @Override
        public DataType getDataType() {
            return this.dt;
        }

        @Override
        public AttributeContainer attributes() {
            return new AttributeContainerMutable(this.name, this.atts);
        }

        @Override
        public List<Attribute> getAttributes() {
            return this.atts.getAttributes();
        }

        @Override
        public Attribute findAttributeIgnoreCase(String name) {
            return this.atts.findAttributeIgnoreCase(name);
        }

        @Override
        public int compareTo(VariableSimpleIF o) {
            return this.name.compareTo(o.getShortName());
        }
    }
}

