/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.lang.reflect.Method;
import ome.conditions.InternalException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.event.AbstractEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMethodInterceptor
implements MethodInterceptor {
    static volatile String last = null;
    static volatile int count = 1;
    private static Logger log = LoggerFactory.getLogger(EventMethodInterceptor.class);
    protected boolean verbose = false;
    protected Action action;

    public EventMethodInterceptor() {
        this.action = new Action();
    }

    public EventMethodInterceptor(Action action) {
        this.action = action;
    }

    public void setDebug(boolean debug) {
        this.verbose = debug;
    }

    public Object invoke(MethodInvocation arg0) throws Throwable {
        Object[] args = arg0.getArguments();
        Method method = arg0.getMethod();
        if (this.verbose && method.getName().startsWith("on")) {
            this.log(String.format("%s.%s called.", method.getDeclaringClass().getName(), method.getName()));
        }
        return this.action.call(arg0);
    }

    protected void log(String msg) {
        if (msg.equals(last)) {
            ++count;
        } else if (log.isInfoEnabled()) {
            String times = " ( " + count + " times )";
            log.info(msg + times);
            last = msg;
            count = 1;
        }
    }

    public static class DisableAction
    extends Action {
        @Override
        public Object call(MethodInvocation mi) {
            if (this.disabled(mi)) {
                throw this.createException(mi);
            }
            return super.call(mi);
        }

        protected boolean disabled(MethodInvocation mi) {
            return true;
        }

        protected InternalException createException(MethodInvocation mi) {
            return new InternalException(String.format("\nHibernate %s events have been disabled.", this.getType(mi)));
        }

        protected String getType(MethodInvocation mi) {
            Object event = mi.getArguments()[0];
            String type = "(unknown)";
            if (AbstractEvent.class.isAssignableFrom(event.getClass())) {
                type = event.getClass().getName();
            }
            return type;
        }
    }

    public static class Action {
        public Object call(MethodInvocation mi) {
            if (mi.getMethod().getReturnType().equals(Boolean.TYPE)) {
                return Boolean.FALSE;
            }
            return null;
        }
    }
}

