/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ImageUtils;
import java.awt.image.BufferedImage;

public class ThumbnailRescaleOp
extends AdvancedResizeOp {
    private Sampling sampling = Sampling.S_8ROCKS;

    public ThumbnailRescaleOp(int destWidth, int destHeight) {
        this(DimensionConstrain.createAbsolutionDimension(destWidth, destHeight));
    }

    public ThumbnailRescaleOp(DimensionConstrain dimensionConstrain) {
        super(dimensionConstrain);
    }

    protected BufferedImage doFilter(BufferedImage src, BufferedImage dest, int dstWidth, int dstHeight) {
        int numberOfChannels = ImageUtils.nrChannels(src);
        BufferedImage out = dest != null && dstWidth == dest.getWidth() && dstHeight == dest.getHeight() ? dest : new BufferedImage(dstWidth, dstHeight, numberOfChannels == 4 ? 2 : 1);
        float scaleX = (float)src.getWidth() / (float)dstWidth;
        float scaleY = (float)src.getHeight() / (float)dstHeight;
        float[][] scaledSampling = new float[this.sampling.points.length][2];
        for (int i = 0; i < this.sampling.points.length; ++i) {
            float[] point = this.sampling.points[i];
            float ROUNDING_ERROR_MARGIN = 1.0E-4f;
            scaledSampling[i][0] = point[0] * scaleX + 1.0E-4f;
            scaledSampling[i][1] = point[1] * scaleY + 1.0E-4f;
        }
        int maxSrcX = src.getWidth() - 1;
        int maxSrcY = src.getHeight() - 1;
        float srcY = 0.0f;
        int dstY = 0;
        while (dstY < dstHeight) {
            float srcX = 0.0f;
            int dstX = 0;
            while (dstX < dstWidth) {
                int r = 0;
                int g = 0;
                int b = 0;
                int a = 0;
                for (float[] point : scaledSampling) {
                    int x = (int)(srcX + point[0]);
                    int y = (int)(srcY + point[1]);
                    x = Math.max(0, Math.min(x, maxSrcX));
                    y = Math.max(0, Math.min(y, maxSrcY));
                    int rgb = src.getRGB(x, y);
                    b += rgb & 0xFF;
                    g += (rgb >>>= 8) & 0xFF;
                    r += (rgb >>>= 8) & 0xFF;
                    a += (rgb >>>= 8) & 0xFF;
                }
                int rgb = ((a >>= this.sampling.rightshift) << 24) + ((r >>= this.sampling.rightshift) << 16) + ((g >>= this.sampling.rightshift) << 8) + (b >>= this.sampling.rightshift);
                out.setRGB(dstX, dstY, rgb);
                ++dstX;
                srcX += scaleX;
            }
            ++dstY;
            srcY += scaleY;
        }
        return out;
    }

    public void setSampling(Sampling sampling) {
        this.sampling = sampling;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sampling {
        S_1SAMPLE(new float[][]{{0.5f, 0.5f}}),
        S_2X2_RGSS(new float[][]{{0.6f, 0.2f}, {0.2f, 0.4f}, {0.8f, 0.6f}, {0.4f, 0.8f}}),
        S_8ROCKS(new float[][]{{0.0f, 0.33333334f}, {0.33333334f, 0.16666667f}, {0.6666667f, 0.0f}, {0.8333333f, 0.33333334f}, {1.0f, 0.6666667f}, {0.6666667f, 0.8333333f}, {0.33333334f, 1.0f}, {0.16666667f, 0.6666667f}});

        final float[][] points;
        final int rightshift;

        private Sampling(float[][] points) {
            this.points = points;
            this.rightshift = Integer.numberOfTrailingZeros(points.length);
        }
    }
}

