/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;

public class KodakReader
extends FormatReader {
    private static final String MAGIC_STRING = "DTag";
    private static final String PIXELS_STRING = "BSfD";
    private static final String DIMENSIONS_STRING = "GBiH";
    private static final String FILEINFO_STRING = "DLFi";
    private static final String DATE_FORMAT = "HH:mm:ss 'on' MM/dd/yyyy";
    private long pixelOffset;

    public KodakReader() {
        super("Kodak Molecular Imaging", "bip");
        this.domains = new String[]{"Gel/Blot Imaging"};
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 16;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)16, (boolean)false)) {
            return false;
        }
        return stream.readString(16).indexOf(MAGIC_STRING) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(this.pixelOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = false;
        this.findString(DIMENSIONS_STRING);
        this.in.skipBytes(DIMENSIONS_STRING.length() + 20);
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        this.findString(PIXELS_STRING);
        this.pixelOffset = this.in.getFilePointer() + (long)PIXELS_STRING.length() + 20L;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.dimensionOrder = "XYCZT";
        m.pixelType = 6;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        this.readExtraMetadata(store);
        this.readFileInfoMetadata(store);
    }

    private void findString(String marker) throws IOException {
        byte[] buf = new byte[8192];
        int overlap = marker.length();
        this.in.read(buf, 0, overlap);
        while (this.in.getFilePointer() < this.in.length()) {
            int length = this.in.read(buf, overlap, buf.length - overlap);
            for (int i = 0; i < length; ++i) {
                if (!marker.equals(new String(buf, i, marker.length(), "UTF-8"))) continue;
                this.in.seek(this.in.getFilePointer() - (long)(length + overlap) + (long)i);
                return;
            }
            System.arraycopy(buf, length, buf, 0, overlap);
        }
    }

    private void readExtraMetadata(MetadataStore store) throws IOException {
        String[] lines;
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        this.in.seek(0L);
        this.findString("Image Capture Source");
        String metadata = this.in.readCString();
        if (metadata == null) {
            return;
        }
        for (String line : lines = metadata.split("\n")) {
            Double temp;
            Double size;
            int index = line.indexOf(58);
            if (index < 0 || line.startsWith("#") || line.startsWith("-")) continue;
            String key = line.substring(0, index).trim();
            String value = line.substring(index + 1).trim();
            this.addGlobalMeta(key, value);
            if (key.equals("Image Capture Source")) {
                String instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
                store.setInstrumentID(instrument, 0);
                store.setImageInstrumentRef(instrument, 0);
                store.setMicroscopeModel(value, 0);
                continue;
            }
            if (key.equals("Capture Time/Date")) {
                String date = DateTools.formatDate(value, DATE_FORMAT);
                if (date == null) continue;
                store.setImageAcquisitionDate(new Timestamp(date), 0);
                continue;
            }
            if (key.equals("Exposure Time")) {
                Double exposureTime = DataTools.parseDouble(value.substring(0, value.indexOf(32)));
                if (exposureTime == null) continue;
                store.setPlaneExposureTime(new Time((Number)exposureTime, UNITS.SECOND), 0, 0);
                continue;
            }
            if (key.equals("Vertical Resolution")) {
                if (value.indexOf(32) > 0) {
                    value = value.substring(0, value.indexOf(32));
                }
                size = DataTools.parseDouble(value);
                Length sizeY = FormatTools.getPhysicalSizeY((Double)(size = Double.valueOf(1.0 / (size * 3.937007874015748E-5))));
                if (sizeY == null) continue;
                store.setPixelsPhysicalSizeY(sizeY, 0);
                continue;
            }
            if (key.equals("Horizontal Resolution")) {
                if (value.indexOf(32) > 0) {
                    value = value.substring(0, value.indexOf(32));
                }
                size = DataTools.parseDouble(value);
                Length sizeX = FormatTools.getPhysicalSizeX((Double)(size = Double.valueOf(1.0 / (size * 3.937007874015748E-5))));
                if (sizeX == null) continue;
                store.setPixelsPhysicalSizeX(sizeX, 0);
                continue;
            }
            if (!key.equals("CCD Temperature")) continue;
            Matcher hexMatcher = Pattern.compile("0x([0-9A-F]+)").matcher(value);
            if (hexMatcher.matches()) {
                temp = Integer.parseInt(hexMatcher.group(1), 16);
                LOGGER.debug("CCD temperature detected as {}; assumed to be invalid", (Object)temp);
                continue;
            }
            temp = DataTools.parseDouble(value.substring(0, value.indexOf(32)));
            store.setImagingEnvironmentTemperature(new Temperature((Number)temp, UNITS.CELSIUS), 0);
        }
    }

    private void readFileInfoMetadata(MetadataStore store) throws IOException {
        this.in.seek(0L);
        this.findString(FILEINFO_STRING);
        int tagLength = FILEINFO_STRING.length();
        if (this.in.length() - this.in.getFilePointer() < (long)(tagLength + 20)) {
            return;
        }
        this.in.skipBytes(tagLength + 16);
        int dataLength = this.in.readInt() - tagLength - 20;
        if (this.in.length() - this.in.getFilePointer() < (long)dataLength) {
            return;
        }
        byte[] data = new byte[dataLength];
        if (this.in.read(data) != dataLength) {
            return;
        }
        String info = new String(data, "UTF-8");
        if ((info = info.trim().replaceAll("(\\r|\\n)+", " | ")).isEmpty()) {
            return;
        }
        this.addGlobalMeta("FileInfo", info);
    }
}

