/*
 * Decompiled with CFR 0.152.
 */
package ome.model.enums;

import java.util.HashMap;
import java.util.Map;
import ome.model.units.UnitEnum;

public enum UnitsTemperature implements UnitEnum
{
    KELVIN("K"),
    CELSIUS("\u00b0C"),
    FAHRENHEIT("\u00b0F"),
    RANKINE("\u00b0R");

    private static final Map<String, UnitsTemperature> bySymbol;
    protected String symbol;

    private UnitsTemperature(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public static UnitsTemperature bySymbol(String symbol) {
        return bySymbol.get(symbol);
    }

    static {
        bySymbol = new HashMap<String, UnitsTemperature>();
        for (UnitsTemperature t : UnitsTemperature.values()) {
            bySymbol.put(t.symbol, t);
        }
    }
}

