/*
 * Decompiled with CFR 0.152.
 */
package ome.model.units;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import ome.model.enums.UnitsElectricPotential;
import ome.model.units.Unit;
import ome.util.Filter;
import ome.util.Filterable;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsElectricPotentialEnumHandler;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class ElectricPotential
implements Serializable,
Filterable,
Unit {
    private static final long serialVersionUID = 1L;
    public static final String VALUE = "ome.model.units.ElectricPotential_value";
    public static final String UNIT = "ome.model.units.ElectricPotential_unit";
    private double value;
    private UnitsElectricPotential unit = null;

    public static ome.xml.model.enums.UnitsElectricPotential makeElectricPotentialUnitXML(String unit) {
        try {
            return ome.xml.model.enums.UnitsElectricPotential.fromString((String)unit);
        }
        catch (EnumerationException e) {
            throw new RuntimeException("Bad ElectricPotential unit: " + unit, e);
        }
    }

    public static ome.units.quantity.ElectricPotential makeElectricPotentialXML(double d, String unit) {
        ome.units.unit.Unit units = UnitsElectricPotentialEnumHandler.getBaseUnit((ome.xml.model.enums.UnitsElectricPotential)ElectricPotential.makeElectricPotentialUnitXML(unit));
        return new ome.units.quantity.ElectricPotential((Number)d, units);
    }

    public static ome.units.quantity.ElectricPotential convertElectricPotential(ElectricPotential t) {
        if (t == null) {
            return null;
        }
        Double v = t.getValue();
        String u = t.getUnit().getSymbol();
        ome.xml.model.enums.UnitsElectricPotential units = ElectricPotential.makeElectricPotentialUnitXML(u);
        ome.units.unit.Unit units2 = UnitsElectricPotentialEnumHandler.getBaseUnit((ome.xml.model.enums.UnitsElectricPotential)units);
        return new ome.units.quantity.ElectricPotential((Number)v, units2);
    }

    public static ElectricPotential convertElectricPotential(ElectricPotential value, ome.units.unit.Unit<ome.units.quantity.ElectricPotential> ul) {
        return ElectricPotential.convertElectricPotential(value, ul.getSymbol());
    }

    public static ElectricPotential convertElectricPotential(ElectricPotential value, String target) {
        String source = value.getUnit().getSymbol();
        if (target.equals(source)) {
            return value;
        }
        throw new RuntimeException(String.format("%f %s cannot be converted to %s", value.getValue(), value.getUnit().getSymbol(), source));
    }

    @Deprecated
    public ElectricPotential() {
    }

    public ElectricPotential(double d, String u) {
        this.value = d;
        this.unit = UnitsElectricPotential.valueOf(u);
    }

    public ElectricPotential(double d, UnitsElectricPotential u) {
        this.value = d;
        this.unit = u;
    }

    public ElectricPotential(double d, ome.units.unit.Unit<ome.units.quantity.ElectricPotential> unit) {
        this(d, UnitsElectricPotential.bySymbol(unit.getSymbol()));
    }

    public ElectricPotential(ome.units.quantity.ElectricPotential value) {
        this(value.value().doubleValue(), UnitsElectricPotential.bySymbol(value.unit().getSymbol()));
    }

    @Override
    @Column(name="value", nullable=false)
    public double getValue() {
        return this.value;
    }

    @Override
    @Column(name="unit", nullable=false, unique=false, insertable=true, updatable=true)
    @Type(type="ome.model.units.GenericEnumType", parameters={@Parameter(name="unit", value="ELECTRICPOTENTIAL")})
    public UnitsElectricPotential getUnit() {
        return this.unit;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public void setUnit(UnitsElectricPotential unit) {
        this.unit = unit;
    }

    @Override
    public boolean acceptFilter(Filter filter) {
        this.unit = (UnitsElectricPotential)filter.filter(UNIT, this.unit);
        this.value = (Double)filter.filter(VALUE, this.value);
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "ElectricPotential(" + this.value + " " + this.unit + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElectricPotential other = (ElectricPotential)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

