/*
 * Decompiled with CFR 0.152.
 */
package com.glencoesoftware.omero.zarr.compat;

import com.bc.zarr.ZarrGroup;
import com.glencoesoftware.omero.zarr.compat.ZarrPath;
import com.glencoesoftware.omero.zarr.compat.ZarrPathv2;
import com.glencoesoftware.omero.zarr.compat.ZarrPathv3;
import com.google.common.base.Splitter;
import dev.zarr.zarrjava.store.FilesystemStore;
import dev.zarr.zarrjava.store.HttpStore;
import dev.zarr.zarrjava.store.S3Store;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.v3.Group;
import dev.zarr.zarrjava.v3.GroupMetadata;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.carlspring.cloud.storage.s3fs.OmeroS3FilesystemProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;

public class ZarrInfo {
    private static final Logger log = LoggerFactory.getLogger(ZarrInfo.class);
    public static final ComparableVersion ZARR_V2 = new ComparableVersion("2");
    public static final ComparableVersion ZARR_V3 = new ComparableVersion("3");
    public static final ComparableVersion NGFF_V0_4 = new ComparableVersion("0.4");
    public static final ComparableVersion NGFF_V0_5 = new ComparableVersion("0.5");
    private ComparableVersion zarrVersion;
    private ComparableVersion ngffVersion;
    private String location;
    private StorageType storageType;

    public ZarrInfo(String location) throws IOException {
        this.location = location.endsWith("/") ? location.substring(0, location.length() - 1) : location;
        this.checkProperties();
    }

    private void checkProperties() throws IOException {
        URI uri;
        try {
            uri = new URI(this.location);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI: " + this.location, e);
        }
        if (uri.getScheme() == null || "file".equals(uri.getScheme().toLowerCase())) {
            File test = new File(this.location);
            if (!test.isDirectory()) {
                throw new IOException("Not a directory: " + this.location);
            }
            if (!test.canRead()) {
                throw new IOException("Cannot read directory: " + this.location);
            }
            this.storageType = StorageType.FILE;
        } else {
            String scheme = uri.getScheme().toLowerCase();
            if (scheme.startsWith("http")) {
                this.storageType = StorageType.HTTP;
            } else if (scheme.equals("s3")) {
                this.storageType = StorageType.S3;
            } else {
                throw new IOException("Unsupported scheme: " + scheme);
            }
        }
        try {
            StoreHandle sh = this.asStoreHandle();
            GroupMetadata md = Group.open((StoreHandle)sh).metadata;
            this.zarrVersion = new ComparableVersion("3");
            try {
                this.ngffVersion = new ComparableVersion(((Map)md.attributes.get("ome")).get("version").toString());
            }
            catch (Exception e) {
                log.debug("Failed to get ngff version from zarr, set to 0.5");
                this.ngffVersion = new ComparableVersion("0.5");
            }
            return;
        }
        catch (Exception e) {
            log.debug("Not zarr v3:", (Throwable)e);
            try {
                Map attr = ZarrGroup.open((Path)this.asPath(this.location)).getAttributes();
                this.zarrVersion = new ComparableVersion("2");
                try {
                    List tmp = (List)attr.get("multiscales");
                    this.ngffVersion = new ComparableVersion(((Map)tmp.get(0)).get("version").toString());
                }
                catch (Exception e2) {
                    log.debug("Failed to get ngff version from zarr, set to 0.4");
                    this.ngffVersion = new ComparableVersion("0.4");
                }
                return;
            }
            catch (Exception e3) {
                log.debug("Not zarr v2:", (Throwable)e3);
                throw new IOException("Failed to determine zarr version");
            }
        }
    }

    public ComparableVersion getZarrVersion() {
        return this.zarrVersion;
    }

    public ComparableVersion getNgffVersion() {
        return this.ngffVersion;
    }

    public String getLocation() {
        return this.location;
    }

    public ZarrPath getZarrPath() throws IOException {
        if (this.zarrVersion.equals((Object)ZARR_V2)) {
            return new ZarrPathv2(this.asPath(this.location));
        }
        return new ZarrPathv3(this.asStoreHandle());
    }

    private Path asPath(String location) throws IOException {
        try {
            String scheme;
            URI uri = new URI(location);
            String string = scheme = uri.getScheme() != null ? uri.getScheme().toLowerCase() : "file";
            if (scheme.startsWith("http")) {
                String s3loc = location.replaceFirst("https?", "s3");
                return this.asPath(s3loc + "?anonymous=true");
            }
            if (scheme.equals("s3")) {
                if (uri.getUserInfo() != null && !uri.getUserInfo().isEmpty()) {
                    throw new RuntimeException("Found unsupported user information in S3 URI. If you are trying to pass S3 credentials, use either named profiles or instance credentials.");
                }
                String query = Optional.ofNullable(uri.getQuery()).orElse("");
                Map params = Splitter.on((char)'&').trimResults().omitEmptyStrings().withKeyValueSeparator('=').split((CharSequence)query);
                String uriPath = uri.getPath().substring(1);
                int first = uriPath.indexOf("/");
                String bucket = "/" + uriPath.substring(0, first);
                String rest = uriPath.substring(first + 1);
                HashMap<String, String> env = new HashMap<String, String>();
                String profile = (String)params.get("profile");
                if (profile != null) {
                    env.put("s3fs_credential_profile_name", profile);
                }
                String anonymous = Optional.ofNullable((String)params.get("anonymous")).orElse("false");
                env.put("s3fs_anonymous", anonymous);
                OmeroS3FilesystemProvider fsp = new OmeroS3FilesystemProvider();
                FileSystem fs = fsp.newFileSystem(uri, env);
                return fs.getPath(bucket, rest);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return Path.of(location, new String[0]);
    }

    private StoreHandle asStoreHandle() {
        try {
            URI uri = new URI(this.location);
            String scheme = uri.getScheme() != null ? uri.getScheme().toLowerCase() : "file";
            String locationNoParams = this.location.replaceAll("/?\\?.+", "");
            String store = locationNoParams.substring(0, this.location.lastIndexOf("/"));
            String zarr = locationNoParams.substring(this.location.lastIndexOf("/") + 1);
            if (scheme.startsWith("http")) {
                return new HttpStore(store).resolve(new String[]{zarr});
            }
            if (scheme.startsWith("s3")) {
                String[] tmp = store.replaceFirst("s3://", "").split("/");
                String bucket = tmp[1];
                String rest = String.join((CharSequence)"/", Arrays.copyOfRange(tmp, 2, tmp.length));
                String query = Optional.ofNullable(uri.getQuery()).orElse("");
                Map params = Splitter.on((char)'&').trimResults().omitEmptyStrings().withKeyValueSeparator('=').split((CharSequence)query);
                HashMap<String, String> env = new HashMap<String, String>();
                String profile = (String)params.get("profile");
                if (profile != null) {
                    env.put("s3fs_credential_profile_name", profile);
                }
                String anonymous = Optional.ofNullable((String)params.get("anonymous")).orElse("false");
                env.put("s3fs_anonymous", anonymous);
                OmeroS3FilesystemProvider fsp = new OmeroS3FilesystemProvider();
                S3Client client = fsp.createAmazonS3(uri, env);
                return new S3Store(client, bucket, rest).resolve(new String[]{zarr});
            }
            return new FilesystemStore(store).resolve(new String[]{zarr});
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String toString() {
        return "ZarrInfo{location='" + this.location + "', storageType=" + this.storageType + ", zarrVersion=" + this.zarrVersion + ", ngffVersion=" + this.ngffVersion + "}";
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public static enum StorageType {
        FILE,
        S3,
        HTTP;

    }
}

