/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ReaderWrapper;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMerger
extends ReaderWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelMerger.class);

    public static ChannelMerger makeChannelMerger(IFormatReader r) {
        if (r instanceof ChannelMerger) {
            return (ChannelMerger)r;
        }
        return new ChannelMerger(r);
    }

    public ChannelMerger() {
    }

    public ChannelMerger(IFormatReader r) {
        super(r);
    }

    public boolean canMerge() {
        int c = this.getSizeC();
        return c > 1 && c <= 4 && !this.reader.isRGB();
    }

    public int getOriginalIndex(int no) throws FormatException, IOException {
        int originalCount;
        int imageCount = this.getImageCount();
        if (imageCount == (originalCount = this.reader.getImageCount())) {
            return no;
        }
        int[] coords = this.getZCTCoords(no);
        return this.reader.getIndex(coords[0], coords[1], coords[2]);
    }

    @Override
    public int getImageCount() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        int no = this.reader.getImageCount();
        if (this.canMerge()) {
            no /= this.getSizeC();
        }
        return no;
    }

    @Override
    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        String order = this.reader.getDimensionOrder();
        if (this.canMerge()) {
            StringBuilder sb = new StringBuilder(order);
            while (order.indexOf(67) != 2) {
                char pre = order.charAt(order.indexOf(67) - 1);
                sb.setCharAt(order.indexOf(67), pre);
                sb.setCharAt(order.indexOf(pre), 'C');
                order = sb.toString();
            }
        }
        return order;
    }

    @Override
    public boolean isInterleaved() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.canMerge() ? false : this.reader.isInterleaved();
    }

    @Override
    public boolean isRGB() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.canMerge() || this.reader.isRGB();
    }

    @Override
    public boolean isIndexed() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return !this.canMerge() && this.reader.isIndexed();
    }

    @Override
    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    @Override
    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    @Override
    public byte[] openBytes(int no, int x, int y, int w, int h2) throws FormatException, IOException {
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int ch = this.getRGBChannelCount();
        byte[] newBuffer = DataTools.allocate(w, h2, ch, bpp);
        return this.openBytes(no, newBuffer, x, y, w, h2);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (!this.canMerge()) {
            return super.openBytes(no, buf, x, y, w, h2);
        }
        int sizeC = this.getSizeC();
        int[] nos = this.getZCTCoords(no);
        int z = nos[0];
        int t2 = nos[2];
        for (int c = 0; c < sizeC; ++c) {
            byte[] b = this.reader.openBytes(this.reader.getIndex(z, c, t2), x, y, w, h2);
            System.arraycopy(b, 0, buf, c * b.length, b.length);
        }
        return buf;
    }

    @Override
    public int getIndex(int z, int c, int t2, int moduloZ, int moduloC, int moduloT) {
        return FormatTools.getIndex(this, z, c, t2, moduloZ, moduloC, moduloT);
    }

    @Override
    public int getIndex(int z, int c, int t2) {
        return FormatTools.getIndex(this, z, c, t2);
    }

    @Override
    public int[] getZCTCoords(int index) {
        return FormatTools.getZCTCoords(this, index);
    }

    @Override
    public int[] getZCTModuloCoords(int index) {
        return FormatTools.getZCTModuloCoords(this, index);
    }

    @Override
    public byte[] openCompressedBytes(int no, int x, int y) throws FormatException, IOException {
        throw new UnsupportedOperationException("ChannelMerger does not support pre-compressed tile access");
    }

    @Override
    public byte[] openCompressedBytes(int no, byte[] buf, int x, int y) throws FormatException, IOException {
        throw new UnsupportedOperationException("ChannelMerger does not support pre-compressed tile access");
    }

    @Override
    public Codec getTileCodec(int no) throws FormatException, IOException {
        throw new UnsupportedOperationException("ChannelMerger does not support pre-compressed tile access");
    }

    @Override
    public CodecOptions getTileCodecOptions(int no, int x, int y) throws FormatException, IOException {
        throw new UnsupportedOperationException("ChannelMerger does not support pre-compressed tile access");
    }

    @Override
    public Class<?> getNativeDataType() {
        return byte[].class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        MetadataStore store = this.getMetadataStore();
        try {
            OMEXMLService service = new ServiceFactory().getInstance(OMEXMLService.class);
            if (service.isOMEXMLMetadata(store)) {
                OMEXMLMetadata omexml = service.getOMEMetadata((MetadataRetrieve)((Object)store));
                for (int s2 = 0; s2 < this.getSeriesCount(); ++s2) {
                    this.setSeries(s2);
                    if (!this.canMerge()) continue;
                    service.removeChannels(omexml, s2, this.getEffectiveSizeC());
                    omexml.setChannelSamplesPerPixel(new PositiveInteger(this.getRGBChannelCount()), s2, 0);
                }
            }
        }
        catch (DependencyException | ServiceException e) {
            LOGGER.debug("Could not check for OMEXMLMetadata", e);
        }
        finally {
            this.setSeries(0);
        }
    }
}

