/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import loci.common.DataTools;
import loci.formats.in.BaseZeissReader;
import loci.formats.in.ZeissTIFFReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ZeissTIFFHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeissTIFFHandler.class);
    BaseZeissReader reader;
    private Stack<String> nameStack = new Stack();
    private String cdata = new String();
    public TagSet main_tagset = new TagSet();
    public ArrayList<Plane> planes = new ArrayList();
    public ArrayList<Scaling> scalings = new ArrayList();
    public ArrayList<BaseZeissReader.Layer> layers = new ArrayList();
    private TagSet current_tagset;
    private BaseZeissReader.Tag current_tag;
    private Scaling current_scaling;
    private BaseZeissReader.Layer current_layer;
    private BaseZeissReader.Shape current_shape;
    private Set<String> planeNames = new HashSet<String>();
    int tag_count;
    int layer_count;
    int shape_count;

    ZeissTIFFHandler(ZeissTIFFReader reader) {
        this.reader = reader;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("TIFF-XML parsing\n");
        s2.append(this.main_tagset);
        s2.append('\n');
        for (Scaling sc : this.scalings) {
            s2.append(sc);
            s2.append('\n');
        }
        for (Plane p : this.planes) {
            s2.append(p);
            s2.append('\n');
        }
        return s2.toString();
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (!this.nameStack.empty() && this.nameStack.peek().equals(qName)) {
            this.nameStack.pop();
        }
        if (!(qName.equals("ROOT") || qName.equals("Layers") || qName.equals("Shapes"))) {
            if (qName.startsWith("Item")) {
                if (this.nameStack.peek().equals("Layers")) {
                    if (this.current_layer != null) {
                        this.layers.add(this.current_layer);
                    }
                    this.current_layer = null;
                } else if (this.nameStack.peek().equals("Shapes")) {
                    if (this.current_shape != null) {
                        this.current_layer.shapes.add(this.current_shape);
                    }
                    this.current_shape = null;
                } else {
                    LOGGER.info("Parse error: tag found out of place: {}", (Object)qName);
                }
            } else if (qName.equals("Scaling")) {
                if (this.current_scaling != null) {
                    this.scalings.add(this.current_scaling);
                }
                this.current_scaling = null;
            } else if (qName.equals("Key")) {
                if (this.current_scaling != null) {
                    if (this.current_scaling.key == null) {
                        this.current_scaling.key = this.cdata;
                    } else {
                        LOGGER.debug("Key already set");
                    }
                }
            } else if (qName.equals("Category")) {
                if (this.current_scaling != null) {
                    if (this.current_scaling.category == null) {
                        this.current_scaling.category = Integer.parseInt(this.cdata);
                    } else {
                        LOGGER.debug("Category already set");
                    }
                }
            } else if (qName.startsWith("Factor_")) {
                Scaling.Dimension d = this.current_scaling.getDimension(qName);
                d.factor = ZeissTIFFHandler.parseDouble(this.cdata);
            } else if (qName.startsWith("Type_")) {
                Scaling.Dimension d = this.current_scaling.getDimension(qName);
                d.type = Integer.parseInt(this.cdata);
            } else if (qName.startsWith("Unit_")) {
                Scaling.Dimension d = this.current_scaling.getDimension(qName);
                try {
                    d.unit = Integer.parseInt(this.cdata);
                }
                catch (Exception exception) {}
            } else if (qName.startsWith("Origin_")) {
                Scaling.Dimension d = this.current_scaling.getDimension(qName);
                d.origin = ZeissTIFFHandler.parseDouble(this.cdata);
            } else if (qName.startsWith("Angle_")) {
                Scaling.Dimension d = this.current_scaling.getDimension(qName);
                d.angle = ZeissTIFFHandler.parseDouble(this.cdata);
            } else if (qName.startsWith("Matrix_")) {
                String value = qName.substring(qName.indexOf(95) + 1);
                Integer index = Integer.parseInt(value);
                Double mval = ZeissTIFFHandler.parseDouble(this.cdata);
                this.current_scaling.matrix.put(index, mval);
            } else if (qName.equals("Tags")) {
                if (!this.nameStack.empty()) {
                    String parent = this.nameStack.peek();
                    if (parent.equals("ROOT")) {
                        this.main_tagset = this.current_tagset;
                        this.current_tagset = null;
                    } else if (parent.equals("Scaling")) {
                        this.current_scaling.tagset = this.current_tagset;
                        this.current_tagset = null;
                    } else if (this.nameStack.size() == 2) {
                        Plane plane = new Plane(parent, this.current_tagset);
                        this.current_tagset = null;
                        this.planes.add(plane);
                        this.planeNames.add(plane.basename);
                    }
                }
            } else if (!(qName.equals("__Version") || qName.equals("AttributeShape") || qName.equals("SourceName") || qName.equals("PredefinedStrings") || qName.equals("Dummy") || qName.equals("Features") || qName.equals("DrawFeatures") || qName.equals("InputMethod"))) {
                if (qName.equals("HandleSize2")) {
                    this.current_shape.handleSize = Integer.parseInt(this.cdata);
                } else if (qName.equals("Text")) {
                    this.current_shape.text = this.cdata;
                } else if (qName.equals("PointCount")) {
                    this.current_shape.pointCount = Integer.parseInt(this.cdata);
                } else if (qName.equals("Points")) {
                    int i;
                    this.cdata = this.cdata.replaceAll("\\p{Cntrl}|\\p{Space}", "");
                    String[] numbers = this.cdata.split(",");
                    byte[] raw = new byte[numbers.length];
                    for (i = 0; i < raw.length; ++i) {
                        raw[i] = (byte)Integer.parseInt(numbers[i]);
                    }
                    this.current_shape.points = new double[this.current_shape.pointCount * 2];
                    for (i = 0; i < this.current_shape.pointCount; ++i) {
                        this.current_shape.points[i * 2] = DataTools.bytesToDouble(raw, i * 2 * 8, true);
                        this.current_shape.points[i * 2 + 1] = DataTools.bytesToDouble(raw, (i * 2 + 1) * 8, true);
                    }
                } else if (qName.equals("FontName")) {
                    this.current_shape.fontName = this.cdata;
                } else if (qName.equals("Name")) {
                    this.current_shape.name = this.cdata;
                } else if (qName.equals("SourceTagId")) {
                    int value = Integer.parseInt(this.cdata);
                    BaseZeissReader baseZeissReader = this.reader;
                    Objects.requireNonNull(baseZeissReader);
                    this.current_shape.tagID = baseZeissReader.new BaseZeissReader.Tag(value, BaseZeissReader.Context.MAIN);
                } else if (qName.equals("ShapeAttributes")) {
                    this.cdata = this.cdata.replaceAll("\\p{Cntrl}|\\p{Space}", "");
                    String[] numbers = this.cdata.split(",");
                    byte[] raw = new byte[numbers.length];
                    for (int i = 0; i < raw.length; ++i) {
                        raw[i] = (byte)Integer.parseInt(numbers[i]);
                    }
                    if (raw.length >= 152) {
                        int isize = DataTools.bytesToInt(raw, 0, true);
                        if (raw.length < isize) {
                            LOGGER.info("ShapeAttributes length ({}) is less than internal size ({})!  Trying to continue...", (Object)raw.length, (Object)isize);
                        }
                        int type = DataTools.bytesToInt(raw, 4, true);
                        this.current_shape.type = BaseZeissReader.FeatureType.get(type);
                        this.current_shape.unknown2 = DataTools.bytesToInt(raw, 8, true);
                        this.current_shape.unknown3 = DataTools.bytesToInt(raw, 12, true);
                        this.current_shape.x1 = DataTools.bytesToInt(raw, 16, true);
                        this.current_shape.y1 = DataTools.bytesToInt(raw, 20, true);
                        this.current_shape.x2 = DataTools.bytesToInt(raw, 24, true);
                        this.current_shape.y2 = DataTools.bytesToInt(raw, 28, true);
                        this.current_shape.width = this.current_shape.x2 - this.current_shape.x1;
                        this.current_shape.height = this.current_shape.y2 - this.current_shape.y1;
                        this.current_shape.unknown4 = DataTools.bytesToInt(raw, 32, true);
                        this.current_shape.unknown5 = DataTools.bytesToInt(raw, 36, true);
                        this.current_shape.unknown6 = ZeissTIFFHandler.parseColor(raw[40], raw[41], raw[42]);
                        this.current_shape.unknown7 = DataTools.bytesToInt(raw, 44, true);
                        this.current_shape.fillColour = ZeissTIFFHandler.parseColor(raw[48], raw[49], raw[50]);
                        this.current_shape.textColour = ZeissTIFFHandler.parseColor(raw[52], raw[53], raw[54]);
                        this.current_shape.drawColour = ZeissTIFFHandler.parseColor(raw[56], raw[57], raw[58]);
                        this.current_shape.lineWidth = DataTools.bytesToInt(raw, 60, true);
                        this.current_shape.drawStyle = BaseZeissReader.DrawStyle.get(DataTools.bytesToInt(raw, 64, true));
                        this.current_shape.fillStyle = BaseZeissReader.FillStyle.get(DataTools.bytesToInt(raw, 68, true));
                        this.current_shape.unknown8 = DataTools.bytesToInt(raw, 72, true);
                        this.current_shape.strikeout = DataTools.bytesToInt(raw, 76, true) != 0;
                        this.current_shape.fontWeight = DataTools.bytesToInt(raw, 80, true);
                        this.current_shape.bold = this.current_shape.fontWeight >= 600;
                        this.current_shape.fontSize = DataTools.bytesToInt(raw, 84, true);
                        this.current_shape.italic = DataTools.bytesToInt(raw, 88, true) != 0;
                        this.current_shape.underline = DataTools.bytesToInt(raw, 92, true) != 0;
                        this.current_shape.textAlignment = BaseZeissReader.TextAlignment.get(DataTools.bytesToInt(raw, 96, true));
                        this.current_shape.unknown10 = DataTools.bytesToInt(raw, 100, true);
                        this.current_shape.unknown11 = DataTools.bytesToInt(raw, 104, true);
                        this.current_shape.unknown12 = DataTools.bytesToInt(raw, 108, true);
                        this.current_shape.unknown13 = DataTools.bytesToInt(raw, 112, true);
                        this.current_shape.unknown14 = DataTools.bytesToInt(raw, 116, true);
                        this.current_shape.unknown15 = DataTools.bytesToInt(raw, 120, true);
                        this.current_shape.unknown16 = DataTools.bytesToInt(raw, 124, true);
                        this.current_shape.unknown17 = DataTools.bytesToInt(raw, 128, true);
                        this.current_shape.unknown18 = DataTools.bytesToInt(raw, 132, true);
                        this.current_shape.displayTag = DataTools.bytesToInt(raw, 148, true) != 0;
                        this.current_shape.lineEndStyle = BaseZeissReader.LineEndStyle.get(DataTools.bytesToInt(raw, 136, true));
                        this.current_shape.pointStyle = BaseZeissReader.PointStyle.get(DataTools.bytesToInt(raw, 136, true));
                        this.current_shape.lineEndSize = DataTools.bytesToInt(raw, 140, true);
                        this.current_shape.lineEndPositions = BaseZeissReader.LineEndPositions.get(DataTools.bytesToInt(raw, 144, true));
                        if (isize >= 156) {
                            this.current_shape.charset = BaseZeissReader.Charset.get(DataTools.bytesToInt(raw, 152, true));
                        }
                    }
                } else if (qName.equals("Flags")) {
                    if (qName.startsWith("Item")) {
                        // empty if block
                    }
                } else if (qName.equals("Count")) {
                    if (this.nameStack.peek().equals("Tags")) {
                        this.tag_count = Integer.parseInt(this.cdata);
                        this.current_tagset.count = Integer.parseInt(this.cdata);
                    } else if (this.nameStack.peek().equals("Layers")) {
                        this.layer_count = Integer.parseInt(this.cdata);
                    } else if (this.nameStack.peek().equals("Shapes")) {
                        this.shape_count = Integer.parseInt(this.cdata);
                    } else {
                        LOGGER.info("Parse error: tag found out of place: {}", (Object)qName);
                    }
                } else if (qName.equals("Key")) {
                    if (this.nameStack.peek().equals("Layers")) {
                        // empty if block
                    }
                    if (!this.nameStack.peek().equals("Shapes")) {
                        if (this.nameStack.peek().startsWith("Item")) {
                            int stackSize = this.nameStack.size();
                            if (stackSize >= 2) {
                                if (((String)this.nameStack.get(stackSize - 2)).equals("Layers")) {
                                    this.current_layer.key = Integer.parseInt(this.cdata);
                                } else if (((String)this.nameStack.get(stackSize - 2)).equals("Shapes")) {
                                    this.current_layer.key = Integer.parseInt(this.cdata);
                                }
                            }
                        } else {
                            LOGGER.info("Parse error: tag found out of place: {}", (Object)qName);
                        }
                    }
                } else if (!qName.equals("Class")) {
                    if (!this.nameStack.empty() && this.nameStack.peek().equals("Tags")) {
                        String type = qName.substring(0, 1);
                        if (type.equals("A") || type.equals("I") || type.equals("V")) {
                            String value = qName.substring(1);
                            int index = Integer.parseInt(value);
                            int stackSize = this.nameStack.size();
                            BaseZeissReader.Context context = BaseZeissReader.Context.PLANE;
                            if (stackSize >= 2) {
                                if (((String)this.nameStack.get(stackSize - 2)).equals("ROOT")) {
                                    context = BaseZeissReader.Context.MAIN;
                                } else if (((String)this.nameStack.get(stackSize - 2)).equals("Scaling")) {
                                    context = BaseZeissReader.Context.SCALING;
                                }
                            }
                            if (this.current_tag == null || this.current_tag.getIndex() != index) {
                                BaseZeissReader baseZeissReader = this.reader;
                                Objects.requireNonNull(baseZeissReader);
                                this.current_tag = baseZeissReader.new BaseZeissReader.Tag(index, context);
                            }
                            if (this.current_tagset.found >= this.current_tagset.count) {
                                LOGGER.info("Found more tags then declared");
                            }
                            if (type.equals("V")) {
                                this.current_tag.setValue(this.cdata);
                            } else if (type.equals("I")) {
                                this.current_tag.setKey(Integer.parseInt(this.cdata));
                            } else if (type.equals("A")) {
                                this.current_tag.setCategory(Integer.parseInt(this.cdata));
                            } else {
                                LOGGER.info("Unknown tag: {}", (Object)qName);
                            }
                            if (this.current_tag.valid()) {
                                this.current_tagset.tags.add(this.current_tag);
                                ++this.current_tagset.found;
                            }
                        } else {
                            LOGGER.info("Unknown tag: {}", (Object)qName);
                        }
                    } else if (!this.planeNames.contains(qName)) {
                        LOGGER.info("Unknown tag: {}", (Object)qName);
                    }
                }
            }
        }
        this.cdata = "";
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String s2 = new String(ch, start, length);
        this.cdata = this.cdata + s2;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.cdata = "";
        if (qName.equals("Scaling")) {
            this.current_scaling = new Scaling();
        } else if (qName.equals("Tags")) {
            this.current_tagset = new TagSet();
        } else if (qName.startsWith("Item")) {
            if (this.nameStack.peek().equals("Layers")) {
                this.current_layer = this.reader.new BaseZeissReader.Layer();
            } else if (this.nameStack.peek().equals("Shapes")) {
                this.current_shape = this.reader.new BaseZeissReader.Shape();
            } else {
                LOGGER.info("Parse error: tag found out of place: {}", (Object)qName);
            }
        } else if (qName.equals("Class")) {
            // empty if block
        }
        this.nameStack.push(qName);
    }

    private static double parseDouble(String number) {
        if (number != null) {
            number = number.replaceAll(",", ".");
            return Double.parseDouble(number);
        }
        return 0.0;
    }

    protected static int parseColor(byte r, byte g2, byte b) {
        return (r & 0xFF) << 24 | (g2 & 0xFF) << 16 | (b & 0xFF) << 8;
    }

    class TagSet {
        int count = 0;
        int found = 0;
        public ArrayList<BaseZeissReader.Tag> tags = new ArrayList();

        TagSet() {
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder("  Tags(" + this.count + "):\n");
            for (BaseZeissReader.Tag t2 : this.tags) {
                s2.append(t2);
                s2.append('\n');
            }
            return s2.toString();
        }
    }

    class Scaling {
        String key;
        Integer category;
        Map<Integer, Dimension> dims = new HashMap<Integer, Dimension>();
        Map<Integer, Double> matrix = new HashMap<Integer, Double>();
        TagSet tagset;

        Scaling() {
        }

        Dimension getDimension(String key) {
            String value = key.substring(key.indexOf(95) + 1);
            Integer index = Integer.parseInt(value);
            Dimension d = this.dims.get(index);
            if (d == null) {
                d = new Dimension(index);
                this.dims.put(index, d);
            }
            return d;
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder("Scaling\n");
            s2.append("  Key=");
            s2.append(this.key);
            s2.append("\n  Cat=");
            s2.append(this.category);
            s2.append("\n");
            LinkedList<Integer> dimarray = new LinkedList<Integer>(this.dims.keySet());
            Collections.sort(dimarray);
            for (Integer dim : dimarray) {
                Dimension d = this.dims.get(dim);
                s2.append("  Dim");
                s2.append(dim);
                s2.append("=\n    Ftr=");
                s2.append(d.factor);
                s2.append("\n    Typ=");
                s2.append(d.type);
                s2.append("\n    Unt=");
                s2.append(d.unit);
                s2.append("\n    Org=");
                s2.append(d.origin);
                s2.append("\n    Ang=");
                s2.append(d.angle);
                s2.append("\n");
            }
            s2.append(this.tagset);
            s2.append('\n');
            return s2.toString();
        }

        class Dimension {
            Integer dimension;
            Double factor;
            Integer type;
            Integer unit;
            Double origin;
            Double angle;

            Dimension(Integer dimension) {
                this.dimension = dimension;
            }
        }
    }

    public class Plane {
        public String basename;
        public TagSet tagset;

        Plane(String basename, TagSet tagset) {
            this.basename = basename;
            this.tagset = tagset;
        }

        public String toString() {
            String s2 = new String("  Plane: " + this.basename + '\n');
            s2 = s2 + this.tagset;
            s2 = s2 + '\n';
            return s2;
        }
    }

    class Tag {
        public int index;
        public int key;
        public String value;
        public int category;

        Tag(int index) {
            this.index = index;
            this.key = -1;
            this.value = null;
            this.category = -1;
        }

        public boolean valid() {
            return this.key != -1 && this.value != null && this.category != -1;
        }

        public String toString() {
            return new String("      T: K=" + this.key + " V=" + this.value + " C=" + this.category + " I=" + this.index);
        }
    }
}

