/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.writer;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.HorizCoordSys;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.writer.CoverageSubsetter2;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.write.NetcdfFormatWriter;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.LatLonProjection;

public class CFGridCoverageWriter {
    private static final Logger logger = LoggerFactory.getLogger(CFGridCoverageWriter.class);
    private static final boolean show = false;
    private static final String BOUNDS = "_bounds";
    private static final String BOUNDS_DIM = "bounds_dim";
    public static final String TOO_LARGE_MESSAGE = "Request too large";

    public static Result write(CoverageCollection gdsOrg, List<String> gridNames, SubsetParams subset, boolean tryToAddLatLon2D, NetcdfFormatWriter.Builder writer, long maxBytes) throws IOException, InvalidRangeException {
        Preconditions.checkNotNull(writer);
        CFGridCoverageWriter writer2 = new CFGridCoverageWriter();
        return writer2.writeFile(gdsOrg, gridNames, subset, tryToAddLatLon2D, writer, maxBytes);
    }

    private Result writeFile(CoverageCollection gdsOrg, List<String> gridNames, SubsetParams subsetParams, boolean tryToAddLatLon2D, NetcdfFormatWriter.Builder writer, long maxBytes) throws IOException, InvalidRangeException {
        ucar.nc2.util.Optional<CoverageCollection> opt;
        if (gridNames == null) {
            gridNames = new LinkedList<String>();
            for (Coverage coverage : gdsOrg.getCoverages()) {
                gridNames.add(coverage.getName());
            }
        }
        if (subsetParams == null) {
            subsetParams = new SubsetParams();
        }
        if (!(opt = CoverageSubsetter2.makeCoverageDatasetSubset(gdsOrg, gridNames, subsetParams)).isPresent()) {
            return Result.create(0L, false, opt.getErrorMessage());
        }
        CoverageCollection subsetDataset = opt.get();
        Group.Builder rootGroup = writer.getRootGroup();
        this.addGlobalAttributes(subsetDataset, rootGroup);
        this.addDimensions(subsetDataset, rootGroup);
        this.addCoordinateAxes(subsetDataset, rootGroup);
        this.addCoverages(subsetDataset, rootGroup);
        this.addCoordTransforms(subsetDataset, rootGroup);
        boolean shouldAddLatLon2D = this.shouldAddLatLon2D(tryToAddLatLon2D, subsetDataset);
        if (shouldAddLatLon2D) {
            this.addLatLon2D(subsetDataset, rootGroup);
        }
        this.addCFAnnotations(subsetDataset, rootGroup, shouldAddLatLon2D);
        long totalSizeOfVars = writer.calcSize();
        if (maxBytes > 0L && totalSizeOfVars > maxBytes) {
            return Result.create(totalSizeOfVars, false, TOO_LARGE_MESSAGE);
        }
        try (NetcdfFormatWriter ncwriter = writer.build();){
            this.writeCoordinateData(subsetDataset, ncwriter);
            this.writeCoverageData(gdsOrg, subsetParams, subsetDataset, ncwriter);
            if (shouldAddLatLon2D) {
                this.writeLatLon2D(subsetDataset, ncwriter);
            }
        }
        return Result.create(0L, true, null);
    }

    private boolean shouldAddLatLon2D(boolean tryToAddLatLon2D, CoverageCollection subsetDataset) {
        if (!tryToAddLatLon2D) {
            return false;
        }
        HorizCoordSys horizCoordSys = subsetDataset.getHorizCoordSys();
        if (horizCoordSys.isLatLon2D()) {
            return false;
        }
        if (!horizCoordSys.isProjection()) {
            return false;
        }
        ProjectionImpl proj = horizCoordSys.getTransform().getProjection();
        return !(proj instanceof LatLonProjection);
    }

    private void addGlobalAttributes(CoverageCollection gds, Group.Builder group) {
        for (Attribute att : gds.getGlobalAttributes()) {
            if (att.getShortName().equals("file_format") || att.getShortName().equals("_CoordSysBuilder")) continue;
            group.addAttribute(att);
        }
        Attribute att = gds.findAttributeIgnoreCase("Conventions");
        if (att == null || !att.getStringValue().startsWith("CF-")) {
            group.addAttribute(new Attribute("Conventions", "CF-1.0"));
        }
        group.addAttribute(new Attribute("History", "Translated to CF-1.0 Conventions by Netcdf-Java CDM (CFGridCoverageWriter)\nOriginal Dataset = " + gds.getName() + "; Translation Date = " + CalendarDate.present()));
        LatLonRect llbb = gds.getLatlonBoundingBox();
        if (llbb != null) {
            group.addAttribute(new Attribute("geospatial_lat_min", llbb.getLatMin()));
            group.addAttribute(new Attribute("geospatial_lat_max", llbb.getLatMax()));
            group.addAttribute(new Attribute("geospatial_lon_min", llbb.getLonMin()));
            group.addAttribute(new Attribute("geospatial_lon_max", llbb.getLonMax()));
        }
    }

    private void addDimensions(CoverageCollection subsetDataset, Group.Builder group) {
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (CoverageCoordAxis axis : subsetDataset.getCoordAxes()) {
            Dimension d;
            if (axis.getDependenceType() == CoverageCoordAxis.DependenceType.independent) {
                d = Dimension.builder(axis.getName(), axis.getNcoords()).build();
                group.addDimension(d);
                dimHash.put(axis.getName(), d);
            }
            if (!axis.isInterval() || null != dimHash.get(BOUNDS_DIM)) continue;
            d = Dimension.builder(BOUNDS_DIM, 2).build();
            group.addDimension(d);
            dimHash.put(BOUNDS_DIM, d);
        }
    }

    private void addCoordinateAxes(CoverageCollection subsetDataset, Group.Builder parent) {
        for (CoverageCoordAxis axis : subsetDataset.getCoordAxes()) {
            Object vb;
            String dims = axis.getDependenceType() == CoverageCoordAxis.DependenceType.independent ? axis.getName() : (axis.getDependenceType() == CoverageCoordAxis.DependenceType.scalar ? "" : axis.getDependsOn());
            boolean hasBounds = false;
            if (axis.isInterval()) {
                vb = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(axis.getName() + BOUNDS)).setDataType(axis.getDataType())).setParentGroupBuilder(parent)).setDimensionsByName(dims + " " + BOUNDS_DIM);
                ((Variable.Builder)vb).addAttribute(new Attribute("units", axis.getUnits()));
                parent.addVariable((Variable.Builder<?>)vb);
                hasBounds = true;
            }
            vb = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(axis.getName())).setDataType(axis.getDataType())).setParentGroupBuilder(parent)).setDimensionsByName(dims);
            this.addVariableAttributes((Variable.Builder)vb, axis.getAttributeContainer());
            ((Variable.Builder)vb).addAttribute(new Attribute("units", axis.getUnits()));
            if (hasBounds) {
                ((Variable.Builder)vb).addAttribute(new Attribute("bounds", axis.getName() + BOUNDS));
            }
            if (axis.getAxisType() == AxisType.TimeOffset) {
                ((Variable.Builder)vb).addAttribute(new Attribute("standard_name", "forecast_period"));
            }
            parent.addVariable((Variable.Builder<?>)vb);
        }
    }

    private void addCoverages(CoverageCollection subsetDataset, Group.Builder parent) {
        for (Coverage grid : subsetDataset.getCoverages()) {
            Object vb = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(grid.getName())).setDataType(grid.getDataType())).setParentGroupBuilder(parent)).setDimensionsByName(grid.getIndependentAxisNamesOrdered());
            this.addVariableAttributes((Variable.Builder)vb, grid.attributes());
            parent.addVariable((Variable.Builder<?>)vb);
        }
    }

    private void addVariableAttributes(Variable.Builder vb, AttributeContainer atts) {
        AttributeContainer modified = AttributeContainer.filter(atts, "_Coordinate", "_Chunk");
        modified.forEach(vb::addAttribute);
    }

    private void addCoordTransforms(CoverageCollection subsetDataset, Group.Builder group) {
        for (CoverageTransform ct : subsetDataset.getCoordTransforms()) {
            Object ctv = ((Variable.Builder)Variable.builder().setName(ct.getName())).setDataType(DataType.INT);
            group.addVariable((Variable.Builder<?>)ctv);
            ((Variable.Builder)ctv).addAttributes(ct.attributes());
        }
    }

    private void addLatLon2D(CoverageCollection subsetDataset, Group.Builder group) {
        HorizCoordSys horizCoordSys = subsetDataset.getHorizCoordSys();
        CoverageCoordAxis1D xAxis = horizCoordSys.getXAxis();
        CoverageCoordAxis1D yAxis = horizCoordSys.getYAxis();
        Dimension xDim = group.findDimension(xAxis.getName()).orElseThrow(() -> new IllegalStateException("We should've added X dimension in addDimensions()."));
        Dimension yDim = group.findDimension(yAxis.getName()).orElseThrow(() -> new IllegalStateException("We should've added Y dimension in addDimensions()."));
        List<Dimension> dims = Arrays.asList(yDim, xDim);
        Object latVar = ((Variable.Builder)((Variable.Builder)Variable.builder().setName("lat")).setDataType(DataType.DOUBLE)).setDimensions(dims);
        ((Variable.Builder)latVar).addAttribute(new Attribute("units", "degrees_north"));
        ((Variable.Builder)latVar).addAttribute(new Attribute("standard_name", "latitude"));
        ((Variable.Builder)latVar).addAttribute(new Attribute("long_name", "latitude coordinate"));
        ((Variable.Builder)latVar).addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        group.addVariable((Variable.Builder<?>)latVar);
        Object lonVar = ((Variable.Builder)((Variable.Builder)Variable.builder().setName("lon")).setDataType(DataType.DOUBLE)).setDimensions(dims);
        ((Variable.Builder)lonVar).addAttribute(new Attribute("units", "degrees_east"));
        ((Variable.Builder)lonVar).addAttribute(new Attribute("standard_name", "longitude"));
        ((Variable.Builder)lonVar).addAttribute(new Attribute("long_name", "longitude coordinate"));
        ((Variable.Builder)lonVar).addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        group.addVariable((Variable.Builder<?>)lonVar);
    }

    private void addCFAnnotations(CoverageCollection gds, Group.Builder group, boolean shouldAddLatLon2D) {
        for (Coverage grid : gds.getCoverages()) {
            CoverageCoordSys gcs = grid.getCoordSys();
            Optional<Variable.Builder<?>> newVopt = group.findVariableLocal(grid.getName());
            if (!newVopt.isPresent()) {
                logger.error("CFGridCoverageWriter cant find " + grid.getName() + " in writer ");
                continue;
            }
            Variable.Builder<?> newV = newVopt.get();
            Formatter coordsAttribValFormatter = new Formatter();
            for (String axisName : grid.getCoordSys().getAxisNames()) {
                coordsAttribValFormatter.format("%s ", axisName);
            }
            if (shouldAddLatLon2D) {
                group.findVariableLocal("lat").orElseThrow(() -> new IllegalStateException("We should've added lat variable in addLatLon2D()"));
                group.findVariableLocal("lon").orElseThrow(() -> new IllegalStateException("We should've added lon variable in addLatLon2D()"));
                coordsAttribValFormatter.format("lat lon", new Object[0]);
            }
            newV.addAttribute(new Attribute("coordinates", coordsAttribValFormatter.toString()));
            CoverageTransform ct = gcs.getHorizTransform();
            if (ct == null || !ct.isHoriz()) continue;
            newV.addAttribute(new Attribute("grid_mapping", ct.getName()));
        }
        for (CoverageCoordAxis axis : gds.getCoordAxes()) {
            Optional<Variable.Builder<?>> newVopt = group.findVariableLocal(axis.getName());
            if (!newVopt.isPresent()) {
                logger.error("CFGridCoverageWriter cant find " + axis.getName() + " in writer ");
                continue;
            }
            Variable.Builder<?> newV = newVopt.get();
            if (axis.getAxisType() == AxisType.Lat) {
                newV.addAttribute(new Attribute("units", "degrees_north"));
                newV.addAttribute(new Attribute("standard_name", "latitude"));
            }
            if (axis.getAxisType() == AxisType.Lon) {
                newV.addAttribute(new Attribute("units", "degrees_east"));
                newV.addAttribute(new Attribute("standard_name", "longitude"));
            }
            if (axis.getAxisType() == AxisType.GeoX) {
                newV.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            }
            if (axis.getAxisType() == AxisType.GeoY) {
                newV.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            }
            if (axis.getAxisType() != AxisType.Ensemble) continue;
            newV.addAttribute(new Attribute("standard_name", "realization"));
        }
    }

    private void writeCoordinateData(CoverageCollection subsetDataset, NetcdfFormatWriter writer) throws IOException, InvalidRangeException {
        for (CoverageCoordAxis axis : subsetDataset.getCoordAxes()) {
            Variable v = writer.findVariable(axis.getName());
            if (v != null) {
                writer.write(v, axis.getCoordsAsArray());
            } else {
                logger.error("CFGridCoverageWriter No variable for {}", (Object)axis.getName());
            }
            if (!axis.isInterval()) continue;
            Variable vb = writer.findVariable(axis.getName() + BOUNDS);
            writer.write(vb, axis.getCoordBoundsAsArray());
        }
    }

    private void writeCoverageData(CoverageCollection gdsOrg, SubsetParams subsetParams, CoverageCollection subsetDataset, NetcdfFormatWriter writer) throws IOException, InvalidRangeException {
        for (Coverage coverage : subsetDataset.getCoverages()) {
            Coverage coverageOrg = gdsOrg.findCoverage(coverage.getName());
            GeoReferencedArray array = coverageOrg.readData(subsetParams);
            this.checkConformance(coverage, array, gdsOrg.getName());
            Variable v = writer.findVariable(coverage.getName());
            writer.write(v, array.getData());
        }
    }

    private void writeLatLon2D(CoverageCollection subsetDataset, NetcdfFormatWriter writer) throws IOException, InvalidRangeException {
        HorizCoordSys horizCoordSys = subsetDataset.getHorizCoordSys();
        CoverageCoordAxis1D xAxis = horizCoordSys.getXAxis();
        CoverageCoordAxis1D yAxis = horizCoordSys.getYAxis();
        ProjectionImpl proj = horizCoordSys.getTransform().getProjection();
        double[] xData = (double[])xAxis.getCoordsAsArray().get1DJavaArray(DataType.DOUBLE);
        double[] yData = (double[])yAxis.getCoordsAsArray().get1DJavaArray(DataType.DOUBLE);
        int numX = xData.length;
        int numY = yData.length;
        double[] latData = new double[numX * numY];
        double[] lonData = new double[numX * numY];
        for (int i = 0; i < numY; ++i) {
            for (int j = 0; j < numX; ++j) {
                ProjectionPoint projPoint = ProjectionPoint.create(xData[j], yData[i]);
                LatLonPoint latlonPoint = proj.projToLatLon(projPoint);
                latData[i * numX + j] = latlonPoint.getLatitude();
                lonData[i * numX + j] = latlonPoint.getLongitude();
            }
        }
        Variable latVar = writer.findVariable("lat");
        assert (latVar != null) : "We should have added lat var in addLatLon2D().";
        Array latDataArray = Array.factory(DataType.DOUBLE, new int[]{numY, numX}, (Object)latData);
        writer.write(latVar, latDataArray);
        Variable lonVar = writer.findVariable("lon");
        assert (lonVar != null) : "We should have added lon var in addLatLon2D().";
        Array lonDataArray = Array.factory(DataType.DOUBLE, new int[]{numY, numX}, (Object)lonData);
        writer.write(lonVar, lonDataArray);
    }

    private void checkConformance(Coverage gridSubset, GeoReferencedArray geo, String where) {
        CoverageCoordSys csys = gridSubset.getCoordSys();
        CoverageCoordSys csysData = geo.getCoordSysForData();
        Section s2 = new Section(csys.getShape());
        Section so = new Section(csysData.getShape());
        boolean ok = s2.conformal(so);
        int[] dataShape = geo.getData().getShape();
        Section sdata = new Section(dataShape);
        boolean ok2 = s2.conformal(sdata);
        if (!ok || !ok2) {
            logger.warn("CFGridCoverageWriter checkConformance fails " + where);
        }
    }

    public static class Result {
        private final long sizeToBeWritten;
        private final boolean wasWritten;
        @Nullable
        private final String errorMessage;

        private Result(long sizeToBeWritten, boolean wasWritten, @Nullable String errorMessage) {
            this.sizeToBeWritten = sizeToBeWritten;
            this.wasWritten = wasWritten;
            this.errorMessage = errorMessage;
        }

        public long sizeToBeWritten() {
            return this.sizeToBeWritten;
        }

        public boolean wasWritten() {
            return this.wasWritten;
        }

        @Nullable
        public String getErrorMessage() {
            return this.errorMessage;
        }

        public static Result create(long sizeToBeWritten, boolean wasWritten, @Nullable String errorMessage) {
            return new Result(sizeToBeWritten, wasWritten, errorMessage);
        }
    }
}

