/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.File;
import loci.common.Location;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import loci.formats.ReaderWrapper;
import loci.tests.testng.TestTools;
import nl.javadude.assumeng.Assumption;
import nl.javadude.assumeng.AssumptionListener;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Listeners;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Listeners(value={AssumptionListener.class})
public class OpenBytesPerformanceTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenBytesPerformanceTest.class);
    private String id;
    private IFormatReader reader;
    private int imageCount;
    private int seriesCount;
    private int sizeX;
    private int sizeY;
    private int sizeZ;
    private int sizeC;
    private int sizeT;
    private int bpp;
    private int topHalfSize;
    private int bottomHalfSize;
    private int topLeftQuarterSize;
    private int topRightQuarterSize;
    private int bottomLeftQuarterSize;
    private int bottomRightQuarterSize;
    private int optimalTileHeight;
    private int optimalTileWidth;
    private int planeSize;
    private String filename;
    private boolean memMap;
    private boolean bigImage = false;

    private void assertBlock(int blockSize, int posX, int posY, int width, int height) throws Exception {
        byte[] plane = new byte[this.planeSize];
        byte[] buf = new byte[blockSize];
        for (int i = 0; i < this.imageCount; ++i) {
            this.reader.openBytes(i, plane);
            try {
                this.reader.openBytes(i, buf, posX, posY, width, height);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("openBytes(series:%d i:%d, buf.length:%d, x:%d, y:%d, w:%d, h:%d) [sizeX: %d sizeY:%d bpp:%d] threw exception!", this.reader.getSeries(), i, buf.length, posX, posY, width, height, this.sizeX, this.sizeY, this.bpp), e);
            }
            String planeDigest = TestTools.md5(plane, this.sizeX, this.sizeY, posX, posY, width, height, this.bpp);
            String bufDigest = TestTools.md5(buf, 0, width * height * this.bpp);
            if (planeDigest.equals(bufDigest)) continue;
            AssertJUnit.fail((String)String.format("MD5:%d;%d len:%d %s != %s", this.reader.getSeries(), i, blockSize, planeDigest, bufDigest));
        }
    }

    private void assertRows(int blockSize) throws Exception {
        for (int series = 0; series < this.seriesCount; ++series) {
            this.assertSeries(series);
            byte[] plane = new byte[this.planeSize];
            byte[] buf = new byte[blockSize];
            int maximumRowCount = buf.length / this.bpp / this.sizeX;
            int pixelsToRead = this.sizeX * this.sizeY;
            int width = this.sizeX;
            int posX = 0;
            int posY = 0;
            for (int i = 0; i < this.imageCount; ++i) {
                this.reader.openBytes(i, plane);
                int offset = 0;
                while (pixelsToRead > 0) {
                    int height = maximumRowCount;
                    if (posY + height > this.sizeY) {
                        height = this.sizeY - posY;
                    }
                    int actualBufSize = this.bpp * height * width;
                    try {
                        this.reader.openBytes(i, buf, posX, posY, width, height);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("openBytes(series:%d i:%d, buf.length:%d, x:%d, y:%d, w:%d, h:%d) [sizeX: %d sizeY:%d bpp:%d] threw exception!", series, i, buf.length, posX, posY, width, height, this.sizeX, this.sizeY, this.bpp), e);
                    }
                    String planeDigest = TestTools.md5(plane, offset, actualBufSize);
                    String bufDigest = TestTools.md5(buf, 0, actualBufSize);
                    if (!planeDigest.equals(bufDigest)) {
                        AssertJUnit.fail((String)String.format("MD5:%s;%d offset:%d len:%d %s != %s", series, i, offset, actualBufSize, planeDigest, bufDigest));
                    }
                    offset += actualBufSize;
                    posY += height;
                    pixelsToRead -= height * width;
                }
            }
        }
    }

    private void assertSeries(int series) {
        this.reader.setSeries(series);
        this.sizeX = this.reader.getSizeX();
        this.sizeY = this.reader.getSizeY();
        this.sizeZ = this.reader.getSizeZ();
        this.sizeC = this.reader.getSizeC();
        this.sizeT = this.reader.getSizeT();
        this.imageCount = this.reader.getImageCount();
        this.bpp = FormatTools.getBytesPerPixel((int)this.reader.getPixelType());
        this.planeSize = this.sizeX * this.sizeY * this.bpp;
        this.topHalfSize = this.sizeY / 2 * this.sizeX * this.bpp;
        this.bottomHalfSize = (this.sizeY - this.sizeY / 2) * this.sizeX * this.bpp;
        this.topLeftQuarterSize = this.sizeY / 2 * (this.sizeX / 2) * this.bpp;
        this.topRightQuarterSize = this.sizeY / 2 * (this.sizeX - this.sizeX / 2) * this.bpp;
        this.bottomLeftQuarterSize = (this.sizeY - this.sizeY / 2) * (this.sizeX / 2) * this.bpp;
        this.bottomRightQuarterSize = (this.sizeY - this.sizeY / 2) * (this.sizeX - this.sizeX / 2) * this.bpp;
        if (!this.bigImage) {
            this.bigImage = this.sizeX * this.sizeY > 9000000;
        }
    }

    public boolean isNotBigImage() {
        return !this.bigImage;
    }

    @Parameters(value={"id", "inMemory"})
    @BeforeClass
    public void init(String id, String inMemory) throws Exception {
        this.id = id;
        this.filename = new File(id).getName();
        this.memMap = Boolean.parseBoolean(inMemory);
    }

    @AfterClass
    public void tearDown() throws Exception {
        Location.mapId((String)this.id, null);
        this.reader.close();
    }

    @Test
    public void setId() throws Exception {
        this.reader = new ImageReader();
        this.reader = new ChannelFiller(this.reader);
        this.reader = new ChannelSeparator(this.reader);
        this.reader = new MinMaxCalculator(this.reader);
        if (this.memMap && this.reader.isSingleFile(this.id)) {
            TestTools.mapFile(this.id);
        }
        Slf4JStopWatch stopWatch = new Slf4JStopWatch();
        this.reader.setId(this.id);
        stopWatch.stop(String.format("%s.setId.%s", ((ReaderWrapper)this.reader).unwrap().getClass().getName(), this.filename));
        this.seriesCount = this.reader.getSeriesCount();
    }

    @Test(dependsOnMethods={"setId"})
    public void testOpenBytesAllTilesNewBuffer() throws Exception {
        for (int series = 0; series < this.seriesCount; ++series) {
            this.assertSeries(series);
            for (int image = 0; image < this.imageCount; ++image) {
                LOGGER.info("Reading from series {} image {}", (Object)series, (Object)image);
                this.optimalTileWidth = this.reader.getOptimalTileWidth();
                this.optimalTileHeight = this.reader.getOptimalTileHeight();
                LOGGER.info("Optimal tile {}x{}", (Object)this.optimalTileWidth, (Object)this.optimalTileHeight);
                int tilesWide = (int)Math.ceil((double)this.sizeX / (double)this.optimalTileWidth);
                int tilesHigh = (int)Math.ceil((double)this.sizeY / (double)this.optimalTileHeight);
                LOGGER.info("Tile counts {}x{}", (Object)tilesWide, (Object)tilesHigh);
                int y = 0;
                for (int tileX = 0; tileX < tilesWide; ++tileX) {
                    for (int tileY = 0; tileY < tilesHigh; ++tileY) {
                        int x = tileX * this.optimalTileWidth;
                        y = tileY * this.optimalTileHeight;
                        int actualTileWidth = Math.min(this.optimalTileWidth, this.reader.getSizeX() - x);
                        int actualTileHeight = Math.min(this.optimalTileHeight, this.reader.getSizeY() - y);
                        LOGGER.info("Reading tile at {}x{}", (Object)x, (Object)y);
                        Slf4JStopWatch stopWatch = new Slf4JStopWatch(String.format("%s.alloc_tile.%s.[%d:%d]", ((ReaderWrapper)this.reader).unwrap().getClass().getName(), this.filename, series, image));
                        this.reader.openBytes(0, x, y, actualTileWidth, actualTileHeight);
                        stopWatch.stop();
                    }
                }
            }
        }
    }

    @Test(dependsOnMethods={"setId"})
    @Assumption(methods={"isNotBigImage"})
    public void testOpenBytesAllTilesPreAllocatedBuffer() throws Exception {
        for (int series = 0; series < this.seriesCount; ++series) {
            this.assertSeries(series);
            for (int image = 0; image < this.imageCount; ++image) {
                LOGGER.info("Reading from series {} image {}", (Object)series, (Object)image);
                this.optimalTileWidth = this.reader.getOptimalTileWidth();
                this.optimalTileHeight = this.reader.getOptimalTileHeight();
                LOGGER.info("Optimal tile {}x{}", (Object)this.optimalTileWidth, (Object)this.optimalTileHeight);
                int tilesWide = (int)Math.ceil((double)this.sizeX / (double)this.optimalTileWidth);
                int tilesHigh = (int)Math.ceil((double)this.sizeY / (double)this.optimalTileHeight);
                LOGGER.info("Tile counts {}x{}", (Object)tilesWide, (Object)tilesHigh);
                int y = 0;
                byte[] buf = new byte[this.optimalTileWidth * this.optimalTileHeight * FormatTools.getBytesPerPixel((int)this.reader.getPixelType())];
                LOGGER.info("Allocated buffer size: {}", (Object)buf.length);
                for (int tileX = 0; tileX < tilesWide; ++tileX) {
                    for (int tileY = 0; tileY < tilesHigh; ++tileY) {
                        int x = tileX * this.optimalTileWidth;
                        y = tileY * this.optimalTileHeight;
                        int actualTileWidth = Math.min(this.optimalTileWidth, this.reader.getSizeX() - x);
                        int actualTileHeight = Math.min(this.optimalTileHeight, this.reader.getSizeY() - y);
                        LOGGER.info("Reading tile at {}x{}", (Object)x, (Object)y);
                        Slf4JStopWatch stopWatch = new Slf4JStopWatch(String.format("%s.prealloc_tile.%s.[%d:%d]", ((ReaderWrapper)this.reader).unwrap().getClass().getName(), this.filename, series, image));
                        this.reader.openBytes(image, buf, x, y, actualTileWidth, actualTileHeight);
                        stopWatch.stop();
                    }
                }
            }
        }
    }

    @Test(dependsOnMethods={"setId"})
    @Assumption(methods={"isNotBigImage"})
    public void testOpenBytesPlane() throws Exception {
        for (int series = 0; series < this.seriesCount; ++series) {
            this.assertSeries(series);
            byte[] plane = new byte[this.planeSize];
            for (int i = 0; i < this.reader.getImageCount(); ++i) {
                this.reader.openBytes(i, plane);
            }
        }
    }

    @Test(dependsOnMethods={"setId"})
    @Assumption(methods={"isNotBigImage"})
    public void testOpenBytesHalfPlane() throws Exception {
        for (int series = 0; series < this.seriesCount; ++series) {
            this.assertSeries(series);
            byte[] plane = new byte[this.planeSize];
            byte[] topHalfPlane = new byte[this.topHalfSize];
            byte[] bottomHalfPlane = new byte[this.bottomHalfSize];
            for (int i = 0; i < this.imageCount; ++i) {
                this.reader.openBytes(i, plane);
                this.reader.openBytes(i, topHalfPlane, 0, 0, this.sizeX, this.sizeY / 2);
                String planeDigest = TestTools.md5(plane, 0, this.topHalfSize);
                String halfPlaneDigest = TestTools.md5(topHalfPlane, 0, this.topHalfSize);
                if (!planeDigest.equals(halfPlaneDigest)) {
                    AssertJUnit.fail((String)String.format("First half MD5:%d;%d %s != %s", series, i, planeDigest, halfPlaneDigest));
                }
                this.reader.openBytes(i, bottomHalfPlane, 0, this.sizeY / 2, this.sizeX, this.sizeY - this.sizeY / 2);
                planeDigest = TestTools.md5(plane, this.topHalfSize, this.bottomHalfSize);
                halfPlaneDigest = TestTools.md5(bottomHalfPlane, 0, this.bottomHalfSize);
                if (planeDigest.equals(halfPlaneDigest)) continue;
                AssertJUnit.fail((String)String.format("Second half MD5:%d;%d %s != %s", series, i, planeDigest, halfPlaneDigest));
            }
        }
    }

    @Test(dependsOnMethods={"setId"})
    @Assumption(methods={"isNotBigImage"})
    public void testQuartersActualSize() throws Exception {
        for (int series = 0; series < this.seriesCount; ++series) {
            this.assertSeries(series);
            this.assertBlock(this.topLeftQuarterSize, 0, 0, this.sizeX / 2, this.sizeY / 2);
            this.assertBlock(this.topRightQuarterSize, this.sizeX / 2, 0, this.sizeX - this.sizeX / 2, this.sizeY / 2);
            this.assertBlock(this.bottomLeftQuarterSize, 0, this.sizeY / 2, this.sizeX / 2, this.sizeY - this.sizeY / 2);
            this.assertBlock(this.bottomRightQuarterSize, this.sizeX / 2, this.sizeY / 2, this.sizeX - this.sizeX / 2, this.sizeY - this.sizeY / 2);
        }
    }

    @Test(dependsOnMethods={"setId"})
    @Assumption(methods={"isNotBigImage"})
    public void testQuartersTwiceActualSize() throws Exception {
        for (int series = 0; series < this.seriesCount; ++series) {
            this.assertSeries(series);
            this.assertBlock(this.topLeftQuarterSize * 2, 0, 0, this.sizeX / 2, this.sizeY / 2);
            this.assertBlock(this.topRightQuarterSize * 2, this.sizeX / 2, 0, this.sizeX - this.sizeX / 2, this.sizeY / 2);
            this.assertBlock(this.bottomLeftQuarterSize * 2, 0, this.sizeY / 2, this.sizeX / 2, this.sizeY - this.sizeY / 2);
            this.assertBlock(this.bottomRightQuarterSize * 2, this.sizeX / 2, this.sizeY / 2, this.sizeX - this.sizeX / 2, this.sizeY - this.sizeY / 2);
        }
    }

    @Test(dependsOnMethods={"setId"})
    @Assumption(methods={"isNotBigImage"})
    public void testOpenBytesBlocksByRow512KB() throws Exception {
        this.assertRows(524288);
    }

    @Test(dependsOnMethods={"setId"})
    @Assumption(methods={"isNotBigImage"})
    public void testOpenBytesBlocksByRow1MB() throws Exception {
        this.assertRows(0x100000);
    }

    @Test(dependsOnMethods={"setId"})
    @Assumption(methods={"isNotBigImage"})
    public void testOpenBytesBlocksByRowPlaneSize() throws Exception {
        this.assertRows(this.sizeX * this.sizeY * this.bpp);
    }
}

