/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.IOException;
import loci.common.Location;
import loci.formats.DimensionSwapper;
import loci.formats.FormatException;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DimensionSwapperTest {
    private static final int SIZE_C = 2;
    private static final int SIZE_T = 5;
    private static final int SIZE_Z = 4;
    private static final String NEW_ORDER = "XYCTZ";
    private static final String OUTPUT_ORDER = "XYZCT";
    private static final String TEST_FILE = "test&pixelType=uint8&sizeX=128&sizeY=64&sizeC=2&sizeZ=4&sizeT=5&series=3.fake";

    @DataProvider(name="swapper")
    public Object[][] createDimSwapper() {
        Location.mapId((String)TEST_FILE, (String)TEST_FILE);
        DimensionSwapper swapper = new DimensionSwapper();
        try {
            swapper.setId(TEST_FILE);
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        swapper.setOutputOrder(OUTPUT_ORDER);
        return new Object[][]{{swapper}};
    }

    @Test(dataProvider="swapper")
    public void testOutputOrdering(DimensionSwapper swapper) {
        swapper.setOutputOrder(NEW_ORDER);
        AssertJUnit.assertEquals((boolean)swapper.getDimensionOrder().equals(NEW_ORDER), (boolean)true);
        AssertJUnit.assertEquals((int)swapper.getSizeZ(), (int)4);
        AssertJUnit.assertEquals((int)swapper.getSizeC(), (int)2);
        AssertJUnit.assertEquals((int)swapper.getSizeT(), (int)5);
    }

    @Test(dataProvider="swapper")
    public void testInputOrdering(DimensionSwapper swapper) {
        swapper.swapDimensions(NEW_ORDER);
        AssertJUnit.assertEquals((boolean)swapper.getDimensionOrder().equals(OUTPUT_ORDER), (boolean)true);
        AssertJUnit.assertEquals((int)swapper.getSizeZ(), (int)5);
        AssertJUnit.assertEquals((int)swapper.getSizeC(), (int)4);
        AssertJUnit.assertEquals((int)swapper.getSizeT(), (int)2);
    }

    @Test(dataProvider="swapper")
    public void testInputOutputOrdering(DimensionSwapper swapper) {
        swapper.setOutputOrder(NEW_ORDER);
        swapper.swapDimensions(NEW_ORDER);
        AssertJUnit.assertEquals((boolean)swapper.getDimensionOrder().equals(NEW_ORDER), (boolean)true);
        AssertJUnit.assertEquals((int)swapper.getSizeZ(), (int)5);
        AssertJUnit.assertEquals((int)swapper.getSizeC(), (int)4);
        AssertJUnit.assertEquals((int)swapper.getSizeT(), (int)2);
    }
}

