/*
 * Decompiled with CFR 0.152.
 */
package spec.schema;

import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.services.OMEXMLService;
import ome.xml.model.Image;
import ome.xml.model.OME;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"all"})
public class Schema2011_06_TO_2012_06_Test {
    private static final Templates UPDATE_201106 = XMLTools.getStylesheet((String)"/transforms/2011-06-to-2012-06.xsl", Schema2011_06_TO_2012_06_Test.class);
    private static final String RESOURCE = "/spec/schema/samples/2011-06/6x4y1z1t1c8b-swatch.ome";
    private static final String IMAGE_NAME = "6x6x1x8-swatch.tif";
    private static final String IMAGE_DATE = "2010-02-23T12:51:30";
    private OME ome;

    @BeforeClass
    public void setUp() throws Exception {
        InputStream source = this.getClass().getResourceAsStream(RESOURCE);
        ServiceFactory sf = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        String xml = XMLTools.transformXML((Source)new StreamSource(source), (Templates)UPDATE_201106);
        this.ome = (OME)service.createOMEXMLRoot(xml);
    }

    @Test
    public void testName() {
        Assert.assertNotNull((Object)this.ome);
        Assert.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        Image image = this.ome.getImage(0);
        Assert.assertNotNull((Object)image);
        Assert.assertEquals((String)IMAGE_NAME, (String)image.getName());
    }

    @Test
    public void testDate() {
        Assert.assertNotNull((Object)this.ome);
        Assert.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        Image image = this.ome.getImage(0);
        Assert.assertNotNull((Object)image);
        Assert.assertEquals((Object)IMAGE_DATE, (Object)image.getAcquisitionDate());
    }
}

