/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record.formula;

import loci.poi.hssf.model.Workbook;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.formula.Ptg;
import loci.poi.util.LittleEndian;

public class MemAreaPtg
extends Ptg {
    public static final short sid = 38;
    private static final int SIZE = 7;
    private int field_1_reserved;
    private short field_2_subex_len;

    public MemAreaPtg() {
    }

    public MemAreaPtg(RecordInputStream in) {
        this.field_1_reserved = in.readInt();
        this.field_2_subex_len = in.readShort();
    }

    public void setReserved(int res) {
        this.field_1_reserved = res;
    }

    public int getReserved() {
        return this.field_1_reserved;
    }

    public void setSubexpressionLength(short subexlen) {
        this.field_2_subex_len = subexlen;
    }

    public short getSubexpressionLength() {
        return this.field_2_subex_len;
    }

    @Override
    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(38 + this.ptgClass);
        LittleEndian.putInt(array, offset + 1, this.field_1_reserved);
        LittleEndian.putShort(array, offset + 5, this.field_2_subex_len);
    }

    @Override
    public int getSize() {
        return 7;
    }

    @Override
    public String toFormulaString(Workbook book) {
        return "";
    }

    @Override
    public byte getDefaultOperandClass() {
        return 32;
    }

    @Override
    public Object clone() {
        MemAreaPtg ptg = new MemAreaPtg();
        ptg.field_1_reserved = this.field_1_reserved;
        ptg.field_2_subex_len = this.field_2_subex_len;
        return ptg;
    }
}

