/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.awt.color.ColorSpace;

public final class InvertedCMYKColorSpace
extends ColorSpace {
    private static ColorSpace theInstance = null;
    private ColorSpace csRGB = ColorSpace.getInstance(1004);
    private static final double power1 = 0.4166666666666667;

    public static final synchronized ColorSpace getInstance() {
        if (theInstance == null) {
            theInstance = new InvertedCMYKColorSpace();
        }
        return theInstance;
    }

    private InvertedCMYKColorSpace() {
        super(9, 4);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof InvertedCMYKColorSpace;
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        float C2 = colorvalue[0];
        float M = colorvalue[1];
        float Y = colorvalue[2];
        float K2 = colorvalue[3];
        float[] rgbvalue = new float[]{K2 * C2, K2 * M, K2 * Y};
        for (int i = 0; i < 3; ++i) {
            float v = rgbvalue[i];
            if (v < 0.0f) {
                v = 0.0f;
            }
            if (v < 0.0031308f) {
                rgbvalue[i] = 12.92f * v;
                continue;
            }
            if (v > 1.0f) {
                v = 1.0f;
            }
            rgbvalue[i] = (float)(1.055 * Math.pow(v, 0.4166666666666667) - 0.055);
        }
        return rgbvalue;
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        for (int i = 0; i < 3; ++i) {
            if (rgbvalue[i] < 0.040449936f) {
                int n = i;
                rgbvalue[n] = rgbvalue[n] / 12.92f;
                continue;
            }
            rgbvalue[i] = (float)Math.pow(((double)rgbvalue[i] + 0.055) / 1.055, 2.4);
        }
        float C2 = rgbvalue[0];
        float M = rgbvalue[1];
        float Y = rgbvalue[2];
        float K2 = Math.max(C2, Math.max(M, Y));
        if (K2 != 0.0f) {
            C2 /= K2;
            M /= K2;
            Y /= K2;
        } else {
            Y = 1.0f;
            M = 1.0f;
            C2 = 1.0f;
        }
        return new float[]{C2, M, Y, K2};
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        return this.csRGB.toCIEXYZ(this.toRGB(colorvalue));
    }

    @Override
    public float[] fromCIEXYZ(float[] xyzvalue) {
        return this.fromRGB(this.csRGB.fromCIEXYZ(xyzvalue));
    }
}

