/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class SISReader
extends BaseTiffReader {
    private static final int SIS_TAG = 33560;
    private static final int SIS_INI_TAG = 33471;
    private static final int SIS_TAG_2 = 34853;
    private String imageName;
    private double magnification;
    private String channelName;
    private String cameraName;
    private double physicalSizeX;
    private double physicalSizeY;
    private String acquisitionDate;

    public SISReader() {
        super("Olympus SIS TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.suffixNecessary = true;
        this.domains = new String[]{"Unknown"};
        this.canSeparateSeries = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        String make = ifd.getIFDTextValue(271);
        return ifd.get(33560) != null && (software == null || software.startsWith("analySIS")) || ifd.get(34853) != null && make != null && make.startsWith("Olympus");
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.imageName = null;
            this.channelName = null;
            this.cameraName = null;
            this.magnification = 0.0;
            this.physicalSizeY = 0.0;
            this.physicalSizeX = 0.0;
        }
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        int length;
        int t2;
        int c;
        IniParser parser;
        IniList ini;
        IniTable dimensions;
        int z;
        super.initStandardMetadata();
        IFD ifd = (IFD)this.ifds.get(0);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0, 0);
        String iniMetadata = ifd.getIFDTextValue(33471);
        if (iniMetadata != null && (z = Integer.parseInt((String)(dimensions = (ini = (parser = new IniParser()).parseINI(new BufferedReader(new StringReader(iniMetadata)))).getTable("Dimension")).get("Z"))) * (c = Integer.parseInt((String)dimensions.get("Band"))) * (t2 = Integer.parseInt((String)dimensions.get("Time"))) == this.ifds.size()) {
            m4.sizeZ = z;
            m4.sizeT = t2;
            m4.sizeC *= c;
        }
        if (!ifd.containsKey(33560)) {
            this.in.seek(ifd.getIFDLongValue(34853, 0L));
            while (!this.in.readString(2).equals("IS")) {
                this.in.seek(this.in.getFilePointer() - 1L);
            }
            this.in.skipBytes(28);
            this.in.seek(this.in.readLong() - 84L);
            this.physicalSizeX = this.in.readDouble() * 1000.0;
            this.physicalSizeY = this.in.readDouble() * 1000.0;
            return;
        }
        long metadataPointer = ifd.getIFDLongValue(33560, 0L);
        this.in.seek(metadataPointer);
        this.in.skipBytes(4);
        this.in.skipBytes(6);
        short minute = this.in.readShort();
        short hour = this.in.readShort();
        short day = this.in.readShort();
        int month = this.in.readShort() + 1;
        int year = 1900 + this.in.readShort();
        this.acquisitionDate = year + "-" + month + "-" + day + " " + hour + ":" + minute;
        this.acquisitionDate = DateTools.formatDate(this.acquisitionDate, "yyyy-M-d H:m");
        this.in.skipBytes(6);
        this.imageName = this.in.readCString().trim();
        this.in.seek(metadataPointer);
        this.in.skip(60L);
        this.in.skipBytes(2);
        this.in.skipBytes(2);
        byte[] bytes = new byte[4];
        for (int k = 0; k < 4; ++k) {
            bytes[k] = this.in.readByte();
        }
        long tagOffset = DataTools.bytesToInt(bytes, true);
        if (tagOffset >= this.in.length()) {
            return;
        }
        if (tagOffset > 0L) {
            this.in.seek(tagOffset);
        }
        this.in.skipBytes(10);
        double unitExp = this.in.readShort();
        this.physicalSizeX = this.in.readDouble();
        this.physicalSizeY = this.in.readDouble();
        if (Math.abs(this.physicalSizeX - this.physicalSizeY) > 1.0E-6) {
            this.physicalSizeX = this.physicalSizeY;
            this.physicalSizeY = this.in.readDouble();
        }
        if (unitExp >= -12.0 && unitExp <= 12.0) {
            double unitMultiplier = Math.pow(10.0, unitExp) * Math.pow(10.0, 6.0);
            this.physicalSizeX *= unitMultiplier;
            this.physicalSizeY *= unitMultiplier;
        }
        this.in.skipBytes(8);
        this.magnification = this.in.readDouble();
        short cameraNameLength = this.in.readShort();
        this.channelName = this.in.readCString().trim();
        if (this.channelName.length() > 128) {
            this.channelName = "";
        }
        if ((length = Math.min(cameraNameLength, this.channelName.length())) > 0) {
            this.cameraName = this.channelName.substring(0, length);
        }
        this.getGlobalMetadata().remove("XResolution");
        this.getGlobalMetadata().remove("YResolution");
        this.addGlobalMeta("Nanometers per pixel (X)", this.physicalSizeX);
        this.addGlobalMeta("Nanometers per pixel (Y)", this.physicalSizeY);
        this.addGlobalMeta("Magnification", this.magnification);
        this.addGlobalMeta("Channel name", this.channelName);
        this.addGlobalMeta("Camera name", this.cameraName);
        this.addGlobalMeta("Image name", this.imageName);
        this.addGlobalMeta("Acquisition date", this.acquisitionDate);
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageName(this.imageName, 0);
        if (this.acquisitionDate != null) {
            store.setImageAcquisitionDate(new Timestamp(this.acquisitionDate), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrument = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrument, 0);
            store.setImageInstrumentRef(instrument, 0);
            String objective = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objective, 0, 0);
            store.setObjectiveNominalMagnification(this.magnification, 0, 0);
            store.setObjectiveCorrection(MetadataTools.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(MetadataTools.getImmersion("Other"), 0, 0);
            store.setObjectiveSettingsID(objective, 0);
            String detector = MetadataTools.createLSID("Detector", 0, 0);
            store.setDetectorID(detector, 0, 0);
            store.setDetectorModel(this.cameraName, 0, 0);
            store.setDetectorType(MetadataTools.getDetectorType("Other"), 0, 0);
            store.setDetectorSettingsID(detector, 0, 0);
            Length sizeX = FormatTools.getPhysicalSizeX(this.physicalSizeX);
            Length sizeY = FormatTools.getPhysicalSizeY(this.physicalSizeY);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            store.setChannelName(this.channelName, 0, 0);
        }
    }
}

