/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.cache.ByteArraySource;
import loci.formats.cache.Cache;
import loci.formats.cache.CacheEvent;
import loci.formats.cache.CacheListener;
import loci.formats.cache.CacheStrategy;
import loci.formats.cache.CrosshairStrategy;
import loci.formats.cache.ICacheSource;
import loci.formats.cache.ICacheStrategy;
import loci.formats.cache.RectangleStrategy;
import loci.formats.gui.BufferedImageSource;
import loci.formats.gui.CacheComponent;

public final class CacheConsole {
    private CacheConsole() {
    }

    public static void main(String[] args) throws FormatException, IOException {
        if (args.length < 1) {
            System.out.println("Please specify a filename containing image data.");
            System.exit(1);
        }
        ImageReader reader = new ImageReader();
        String id = args[0];
        System.out.println("Reading " + id);
        reader.setId(id);
        System.out.println("Initializing cache");
        final Cache cache = new Cache(new CrosshairStrategy(CacheConsole.getLengths(reader)), new BufferedImageSource(reader), true);
        CacheListener l = new CacheListener(){

            @Override
            public void cacheUpdated(CacheEvent e) {
                int type = e.getType();
                int ndx = e.getIndex();
                switch (type) {
                    case 1: {
                        CacheConsole.printSource("source ->", cache);
                        break;
                    }
                    case 2: {
                        CacheConsole.printStrategy("strategy ->", cache);
                        break;
                    }
                    case 3: {
                        int[] len = cache.getStrategy().getLengths();
                        int[] pos = FormatTools.rasterToPosition(len, ndx);
                        CacheConsole.printArray("pos ->", pos);
                        break;
                    }
                    case 4: {
                        CacheConsole.printArray("priorities ->", cache.getStrategy().getPriorities());
                        break;
                    }
                    case 5: {
                        CacheConsole.printOrder("order ->", cache);
                        break;
                    }
                    case 6: {
                        CacheConsole.printArray("range ->", cache.getStrategy().getRange());
                        break;
                    }
                    case 7: {
                        int[] len = cache.getStrategy().getLengths();
                        int[] pos = FormatTools.rasterToPosition(len, ndx);
                        CacheConsole.printArray("loaded:", pos);
                        break;
                    }
                    case 8: {
                        int[] len = cache.getStrategy().getLengths();
                        int[] pos = FormatTools.rasterToPosition(len, ndx);
                        CacheConsole.printArray("dropped:", pos);
                    }
                }
            }
        };
        cache.addCacheListener(l);
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        System.out.println("Entering Bio-Formats caching test console");
        while (true) {
            ICacheStrategy strategy;
            System.out.print("> ");
            String cmd = r.readLine().trim();
            if (cmd.equals("")) continue;
            if (cmd.startsWith("c")) {
                cache.recache();
                continue;
            }
            if (cmd.startsWith("e") || cmd.startsWith("q")) break;
            if (cmd.startsWith("g")) {
                String[] axes = new String[]{"Z", "C", "T"};
                CacheComponent widget = new CacheComponent(cache, axes, id);
                widget.setBorder(new EmptyBorder(15, 15, 15, 15));
                JFrame frame = new JFrame("Cache controls");
                frame.setDefaultCloseOperation(2);
                frame.setContentPane(widget);
                frame.pack();
                frame.setVisible(true);
                continue;
            }
            if (cmd.startsWith("h")) {
                System.out.println("Available commands:");
                System.out.println("  cache    -- begins loading planes into the cache");
                System.out.println("  gui      -- pops up a GUI to configure the cache");
                System.out.println("  info     -- displays the cache state");
                System.out.println("  position -- changes the current position");
                System.out.println("  strategy -- changes the cache strategy");
                System.out.println("  source   -- changes the cache source");
                System.out.println("  priority -- changes the cache priorities");
                System.out.println("  order    -- changes the cache order");
                System.out.println("  range    -- changes the cache ranges");
                System.out.println("  read     -- gets a plane from the cache");
                System.out.println("  exit     -- quits the interpreter");
                continue;
            }
            if (cmd.startsWith("i")) {
                CacheConsole.printArray("pos =", cache.getCurrentPos());
                ICacheSource source = cache.getSource();
                CacheConsole.printSource("source =", cache);
                System.out.println("object count = " + source.getObjectCount());
                ICacheStrategy strategy2 = cache.getStrategy();
                CacheConsole.printStrategy("strategy =", cache);
                CacheConsole.printArray("priorities =", strategy2.getPriorities());
                CacheConsole.printOrder("order =", cache);
                CacheConsole.printArray("range =", strategy2.getRange());
                CacheConsole.printArray("lengths =", strategy2.getLengths());
                continue;
            }
            if (cmd.startsWith("o")) {
                System.out.println("0 => centered");
                System.out.println("1 => forward");
                System.out.println("-1 => backward");
                System.out.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                System.out.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                System.out.print("T: ");
                int t2 = Integer.parseInt(r.readLine().trim());
                strategy = cache.getStrategy();
                strategy.setOrder(z, 0);
                strategy.setOrder(c, 1);
                strategy.setOrder(t2, 2);
                continue;
            }
            if (cmd.startsWith("po")) {
                System.out.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                System.out.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                System.out.print("T: ");
                int t3 = Integer.parseInt(r.readLine().trim());
                cache.setCurrentPos(new int[]{z, c, t3});
                continue;
            }
            if (cmd.startsWith("pr")) {
                System.out.println("-10 => min priority");
                System.out.println("-5 => low priority");
                System.out.println("0 => normal priority");
                System.out.println("5 => high priority");
                System.out.println("10 => max priority");
                System.out.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                System.out.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                System.out.print("T: ");
                int t4 = Integer.parseInt(r.readLine().trim());
                strategy = cache.getStrategy();
                strategy.setPriority(z, 0);
                strategy.setPriority(c, 1);
                strategy.setPriority(t4, 2);
                continue;
            }
            if (cmd.startsWith("ra")) {
                System.out.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                System.out.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                System.out.print("T: ");
                int t5 = Integer.parseInt(r.readLine().trim());
                cache.getStrategy().setRange(z, 0);
                cache.getStrategy().setRange(c, 1);
                cache.getStrategy().setRange(t5, 2);
                continue;
            }
            if (cmd.startsWith("re")) {
                System.out.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                System.out.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                System.out.print("T: ");
                int t6 = Integer.parseInt(r.readLine().trim());
                System.out.println("Retrieving Z" + z + "-C" + c + "-T" + t6);
                Object o = cache.getObject(new int[]{z, c, t6});
                System.out.println(o);
                continue;
            }
            if (cmd.startsWith("so")) {
                System.out.println("0: BufferedImage");
                System.out.println("1: byte array");
                System.out.print("> ");
                int n = Integer.parseInt(r.readLine().trim());
                switch (n) {
                    case 0: {
                        cache.setSource(new BufferedImageSource(reader));
                        break;
                    }
                    case 1: {
                        cache.setSource(new ByteArraySource(reader));
                        break;
                    }
                    default: {
                        System.out.println("Unknown source: " + n);
                        break;
                    }
                }
                continue;
            }
            if (cmd.startsWith("st")) {
                System.out.println("0: crosshair");
                System.out.println("1: rectangle");
                System.out.print("> ");
                int n = Integer.parseInt(r.readLine().trim());
                int[] zct = CacheConsole.getLengths(reader);
                CacheStrategy strategy3 = null;
                switch (n) {
                    case 0: {
                        strategy3 = new CrosshairStrategy(zct);
                        break;
                    }
                    case 1: {
                        strategy3 = new RectangleStrategy(zct);
                        break;
                    }
                    default: {
                        System.out.println("Unknown strategy: " + n);
                    }
                }
                if (strategy3 == null) continue;
                ICacheStrategy old = cache.getStrategy();
                int[] priorities = old.getPriorities();
                int[] range = old.getRange();
                int[] order = old.getOrder();
                for (int i = 0; i < zct.length; ++i) {
                    strategy3.setPriority(priorities[i], i);
                    strategy3.setRange(range[i], i);
                    strategy3.setOrder(order[i], i);
                }
                cache.setStrategy(strategy3);
                continue;
            }
            System.out.println("Unknown command: " + cmd);
        }
        reader.close();
    }

    private static final void printArray(String prefix, int[] array) {
        System.out.print(prefix);
        if (array == null) {
            System.out.println(" null");
        } else {
            for (int i = 0; i < array.length; ++i) {
                System.out.print(" " + array[i]);
            }
            System.out.println();
        }
    }

    private static final void printSource(String prefix, Cache cache) {
        ICacheSource source = cache.getSource();
        System.out.print(prefix + " ");
        Class<?> sourceClass = source.getClass();
        if (sourceClass == BufferedImageSource.class) {
            System.out.println("BufferedImage");
        } else if (sourceClass == ByteArraySource.class) {
            System.out.println("byte array");
        } else {
            System.out.println("unknown");
        }
    }

    private static final void printStrategy(String prefix, Cache cache) {
        ICacheStrategy strategy = cache.getStrategy();
        System.out.print(prefix + " ");
        Class<?> strategyClass = strategy.getClass();
        if (strategyClass == CrosshairStrategy.class) {
            System.out.println("crosshair");
        } else if (strategyClass == RectangleStrategy.class) {
            System.out.println("rectangle");
        } else {
            System.out.println("unknown");
        }
    }

    private static final void printOrder(String prefix, Cache cache) {
        ICacheStrategy strategy = cache.getStrategy();
        int[] order = strategy.getOrder();
        System.out.print(prefix);
        block5: for (int i = 0; i < order.length; ++i) {
            switch (order[i]) {
                case 0: {
                    System.out.print(" C");
                    continue block5;
                }
                case 1: {
                    System.out.print(" F");
                    continue block5;
                }
                case -1: {
                    System.out.print(" B");
                    continue block5;
                }
                default: {
                    System.out.print(" ?");
                }
            }
        }
        System.out.println();
    }

    private static final int[] getLengths(IFormatReader r) {
        return new int[]{r.getSizeZ(), r.getSizeC(), r.getSizeT()};
    }
}

