/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import org.libjpegturbo.turbojpeg.TJLoader;
import org.libjpegturbo.turbojpeg.TJScalingFactor;

public final class TJ {
    public static final int NUMSAMP = 5;
    public static final int SAMP_444 = 0;
    public static final int SAMP_422 = 1;
    public static final int SAMP_420 = 2;
    public static final int SAMP_GRAY = 3;
    public static final int SAMP_440 = 4;
    private static final int[] mcuWidth = new int[]{8, 16, 16, 8, 8};
    private static final int[] mcuHeight = new int[]{8, 8, 16, 8, 16};
    public static final int NUMPF = 11;
    public static final int PF_RGB = 0;
    public static final int PF_BGR = 1;
    public static final int PF_RGBX = 2;
    public static final int PF_BGRX = 3;
    public static final int PF_XBGR = 4;
    public static final int PF_XRGB = 5;
    public static final int PF_GRAY = 6;
    public static final int PF_RGBA = 7;
    public static final int PF_BGRA = 8;
    public static final int PF_ABGR = 9;
    public static final int PF_ARGB = 10;
    private static final int[] pixelSize = new int[]{3, 3, 4, 4, 4, 4, 1, 4, 4, 4, 4};
    private static final int[] redOffset = new int[]{0, 2, 0, 2, 3, 1, 0, 0, 2, 3, 1};
    private static final int[] greenOffset = new int[]{1, 1, 1, 1, 2, 2, 0, 1, 1, 2, 2};
    private static final int[] blueOffset = new int[]{2, 0, 2, 0, 1, 3, 0, 2, 0, 1, 3};
    public static final int FLAG_BOTTOMUP = 2;
    public static final int FLAG_FORCEMMX = 8;
    public static final int FLAG_FORCESSE = 16;
    public static final int FLAG_FORCESSE2 = 32;
    public static final int FLAG_FORCESSE3 = 128;
    public static final int FLAG_FASTUPSAMPLE = 256;
    public static final int FLAG_FASTDCT = 2048;
    public static final int FLAG_ACCURATEDCT = 4096;

    public static int getMCUWidth(int subsamp) throws Exception {
        if (subsamp < 0 || subsamp >= 5) {
            throw new Exception("Invalid subsampling type");
        }
        return mcuWidth[subsamp];
    }

    public static int getMCUHeight(int subsamp) throws Exception {
        if (subsamp < 0 || subsamp >= 5) {
            throw new Exception("Invalid subsampling type");
        }
        return mcuHeight[subsamp];
    }

    public static int getPixelSize(int pixelFormat) throws Exception {
        if (pixelFormat < 0 || pixelFormat >= 11) {
            throw new Exception("Invalid pixel format");
        }
        return pixelSize[pixelFormat];
    }

    public static int getRedOffset(int pixelFormat) throws Exception {
        if (pixelFormat < 0 || pixelFormat >= 11) {
            throw new Exception("Invalid pixel format");
        }
        return redOffset[pixelFormat];
    }

    public static int getGreenOffset(int pixelFormat) throws Exception {
        if (pixelFormat < 0 || pixelFormat >= 11) {
            throw new Exception("Invalid pixel format");
        }
        return greenOffset[pixelFormat];
    }

    public static int getBlueOffset(int pixelFormat) throws Exception {
        if (pixelFormat < 0 || pixelFormat >= 11) {
            throw new Exception("Invalid pixel format");
        }
        return blueOffset[pixelFormat];
    }

    public static native int bufSize(int var0, int var1, int var2) throws Exception;

    public static native int bufSizeYUV(int var0, int var1, int var2) throws Exception;

    public static native TJScalingFactor[] getScalingFactors() throws Exception;

    static {
        TJLoader.load();
    }
}

