/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import ome.xml.model.Annotation;
import ome.xml.model.Channel;
import ome.xml.model.Image;
import ome.xml.model.OME;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.Pixels;
import ome.xml.model.XMLAnnotation;
import ome.xml.model.enums.EnumerationException;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class XMLAnnotationTest {
    private OME ome;

    @BeforeClass
    public void setUp() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(this.getClass().getResourceAsStream("XMLAnnotationTest.ome"));
        OMEModelImpl model = new OMEModelImpl();
        this.ome = new OME(document.getDocumentElement(), (OMEModel)model);
        model.resolveReferences();
    }

    @Test
    public void testValidXMLAnnotation() throws EnumerationException {
        AssertJUnit.assertNotNull((Object)this.ome);
        AssertJUnit.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        Image image = this.ome.getImage(0);
        Pixels pixels = image.getPixels();
        AssertJUnit.assertNotNull((Object)pixels);
        AssertJUnit.assertEquals((int)3, (int)pixels.sizeOfChannelList());
        Channel channel = pixels.getChannel(0);
        AssertJUnit.assertEquals((int)1, (int)channel.sizeOfLinkedAnnotationList());
        Annotation annotation = channel.getLinkedAnnotation(0);
        AssertJUnit.assertEquals(XMLAnnotation.class, annotation.getClass());
        String annotationValue = ((XMLAnnotation)annotation).getValue();
        annotationValue = annotationValue.replaceAll("\r\n", "\n");
        AssertJUnit.assertEquals((String)"<TestData>\n                    <key>foo</key>\n\t\t\t\t\t<value>bar</value>\n                </TestData>", (String)annotationValue);
    }
}

