/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.dbengine;

import java.sql.SQLException;
import java.util.ArrayList;
import mdbtools.dbengine.Data;
import mdbtools.dbengine.MemoryData;
import mdbtools.dbengine.RewindableData;
import mdbtools.dbengine.Table;
import mdbtools.dbengine.functions.Aggregate;
import mdbtools.dbengine.functions.Function;
import mdbtools.dbengine.sql.Condition;
import mdbtools.dbengine.sql.Equation;
import mdbtools.dbengine.sql.FQColumn;
import mdbtools.dbengine.sql.FunctionDef;
import mdbtools.dbengine.sql.Join;
import mdbtools.dbengine.sql.OrderBy;
import mdbtools.dbengine.sql.Select;
import mdbtools.dbengine.tasks.AggregateQuery;
import mdbtools.dbengine.tasks.FilterData;
import mdbtools.dbengine.tasks.LoadData;
import mdbtools.dbengine.tasks.NonAggregateQuery;
import mdbtools.dbengine.tasks.SimpleSort;
import mdbtools.dbengine.tasks.Task;

public class SelectEngine {
    private Select sql;
    private int[] tableMap;
    private ArrayList tasks;

    public SelectEngine(Select select) {
        this.sql = select;
        this.tasks = new ArrayList();
    }

    public Data execute() throws SQLException {
        Task task = this.fromClause();
        task = this.whereClause(task);
        if (this.isAggregate()) {
            OrderBy[] sortBy;
            int groupByCount = this.sql.getGroupByCount();
            if (groupByCount != 0) {
                sortBy = new OrderBy[groupByCount];
                for (int i = 0; i < groupByCount; ++i) {
                    sortBy[i] = new OrderBy();
                    sortBy[i].setSort((FQColumn)this.sql.getGroupBy(i));
                    sortBy[i].setAscending(true);
                }
                task = new SimpleSort(task, sortBy, this.tableMap);
                this.tasks.add(task);
            }
            task = new AggregateQuery(task, this.sql, this.tableMap);
            this.tasks.add(task);
            int orderByCount = this.sql.getOrderByCount();
            if (orderByCount != 0) {
                sortBy = new OrderBy[orderByCount];
                for (int i = 0; i < orderByCount; ++i) {
                    OrderBy ob = this.sql.getOrderBy(i);
                    if (!(ob.getSort() instanceof Integer)) {
                        throw new SQLException("group by's can only sort on an index");
                    }
                    sortBy[i] = new OrderBy();
                    sortBy[i] = ob;
                }
                task = new SimpleSort(task, sortBy, this.tableMap);
                this.tasks.add(task);
            }
        } else {
            int num = this.sql.getOrderByCount();
            if (num == 0) {
                task = new NonAggregateQuery(task, this.sql, this.tableMap);
                this.tasks.add(task);
            } else {
                OrderBy o;
                int i;
                int numFQs = 0;
                int numColumns = 0;
                for (int i2 = 0; i2 < num; ++i2) {
                    Object o2 = this.sql.getOrderBy(i2).getSort();
                    if (o2 instanceof FQColumn) {
                        ++numFQs;
                        continue;
                    }
                    if (o2 instanceof Integer) {
                        ++numColumns;
                        continue;
                    }
                    throw new SQLException("can't sort this");
                }
                int index = 0;
                OrderBy[] fqs = new OrderBy[numFQs];
                for (i = 0; i < num; ++i) {
                    o = this.sql.getOrderBy(i);
                    if (!(o.getSort() instanceof FQColumn)) continue;
                    fqs[index++] = o;
                }
                index = 0;
                OrderBy[] columns = new OrderBy[numColumns];
                for (i = 0; i < num; ++i) {
                    o = this.sql.getOrderBy(i);
                    if (!(o.getSort() instanceof Integer)) continue;
                    columns[index++] = o;
                }
                if (numFQs != 0) {
                    task = new SimpleSort(task, fqs, this.tableMap);
                    this.tasks.add(task);
                }
                task = new NonAggregateQuery(task, this.sql, this.tableMap);
                this.tasks.add(task);
                if (numColumns != 0) {
                    task = new SimpleSort(task, columns, this.tableMap);
                    this.tasks.add(task);
                }
            }
        }
        for (int i = 0; i < this.tasks.size(); ++i) {
            ((Task)this.tasks.get(i)).run();
        }
        return (Data)task.getResult();
    }

    private Task fromClause() {
        this.tableMap = new int[1];
        this.tableMap[0] = 0;
        LoadData current = null;
        int numTables = this.sql.getTableCount();
        for (int i = 0; i < numTables; ++i) {
            Table table = (Table)this.sql.getTable(i);
            LoadData ld = new LoadData(table);
            this.tasks.add(ld);
            if (current != null) {
                throw new RuntimeException("implement me");
            }
            current = ld;
        }
        return current;
    }

    private Task whereClause(Task task) {
        Task current;
        Object where = this.sql.getWhere();
        if (where != null) {
            Data data = (Data)task.getResult();
            FilterData fd = new FilterData(task, where, this.tableMap);
            this.tasks.add(fd);
            current = fd;
        } else {
            current = task;
        }
        return current;
    }

    private boolean isAggregate() {
        int numColumns = this.sql.getColumnCount();
        for (int i = 0; i < numColumns; ++i) {
            Object o = this.sql.getColumn(i);
            if (!(o instanceof FunctionDef) || !(((FunctionDef)o).getFunction() instanceof Aggregate)) continue;
            return true;
        }
        return false;
    }

    private Data aggregateQuery(Data data) throws SQLException {
        MemoryData result = new MemoryData();
        int numColumns = this.sql.getColumnCount();
        Object dummy = new Object();
        int groupByCount = this.sql.getGroupByCount();
        while (data.next()) {
            if (groupByCount != 0) {
                // empty if block
            }
            for (int i = 0; i < numColumns; ++i) {
                this.resolveColumn(data, this.sql.getColumn(i));
            }
        }
        Object[] row = new Object[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            row[i] = ((Aggregate)((FunctionDef)this.sql.getColumn(i)).getFunction()).getResult();
        }
        result.addRow(row);
        return result;
    }

    private Data getData() throws SQLException {
        Data result;
        if (this.sql.getTableCount() == 0) {
            throw new RuntimeException("must specify a table to select from");
        }
        if (this.sql.getTableCount() == 1 && this.sql.getTable(0) instanceof Table) {
            Table table = (Table)this.sql.getTable(0);
            this.tableMap = new int[1];
            this.tableMap[0] = 0;
            result = new MemoryData(table.getData(), table.getColumnCount());
        } else {
            int numTables = 0;
            for (int i = 0; i < this.sql.getTableCount(); ++i) {
                Object table = this.sql.getTable(i);
                if (table instanceof Table) {
                    ++numTables;
                    continue;
                }
                if (table instanceof Join) {
                    Join join = (Join)table;
                    ++numTables;
                    Object j = join;
                    while (j instanceof Join) {
                        j = ((Join)j).getRight();
                        ++numTables;
                    }
                    continue;
                }
                throw new RuntimeException("unknown table type");
            }
            Table[] tables = new Table[numTables];
            int tableIndex = 0;
            for (int i = 0; i < this.sql.getTableCount(); ++i) {
                Object table = this.sql.getTable(i);
                if (table instanceof Table) {
                    tables[tableIndex++] = (Table)table;
                    continue;
                }
                if (table instanceof Join) {
                    Join join = (Join)table;
                    tables[tableIndex++] = (Table)join.getLeft();
                    Object j = join;
                    while (j instanceof Join) {
                        if (!((j = ((Join)j).getRight()) instanceof Table)) continue;
                        tables[tableIndex++] = (Table)j;
                    }
                    continue;
                }
                throw new RuntimeException("unknown table type");
            }
            this.tableMap = new int[numTables];
            int numColumns = 0;
            for (int i = 0; i < numTables; ++i) {
                this.tableMap[i] = numColumns;
                numColumns += tables[i].getColumnCount();
            }
            Data[] datas = new Data[this.sql.getTableCount()];
            int[] mdColumnCount = new int[datas.length];
            for (int i = 0; i < datas.length; ++i) {
                Object table = this.sql.getTable(i);
                if (table instanceof Table) {
                    Table t2 = (Table)table;
                    mdColumnCount[i] = t2.getColumnCount();
                    datas[i] = t2.getData();
                    continue;
                }
                if (table instanceof Join) {
                    Join join = (Join)table;
                    if (join.getLeft() instanceof Table && join.getRight() instanceof Table) {
                        Table leftTable = (Table)join.getLeft();
                        Table rightTable = join.getRight();
                        int[] rwdcc = new int[]{leftTable.getColumnCount(), rightTable.getColumnCount()};
                        RewindableData[] rwd = new RewindableData[]{new RewindableData(leftTable.getData(), rwdcc[0]), new RewindableData(rightTable.getData(), rwdcc[1])};
                        rwd[0].dump();
                        rwd[1].dump();
                        result = new MemoryData();
                        int cc = rwdcc[0] + rwdcc[1];
                        this.mergeData((MemoryData)result, new Object[cc], 0, rwd, rwdcc, 0);
                        ((MemoryData)result).dump();
                        Equation eq = join.getEquation();
                        int leftTableIndex = this.findTableIndex(leftTable, tables);
                        int rightTableIndex = this.findTableIndex(rightTable, tables);
                        int[] tempTableMap = this.tableMap;
                        this.tableMap = new int[tempTableMap.length];
                        this.tableMap[leftTableIndex] = 0;
                        this.tableMap[rightTableIndex] = rwdcc[0];
                        result = this.where((MemoryData)result, eq);
                        ((MemoryData)result).dump();
                        this.tableMap = tempTableMap;
                        datas[i] = result;
                        mdColumnCount[i] = cc;
                        continue;
                    }
                    throw new RuntimeException("not done");
                }
                throw new RuntimeException("unknown table type");
            }
            if (datas.length == 1) {
                result = datas[0];
            } else {
                result = new MemoryData();
                RewindableData[] rd = new RewindableData[datas.length];
                for (int i = 0; i < datas.length; ++i) {
                    rd[i] = new RewindableData(datas[i], mdColumnCount[i]);
                }
                this.mergeData((MemoryData)result, new Object[numColumns], 0, rd, mdColumnCount, 0);
            }
            ((MemoryData)result).dump();
        }
        return result;
    }

    private int findTableIndex(Table t2, Table[] tables) {
        for (int i = 0; i < tables.length; ++i) {
            if (t2 != tables[i]) continue;
            return i;
        }
        throw new RuntimeException("table not found");
    }

    private void mergeData(MemoryData memData, Object[] _row, int columnIndex, RewindableData[] datas, int[] datasColumnCount, int dataIndex) throws SQLException {
        RewindableData data = datas[dataIndex];
        data.rewind();
        int dataColumnCount = datasColumnCount[dataIndex];
        Object[] row = _row;
        while (data.next()) {
            if (dataIndex + 1 == datas.length) {
                row = new Object[row.length];
                System.arraycopy(_row, 0, row, 0, columnIndex + 1);
            }
            for (int i = 0; i < dataColumnCount; ++i) {
                row[columnIndex + i] = data.get(i);
            }
            if (dataIndex + 1 < datas.length) {
                this.mergeData(memData, row, columnIndex + dataColumnCount, datas, datasColumnCount, dataIndex + 1);
                continue;
            }
            memData.addRow(row);
        }
    }

    private Data nonAggregateQuery(Data data) throws SQLException {
        MemoryData result = new MemoryData();
        int numColumns = this.sql.getColumnCount();
        while (data.next()) {
            Object[] row = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                row[i] = this.resolveColumn(data, this.sql.getColumn(i));
            }
            result.addRow(row);
        }
        return result;
    }

    private Object resolveColumn(Data data, Object column) throws SQLException {
        if (column instanceof FQColumn) {
            FQColumn c = (FQColumn)column;
            return data.get(this.tableMap[c.getTable()] + c.getColumn());
        }
        if (column instanceof FunctionDef) {
            FunctionDef fdef = (FunctionDef)column;
            Function f = (Function)fdef.getFunction();
            Object argument = fdef.getArgument();
            return f.execute(this.resolveColumn(data, argument));
        }
        return column;
    }

    private Data orderBy(Data data) {
        int orderByCount = this.sql.getOrderByCount();
        if (orderByCount == 0) {
            return data;
        }
        return data;
    }

    private Data where(MemoryData data, Object where) throws SQLException {
        if (where == null) {
            return data;
        }
        MemoryData result = new MemoryData();
        int i = 0;
        while (data.next()) {
            if (this.whereCheckRow(data, where)) {
                result.addRow(data.getRow(i));
            }
            ++i;
        }
        return result;
    }

    private boolean whereCheckRow(Data data, Object where) throws SQLException {
        if (where instanceof Equation) {
            return this.whereCheckRowEquation(data, (Equation)where);
        }
        if (where instanceof Condition) {
            return this.whereCheckRowConditon(data, (Condition)where);
        }
        throw new RuntimeException("uknown where type: " + where.getClass().getName());
    }

    private boolean whereCheckRowEquation(Data data, Equation eq) throws SQLException {
        Object left = this.resolveColumn(data, eq.getLeft());
        Object right = this.resolveColumn(data, eq.getRight());
        switch (eq.getOperator()) {
            case 0: {
                return left.equals(right);
            }
            case 3: {
                return !left.equals(right);
            }
        }
        throw new RuntimeException("unknown equation operator: " + eq.getOperator());
    }

    private boolean whereCheckRowConditon(Data data, Condition condition) throws SQLException {
        Object left = condition.getLeft();
        Object right = condition.getRight();
        switch (condition.getOperator()) {
            case 0: {
                return this.whereCheckRow(data, left) && this.whereCheckRow(data, right);
            }
            case 1: {
                return this.whereCheckRow(data, left) || this.whereCheckRow(data, right);
            }
        }
        throw new RuntimeException("unknown condition operator: " + condition.getOperator());
    }
}

