/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.analysis.CharStream;
import org.apache.solr.analysis.BaseCharFilterFactory;
import org.apache.solr.analysis.PatternReplaceCharFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternReplaceCharFilterFactory
extends BaseCharFilterFactory {
    private Pattern p;
    private String replacement;
    private int maxBlockChars;
    private String blockDelimiters;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        try {
            this.p = Pattern.compile(args.get("pattern"));
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException("Configuration Error: 'pattern' can not be parsed in " + this.getClass().getName(), e);
        }
        this.replacement = args.get("replacement");
        if (this.replacement == null) {
            this.replacement = "";
        }
        this.maxBlockChars = this.getInt("maxBlockChars", 10000);
        this.blockDelimiters = args.get("blockDelimiters");
    }

    @Override
    public CharStream create(CharStream input) {
        return new PatternReplaceCharFilter(this.p, this.replacement, this.maxBlockChars, this.blockDelimiters, input);
    }
}

