/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import ome.model.enums.AdminPrivilege;
import ome.model.internal.Details;
import ome.security.basic.AbstractSecurityFilter;
import ome.system.EventContext;
import ome.system.Roles;
import org.hibernate.Filter;
import org.hibernate.Session;

@Deprecated
public class LightAdminPrivilegesSecurityFilter
extends AbstractSecurityFilter {
    private static final ImmutableMap<String, String> PARAMETER_TYPES = ImmutableMap.of((Object)"real_owner", (Object)"long", (Object)"privileges", (Object)"string");

    public LightAdminPrivilegesSecurityFilter(Roles roles) {
        super(roles);
    }

    @Override
    public Map<String, String> getParameterTypes() {
        return PARAMETER_TYPES;
    }

    @Override
    public String getDefaultCondition() {
        return null;
    }

    @Override
    public boolean passesFilter(Session session, Details details, EventContext ec) {
        return false;
    }

    @Override
    public void enable(Session session, EventContext ec) {
        ArrayList<String> privilegeValues = new ArrayList<String>();
        for (AdminPrivilege adminPrivilege : ec.getCurrentAdminPrivileges()) {
            privilegeValues.add(adminPrivilege.getValue());
        }
        Long realOwner = ec.getCurrentSudoerId();
        if (realOwner == null) {
            realOwner = ec.getCurrentUserId();
        }
        int isAdmin01 = ec.isCurrentUserAdmin() ? 1 : 0;
        Filter filter = session.enableFilter(this.getName());
        filter.setParameter("real_owner", (Object)realOwner);
        if (privilegeValues.isEmpty()) {
            filter.setParameterList("privileges", Collections.singletonList("none"));
        } else {
            filter.setParameterList("privileges", privilegeValues);
        }
        this.enableBaseFilters(session, isAdmin01, ec.getCurrentUserId());
    }
}

