/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import ome.api.StatefulServiceInterface;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.services.messages.RegisterServiceCleanupMessage;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import ome.tools.hibernate.EmptySessionHolder;
import ome.tools.hibernate.SessionStatus;
import ome.util.messages.InternalMessage;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SessionHandler
implements MethodInterceptor,
ApplicationContextAware {
    private final Method close;
    private static final Logger log = LoggerFactory.getLogger(SessionHandler.class);
    private final Map<Object, SessionStatus> __sessions = Collections.synchronizedMap(new WeakHashMap());
    private OmeroContext ctx;
    private final SessionFactory factory;
    private static final SessionHolder DUMMY = new EmptySessionHolder();
    private static final String CTOR_MSG = "Both arguments to the SessionHandler constructor should be not null.";

    public SessionHandler(SessionFactory factory) {
        if (factory == null) {
            throw new ApiUsageException(CTOR_MSG);
        }
        this.factory = factory;
        try {
            this.close = StatefulServiceInterface.class.getMethod("close", new Class[0]);
        }
        catch (Exception e) {
            throw new InternalException("Can't get StatefulServiceInterface.close method.");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = (OmeroContext)applicationContext;
    }

    protected Object getThis(MethodInvocation invocation) {
        Object obj = invocation.getThis();
        if (obj instanceof Executor.StatefulWork) {
            obj = ((Executor.StatefulWork)obj).getThis();
        }
        return obj;
    }

    protected void putStatus(MethodInvocation invocation, SessionStatus status) {
        this.__sessions.put(this.getThis(invocation), status);
    }

    private SessionStatus getStatus(MethodInvocation invocation) {
        return this.__sessions.get(this.getThis(invocation));
    }

    protected SessionStatus removeStatus(MethodInvocation invocation) {
        return this.__sessions.remove(this.getThis(invocation));
    }

    public void cleanThread() {
        if (TransactionSynchronizationManager.hasResource((Object)this.factory)) {
            SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.factory);
            if (holder == null) {
                throw new IllegalStateException("Can't be null.");
            }
            if (holder == DUMMY) {
                TransactionSynchronizationManager.unbindResource((Object)this.factory);
            } else {
                throw new IllegalStateException("Thread corrupted.");
            }
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object obj = this.getThis(invocation);
        if (!StatefulServiceInterface.class.isAssignableFrom(obj.getClass())) {
            throw new InternalException("Stateless service configured as stateful.");
        }
        this.debug("Performing action in stateful session.");
        return this.doStateful(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doStateful(MethodInvocation invocation) throws Throwable {
        Object object;
        Object result = null;
        SessionStatus status = null;
        try {
            status = this.newOrRestoredSession(invocation);
            status.session.setFlushMode(FlushMode.COMMIT);
            object = result = invocation.proceed();
        }
        catch (Throwable throwable) {
            try {
                if (this.isCloseSession(invocation)) {
                    this.ctx.publishMessage((InternalMessage)new RegisterServiceCleanupMessage(this, invocation.getThis(), invocation){
                        final /* synthetic */ MethodInvocation val$invocation;
                        {
                            this.val$invocation = methodInvocation;
                            super(source, resource);
                        }

                        @Override
                        public void close() {
                            SessionStatus status = SessionHandler.this.removeStatus(this.val$invocation);
                            status.session.disconnect();
                            status.session.close();
                        }
                    });
                } else if (status != null) {
                    status.session.setFlushMode(FlushMode.MANUAL);
                    status.session.disconnect();
                    --status.calls;
                }
            }
            catch (Exception e) {
                log.error("Error while closing/disconnecting session.", (Throwable)e);
            }
            finally {
                try {
                    this.resetThreadSession();
                }
                catch (Exception e) {
                    log.error("Could not cleanup thread session.", (Throwable)e);
                    throw e;
                }
            }
            throw throwable;
        }
        try {
            if (this.isCloseSession(invocation)) {
                this.ctx.publishMessage((InternalMessage)new /* invalid duplicate definition of identical inner class */);
            } else if (status != null) {
                status.session.setFlushMode(FlushMode.MANUAL);
                status.session.disconnect();
                --status.calls;
            }
        }
        catch (Exception e) {
            log.error("Error while closing/disconnecting session.", (Throwable)e);
        }
        finally {
            try {
                this.resetThreadSession();
            }
            catch (Exception e) {
                log.error("Could not cleanup thread session.", (Throwable)e);
                throw e;
            }
        }
        return object;
    }

    private SessionStatus newOrRestoredSession(MethodInvocation invocation) throws HibernateException {
        SessionStatus status = this.getStatus(invocation);
        org.hibernate.Session previousSession = this.nullOrSessionBoundToThread();
        if (previousSession != null) {
            String msg = "Dirty Hibernate Session " + previousSession + " found in Thread " + Thread.currentThread();
            if (!this.isCloseSession(invocation)) {
                previousSession.close();
            }
            throw new InternalException(msg);
        }
        if (status == null || !status.session.isOpen()) {
            org.hibernate.Session currentSession = this.acquireAndBindSession();
            status = new SessionStatus(currentSession);
            this.putStatus(invocation, status);
        } else {
            if (status.calls > 1) {
                throw new InternalException("Hibernate session is not re-entrant.\nEither you have two threads operating on the same stateful object (don't do this)\n or you have a recursive call (recurse on the unwrapped object). ");
            }
            this.debug("Binding and reconnecting session.");
            this.bindSession(status.session);
        }
        ++status.calls;
        return status;
    }

    private boolean isCloseSession(MethodInvocation invocation) {
        return this.close.getName().equals(invocation.getMethod().getName());
    }

    private org.hibernate.Session acquireAndBindSession() throws HibernateException {
        this.debug("Opening and binding session.");
        Session session = this.factory.openSession();
        this.bindSession((org.hibernate.Session)session);
        return session;
    }

    private void bindSession(org.hibernate.Session session) {
        this.debug("Binding session to thread.");
        SessionHolder sessionHolder = new SessionHolder(session);
        sessionHolder.setTransaction(sessionHolder.getSession().beginTransaction());
        if (TransactionSynchronizationManager.hasResource((Object)this.factory)) {
            TransactionSynchronizationManager.unbindResource((Object)this.factory);
        }
        TransactionSynchronizationManager.bindResource((Object)this.factory, (Object)sessionHolder);
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new InternalException("Synchronization not active for TransactionSynchronizationManager");
        }
    }

    private org.hibernate.Session nullOrSessionBoundToThread() {
        SessionHolder holder = null;
        if (TransactionSynchronizationManager.hasResource((Object)this.factory) && (holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.factory)) != null && holder.isEmpty()) {
            holder = null;
        }
        return holder == null ? null : holder.getSession();
    }

    private boolean isSessionBoundToThread() {
        return this.nullOrSessionBoundToThread() != null;
    }

    private void resetThreadSession() {
        if (this.isSessionBoundToThread()) {
            this.debug("Session bound to thread. Resetting.");
            TransactionSynchronizationManager.unbindResource((Object)this.factory);
            TransactionSynchronizationManager.bindResource((Object)this.factory, (Object)DUMMY);
        } else {
            this.debug("Session not bound to thread. No need to reset.");
        }
    }

    private void debug(String message) {
        if (log.isDebugEnabled()) {
            log.debug(message);
        }
    }
}

