/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.LruStatementCache;
import bitronix.tm.resource.jdbc.proxy.JavaProxyBase;
import bitronix.tm.resource.jdbc.proxy.JdbcProxyFactory;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Map;

public class PreparedStatementJavaProxy
extends JavaProxyBase<PreparedStatement> {
    private static final Map<String, Method> selfMethodMap = PreparedStatementJavaProxy.createMethodMap(PreparedStatementJavaProxy.class);
    private JdbcPooledConnection jdbcPooledConnection;
    private LruStatementCache.CacheKey cacheKey;
    private boolean pretendClosed;

    public PreparedStatementJavaProxy(JdbcPooledConnection jdbcPooledConnection, PreparedStatement statement, LruStatementCache.CacheKey cacheKey) {
        this.initialize(jdbcPooledConnection, statement, cacheKey);
    }

    public PreparedStatementJavaProxy() {
    }

    void initialize(JdbcPooledConnection jdbcPooledConnection, PreparedStatement statement, LruStatementCache.CacheKey cacheKey) {
        this.proxy = this;
        this.jdbcPooledConnection = jdbcPooledConnection;
        this.delegate = statement;
        this.cacheKey = cacheKey;
        this.pretendClosed = false;
    }

    public String toString() {
        return "a PreparedStatementJavaProxy wrapping [" + this.delegate + "]";
    }

    public void close() throws SQLException {
        if (this.pretendClosed || this.delegate == null) {
            return;
        }
        this.pretendClosed = true;
        if (this.cacheKey == null) {
            this.jdbcPooledConnection.unregisterUncachedStatement((Statement)this.delegate);
            ((PreparedStatement)this.delegate).close();
        } else {
            ((PreparedStatement)this.delegate).clearParameters();
            ((PreparedStatement)this.delegate).clearWarnings();
            try {
                ((PreparedStatement)this.delegate).clearBatch();
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                // empty catch block
            }
            this.jdbcPooledConnection.putCachedStatement(this.cacheKey, (PreparedStatement)this.delegate);
        }
    }

    public boolean isClosed() throws SQLException {
        return this.pretendClosed;
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet = ((PreparedStatement)this.delegate).getResultSet();
        if (resultSet == null) {
            return null;
        }
        return JdbcProxyFactory.INSTANCE.getProxyResultSet((Statement)this.getProxy(), resultSet);
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = ((PreparedStatement)this.delegate).executeQuery();
        if (resultSet == null) {
            return null;
        }
        return JdbcProxyFactory.INSTANCE.getProxyResultSet((Statement)this.getProxy(), resultSet);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet resultSet = ((PreparedStatement)this.delegate).executeQuery(sql);
        if (resultSet == null) {
            return null;
        }
        return JdbcProxyFactory.INSTANCE.getProxyResultSet((Statement)this.getProxy(), resultSet);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet generatedKeys = ((PreparedStatement)this.delegate).getGeneratedKeys();
        if (generatedKeys == null) {
            return null;
        }
        return JdbcProxyFactory.INSTANCE.getProxyResultSet((Statement)this.getProxy(), generatedKeys);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(((PreparedStatement)this.delegate).getClass()) || PreparedStatementJavaProxy.isWrapperFor(this.delegate, iface);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(((PreparedStatement)this.delegate).getClass())) {
            return (T)this.delegate;
        }
        if (this.isWrapperFor(iface)) {
            return PreparedStatementJavaProxy.unwrap(this.delegate, iface);
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for " + iface);
    }

    @Override
    protected Map<String, Method> getMethodMap() {
        return selfMethodMap;
    }
}

