/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.impl.jgroups.JGroupsBackendQueueProcessorFactory;
import org.hibernate.search.util.LoggerFactory;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Message;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsBackendQueueProcessor
implements Runnable {
    private static final Logger log = LoggerFactory.make();
    private final JGroupsBackendQueueProcessorFactory factory;
    private final List<LuceneWork> queue;

    public JGroupsBackendQueueProcessor(List<LuceneWork> queue, JGroupsBackendQueueProcessorFactory factory) {
        this.factory = factory;
        this.queue = queue;
    }

    @Override
    public void run() {
        boolean trace = log.isTraceEnabled();
        ArrayList<LuceneWork> filteredQueue = new ArrayList<LuceneWork>(this.queue);
        if (trace) {
            log.trace("Preparing {} Lucene works to be sent to master node.", (Object)filteredQueue.size());
        }
        for (LuceneWork work : this.queue) {
            if (!(work instanceof OptimizeLuceneWork)) continue;
            filteredQueue.remove(work);
        }
        if (trace) {
            log.trace("Filtering: optimized Lucene works are not going to be sent to master node. There is {} Lucene works after filtering.", (Object)filteredQueue.size());
        }
        if (filteredQueue.isEmpty()) {
            if (trace) {
                log.trace("Nothing to send. Propagating works to a cluster has been skipped.");
            }
            return;
        }
        try {
            Message message = new Message(null, this.factory.getAddress(), (Serializable)filteredQueue);
            this.factory.getChannel().send(message);
            if (trace) {
                log.trace("Lucene works have been sent from slave {} to master node.", (Object)this.factory.getAddress());
            }
        }
        catch (ChannelNotConnectedException e) {
            throw new SearchException("Unable to send Lucene work. Channel is not connected to: " + this.factory.getClusterName());
        }
        catch (ChannelClosedException e) {
            throw new SearchException("Unable to send Lucene work. Attempt to send message on closed JGroups channel");
        }
    }
}

