/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.RefCounted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreAdminHandler
extends RequestHandlerBase {
    protected final CoreContainer coreContainer;

    public CoreAdminHandler() {
        this.coreContainer = null;
    }

    public CoreAdminHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler should not be configured in solrconf.xml\nit is a special Handler configured directly by the RequestDispatcher");
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        boolean doPersist = false;
        SolrParams params = req.getParams();
        CoreAdminParams.CoreAdminAction action = CoreAdminParams.CoreAdminAction.STATUS;
        String a = params.get("action");
        if (a != null && (action = CoreAdminParams.CoreAdminAction.get((String)a)) == null) {
            doPersist = this.handleCustomAction(req, rsp);
        }
        if (action != null) {
            switch (action) {
                case CREATE: {
                    doPersist = this.handleCreateAction(req, rsp);
                    break;
                }
                case RENAME: {
                    doPersist = this.handleRenameAction(req, rsp);
                    break;
                }
                case ALIAS: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'ALIAS' is not supported " + req.getParams().get("action"));
                }
                case UNLOAD: {
                    doPersist = this.handleUnloadAction(req, rsp);
                    break;
                }
                case STATUS: {
                    doPersist = this.handleStatusAction(req, rsp);
                    break;
                }
                case PERSIST: {
                    doPersist = this.handlePersistAction(req, rsp);
                    break;
                }
                case RELOAD: {
                    doPersist = this.handleReloadAction(req, rsp);
                    break;
                }
                case SWAP: {
                    doPersist = this.handleSwapAction(req, rsp);
                    break;
                }
                case MERGEINDEXES: {
                    doPersist = this.handleMergeAction(req, rsp);
                    break;
                }
                default: {
                    doPersist = this.handleCustomAction(req, rsp);
                }
                case LOAD: 
            }
        }
        if (doPersist) {
            cores.persist();
            rsp.add("saved", cores.getConfigFile().getAbsolutePath());
        }
        rsp.setHttpCaching(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleMergeAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        boolean doPersist = false;
        SolrParams params = req.getParams();
        RequiredSolrParams required = params.required();
        String cname = required.get("core");
        SolrCore core = this.coreContainer.getCore(cname);
        if (core != null) {
            try {
                doPersist = this.coreContainer.isPersistent();
                String[] dirNames = required.getParams("indexDir");
                DirectoryFactory dirFactory = core.getDirectoryFactory();
                Directory[] dirs = new Directory[dirNames.length];
                for (int i = 0; i < dirNames.length; ++i) {
                    dirs[i] = dirFactory.open(dirNames[i]);
                }
                UpdateRequestProcessorChain processorChain = core.getUpdateProcessingChain(params.get("update.processor"));
                LocalSolrQueryRequest wrappedReq = new LocalSolrQueryRequest(core, req.getParams());
                UpdateRequestProcessor processor = processorChain.createProcessor(wrappedReq, rsp);
                processor.processMergeIndexes(new MergeIndexesCommand(dirs));
                Object var15_15 = null;
                core.close();
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                core.close();
                throw throwable;
            }
        }
        return doPersist;
    }

    protected boolean handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported operation: " + req.getParams().get("action"));
    }

    protected boolean handleCreateAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        try {
            SolrParams params = req.getParams();
            String name = params.get("name");
            CoreDescriptor dcore = new CoreDescriptor(this.coreContainer, name, params.get("instanceDir"));
            String opts = params.get("config");
            if (opts != null) {
                dcore.setConfigName(opts);
            }
            if ((opts = params.get("schema")) != null) {
                dcore.setSchemaName(opts);
            }
            if ((opts = params.get("dataDir")) != null) {
                dcore.setDataDir(opts);
            }
            dcore.setCoreProperties(null);
            SolrCore core = this.coreContainer.create(dcore);
            this.coreContainer.register(name, core, false);
            rsp.add("core", core.getName());
            return this.coreContainer.isPersistent();
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error executing default implementation of CREATE", (Throwable)ex);
        }
    }

    protected boolean handleRenameAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String name = params.get("other");
        String cname = params.get("core");
        boolean doPersist = false;
        if (cname.equals(name)) {
            return doPersist;
        }
        SolrCore core = this.coreContainer.getCore(cname);
        if (core != null) {
            doPersist = this.coreContainer.isPersistent();
            this.coreContainer.register(name, core, false);
            this.coreContainer.remove(cname);
            core.close();
        }
        return doPersist;
    }

    @Deprecated
    protected boolean handleAliasAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String name = params.get("other");
        String cname = params.get("core");
        boolean doPersist = false;
        if (cname.equals(name)) {
            return doPersist;
        }
        SolrCore core = this.coreContainer.getCore(cname);
        if (core != null) {
            doPersist = this.coreContainer.isPersistent();
            this.coreContainer.register(name, core, false);
        }
        return doPersist;
    }

    protected boolean handleUnloadAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        SolrCore core = this.coreContainer.remove(cname);
        if (core == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core exists '" + cname + "'");
        }
        core.close();
        return this.coreContainer.isPersistent();
    }

    protected boolean handleStatusAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        boolean doPersist = false;
        SimpleOrderedMap status = new SimpleOrderedMap();
        try {
            if (cname == null) {
                for (String name : this.coreContainer.getCoreNames()) {
                    status.add(name, this.getCoreStatus(this.coreContainer, name));
                }
            } else {
                status.add(cname, this.getCoreStatus(this.coreContainer, cname));
            }
            rsp.add("status", status);
            doPersist = false;
            return doPersist;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'status' action ", (Throwable)ex);
        }
    }

    protected boolean handlePersistAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        boolean doPersist = false;
        String fileName = params.get("file");
        if (fileName != null) {
            File file = new File(this.coreContainer.getConfigFile().getParentFile(), fileName);
            this.coreContainer.persistFile(file);
            rsp.add("saved", file.getAbsolutePath());
            doPersist = false;
        } else {
            if (!this.coreContainer.isPersistent()) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Persistence is not enabled");
            }
            doPersist = true;
        }
        return doPersist;
    }

    protected boolean handleReloadAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        try {
            this.coreContainer.reload(cname);
            return false;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'reload' action", (Throwable)ex);
        }
    }

    protected boolean handleSwapAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        RequiredSolrParams required = params.required();
        String cname = params.get("core");
        boolean doPersist = params.getBool("persistent", this.coreContainer.isPersistent());
        String other = required.get("other");
        this.coreContainer.swap(cname, other);
        return doPersist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedList<Object> getCoreStatus(CoreContainer cores, String cname) throws IOException {
        SimpleOrderedMap info = new SimpleOrderedMap();
        SolrCore core = cores.getCore(cname);
        if (core != null) {
            try {
                info.add("name", (Object)core.getName());
                info.add("instanceDir", (Object)CoreAdminHandler.normalizePath(core.getResourceLoader().getInstanceDir()));
                info.add("dataDir", (Object)CoreAdminHandler.normalizePath(core.getDataDir()));
                info.add("startTime", (Object)new Date(core.getStartTime()));
                info.add("uptime", (Object)(System.currentTimeMillis() - core.getStartTime()));
                RefCounted<SolrIndexSearcher> searcher = core.getSearcher();
                try {
                    info.add("index", LukeRequestHandler.getIndexInfo((IndexReader)searcher.get().getReader(), false));
                    Object var7_6 = null;
                    searcher.decref();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    searcher.decref();
                    throw throwable;
                }
                Object var9_9 = null;
                core.close();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                core.close();
                throw throwable;
            }
        }
        return info;
    }

    protected static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        return path;
    }

    @Override
    public String getDescription() {
        return "Manage Multiple Solr Cores";
    }

    @Override
    public String getVersion() {
        return "$Revision: 1052938 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: CoreAdminHandler.java 1052938 2010-12-26 20:21:48Z rmuir $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_1/solr/src/java/org/apache/solr/handler/admin/CoreAdminHandler.java $";
    }
}

