/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geometry;

import org.apache.lucene.spatial.geometry.FloatLatLng;
import org.apache.lucene.spatial.geometry.LatLng;

public class FixedLatLng
extends LatLng {
    public static final double SCALE_FACTOR = 1000000.0;
    public static final int SCALE_FACTOR_INT = 1000000;
    private int lat;
    private int lng;
    private boolean normalized;

    public FixedLatLng(int lat, int lng) {
        this.setLat(lat);
        this.setLng(lng);
    }

    public FixedLatLng(LatLng ll) {
        this.lat = ll.getFixedLat();
        this.lng = ll.getFixedLng();
    }

    protected void setLat(int lat) {
        if ((double)lat > 9.0E7 || (double)lat < -9.0E7) {
            throw new IllegalArgumentException("Illegal lattitude");
        }
        this.lat = lat;
    }

    protected void setLng(int lng) {
        this.lng = lng;
    }

    public static double fixedToDouble(int fixed) {
        return (double)fixed / 1000000.0;
    }

    public static int doubleToFixed(double d) {
        return (int)(d * 1000000.0);
    }

    public LatLng copy() {
        return new FixedLatLng(this);
    }

    public int getFixedLat() {
        return this.lat;
    }

    public int getFixedLng() {
        return this.lng;
    }

    public double getLat() {
        return FixedLatLng.fixedToDouble(this.lat);
    }

    public double getLng() {
        return FixedLatLng.fixedToDouble(this.lng);
    }

    public boolean isFixedPoint() {
        return true;
    }

    public FixedLatLng toFixed() {
        return this;
    }

    public FloatLatLng toFloat() {
        return new FloatLatLng(this);
    }

    public boolean isNormalized() {
        return this.normalized || this.lng >= -180000000 && this.lng <= 180000000;
    }

    public LatLng normalize() {
        int newLng;
        if (this.isNormalized()) {
            return this;
        }
        int delta = 0;
        if (this.lng < 0) {
            delta = 360000000;
        }
        if (this.lng >= 0) {
            delta = -360000000;
        }
        for (newLng = this.lng; newLng <= -180000000 || newLng >= 180000000; newLng += delta) {
        }
        FixedLatLng ret = new FixedLatLng(this.lat, newLng);
        ret.normalized = true;
        return ret;
    }

    public LatLng calculateMidpoint(LatLng other) {
        return new FixedLatLng((this.lat + other.getFixedLat()) / 2, (this.lng + other.getFixedLng()) / 2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.lat;
        result = 31 * result + this.lng;
        result = 31 * result + (this.normalized ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedLatLng other = (FixedLatLng)obj;
        if (this.lat != other.lat) {
            return false;
        }
        if (this.lng != other.lng) {
            return false;
        }
        return this.normalized == other.normalized;
    }
}

