/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassNotFoundExceptionParser {
    private static final Pattern BCEL_MISSING_CLASS_PATTERN = Pattern.compile("^.*while looking for class ([^:]*):.*$");
    private static final Pattern TYPE_REPOSITORY_MISSING_CLASS_PATTERN = Pattern.compile("^Class ([^ ]*) cannot be resolved.*$");
    private static final Pattern[] patternList;

    public static String getMissingClassName(ClassNotFoundException ex) {
        String resourceName;
        Throwable cause = ex.getCause();
        if (cause instanceof ResourceNotFoundException && (resourceName = ((ResourceNotFoundException)cause).getResourceName()) != null) {
            ClassDescriptor classDesc = ClassDescriptor.fromResourceName(resourceName);
            return classDesc.toDottedClassName();
        }
        Pattern[] arr$ = patternList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Pattern pattern = arr$[i$];
            Matcher matcher = pattern.matcher(ex.getMessage());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    static {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        list.add(BCEL_MISSING_CLASS_PATTERN);
        list.add(TYPE_REPOSITORY_MISSING_CLASS_PATTERN);
        patternList = list.toArray(new Pattern[list.size()]);
    }
}

