/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.NullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessProperty;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.PointerUsageRequiringNonNullValue;
import edu.umd.cs.findbugs.ba.npe.UsagesRequiringNonNullValues;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;

public class DerefFinder {
    public static boolean DEBUG = SystemProperties.getBoolean("deref.finder.debug");

    public static UsagesRequiringNonNullValues getAnalysis(ClassContext classContext, Method method) {
        XMethod thisMethod = XFactory.createXMethod(classContext.getJavaClass(), method);
        if (DEBUG) {
            System.out.println(thisMethod);
        }
        UsagesRequiringNonNullValues derefs = new UsagesRequiringNonNullValues();
        try {
            CFG cfg = classContext.getCFG(method);
            ValueNumberDataflow vna = classContext.getValueNumberDataflow(method);
            TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
            NullnessAnnotationDatabase db = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
            ParameterNullnessPropertyDatabase unconditionalDerefParamDatabase = AnalysisContext.currentAnalysisContext().getUnconditionalDerefParamDatabase();
            Iterator<BasicBlock> bbIter = cfg.blockIterator();
            ConstantPoolGen cpg = classContext.getConstantPoolGen();
            ValueNumber valueNumberForThis = null;
            if (!method.isStatic()) {
                ValueNumberFrame frameAtEntry = (ValueNumberFrame)vna.getStartFact(cfg.getEntry());
                valueNumberForThis = (ValueNumber)frameAtEntry.getValue(0);
            }
            NullnessAnnotation methodAnnotation = DerefFinder.getMethodNullnessAnnotation(classContext, method);
            while (bbIter.hasNext()) {
                BasicBlock basicBlock = bbIter.next();
                if (!basicBlock.isNullCheck()) continue;
                InstructionHandle exceptionThrowerHandle = basicBlock.getExceptionThrower();
                Instruction exceptionThrower = exceptionThrowerHandle.getInstruction();
                ValueNumberFrame vnaFrame = (ValueNumberFrame)vna.getStartFact(basicBlock);
                if (!vnaFrame.isValid()) continue;
                ValueNumber valueNumber = (ValueNumber)vnaFrame.getInstance(exceptionThrower, cpg);
                Location location = new Location(exceptionThrowerHandle, basicBlock);
                if (valueNumberForThis == valueNumber) continue;
                derefs.add(location, valueNumber, PointerUsageRequiringNonNullValue.getPointerDereference());
            }
            Iterator<Location> i = cfg.locationIterator();
            while (i.hasNext()) {
                ValueNumber valueNumber;
                Location location = i.next();
                InstructionHandle handle = location.getHandle();
                Instruction ins = handle.getInstruction();
                ValueNumberFrame valueNumberFrame = (ValueNumberFrame)vna.getFactAtLocation(location);
                TypeFrame typeFrame = typeDataflow.getFactAtLocation(location);
                if (ins instanceof InvokeInstruction) {
                    InvokeInstruction inv = (InvokeInstruction)ins;
                    XMethod m = XFactory.createXMethod(inv, cpg);
                    SignatureParser sigParser = new SignatureParser(m.getSignature());
                    int numParams = sigParser.getNumParameters();
                    for (int j = 0; j < numParams; ++j) {
                        int slot;
                        ValueNumber valueNumber2;
                        if (!db.parameterMustBeNonNull(m, j) || valueNumberForThis == (valueNumber2 = (ValueNumber)valueNumberFrame.getStackValue(slot = sigParser.getSlotsFromTopOfStackForParameter(j)))) continue;
                        derefs.add(location, valueNumber2, PointerUsageRequiringNonNullValue.getPassedAsNonNullParameter(m, j));
                    }
                    try {
                        Set<JavaClassAndMethod> targetMethodSet = Hierarchy.resolveMethodCallTargets(inv, typeFrame, cpg);
                        BitSet unconditionallyDereferencedNullArgSet = null;
                        Iterator<JavaClassAndMethod> i$ = targetMethodSet.iterator();
                        while (i$.hasNext()) {
                            JavaClassAndMethod targetMethod = i$.next();
                            ParameterNullnessProperty property = (ParameterNullnessProperty)unconditionalDerefParamDatabase.getProperty(targetMethod.toXMethod());
                            if (property == null) {
                                unconditionallyDereferencedNullArgSet = null;
                                break;
                            }
                            BitSet foo = property.getAsBitSet();
                            if (unconditionallyDereferencedNullArgSet == null) {
                                unconditionallyDereferencedNullArgSet = foo;
                            } else {
                                unconditionallyDereferencedNullArgSet.intersects(foo);
                            }
                            if (!unconditionallyDereferencedNullArgSet.isEmpty()) continue;
                            break;
                        }
                        if (unconditionallyDereferencedNullArgSet == null || unconditionallyDereferencedNullArgSet.isEmpty() || !valueNumberFrame.isValid()) continue;
                        int j = unconditionallyDereferencedNullArgSet.nextSetBit(0);
                        while (j >= 0) {
                            int slot = sigParser.getSlotsFromTopOfStackForParameter(j);
                            ValueNumber valueNumber3 = (ValueNumber)valueNumberFrame.getStackValue(slot);
                            if (valueNumberForThis != valueNumber3) {
                                derefs.add(location, valueNumber3, PointerUsageRequiringNonNullValue.getPassedAsNonNullParameter(m, j));
                            }
                            j = unconditionallyDereferencedNullArgSet.nextSetBit(j + 1);
                        }
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        AnalysisContext.reportMissingClass(e);
                        continue;
                    }
                }
                if (ins instanceof ARETURN && methodAnnotation == NullnessAnnotation.NONNULL) {
                    ValueNumber valueNumber4 = (ValueNumber)valueNumberFrame.getTopValue();
                    if (valueNumberForThis == valueNumber4) continue;
                    derefs.add(location, valueNumber4, PointerUsageRequiringNonNullValue.getReturnFromNonNullMethod(thisMethod));
                    continue;
                }
                if (!(ins instanceof PUTFIELD) && !(ins instanceof PUTSTATIC)) continue;
                FieldInstruction inf = (FieldInstruction)ins;
                XField field = XFactory.createXField(inf, cpg);
                NullnessAnnotation annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(field, false);
                if (annotation != NullnessAnnotation.NONNULL || valueNumberForThis == (valueNumber = (ValueNumber)valueNumberFrame.getTopValue())) continue;
                derefs.add(location, valueNumber, PointerUsageRequiringNonNullValue.getStoredIntoNonNullField(field));
            }
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError("Error generating derefs for " + thisMethod, e);
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("Error generating derefs for " + thisMethod, e);
        }
        return derefs;
    }

    public static NullnessAnnotation getMethodNullnessAnnotation(ClassContext classContext, Method method) {
        if (method.getSignature().indexOf(")L") >= 0 || method.getSignature().indexOf(")[") >= 0) {
            XMethod m = XFactory.createXMethod(classContext.getJavaClass(), method);
            return AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(m, false);
        }
        return NullnessAnnotation.UNKNOWN_NULLNESS;
    }
}

