/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import ucar.bufr.BufrData;
import ucar.bufr.BufrDataDescriptionSection;
import ucar.bufr.BufrNumbers;
import ucar.bufr.BufrTables;
import ucar.bufr.Descriptor;
import ucar.unidata.io.RandomAccessFile;

final class BufrDataSection {
    private static final double[] bitsmv1 = new double[33];
    private final RandomAccessFile raf;
    private BufrDataDescriptionSection dds;
    private final HashMap bufrdatas = new HashMap();
    private final ArrayList dorder = new ArrayList();
    private long[] offset;
    private int[] oBitPos;
    private int[] oBitBuf;
    private boolean firstPass = true;
    public static HashMap tableA;
    public static HashMap tableB;
    public static HashMap tableD;
    private int bitBuf = 0;
    private int bitPos = 0;
    private int xWidth = 0;
    private int xScale = 0;
    private boolean isCompressed = false;

    public BufrDataSection(RandomAccessFile raf, String MasterTableFilename) throws IOException {
        this.raf = raf;
        if (tableA != null) {
            return;
        }
        BufrTables.readTableA(MasterTableFilename + "-A");
        BufrTables.readTableB(MasterTableFilename + "-B");
        BufrTables.readTableD(MasterTableFilename + "-D");
        tableA = (HashMap)BufrTables.tablesA.get(MasterTableFilename + "-A");
        tableB = (HashMap)BufrTables.tablesB.get(MasterTableFilename + "-B");
        tableD = (HashMap)BufrTables.tablesD.get(MasterTableFilename + "-D");
    }

    public boolean readOneObs(BufrDataDescriptionSection aDDS, int bitPos, int bitBuf) throws IOException {
        this.dds = aDDS;
        this.bitPos = bitPos;
        this.bitBuf = bitBuf;
        if (this.dds.getDataType() == 192 || this.dds.getDataType() == 64) {
            this.isCompressed = true;
            this.compressed();
        } else if (this.dds.getDataType() == 128 || this.dds.getDataType() == 0) {
            this.dds.setNumberDataSets(1);
            this.isCompressed = false;
            this.uncompressed();
        } else {
            System.out.println("Unknown DDS DataType =" + this.dds.getDataType());
            return false;
        }
        return true;
    }

    public boolean read(BufrDataDescriptionSection aDDS) throws IOException {
        this.dds = aDDS;
        int length = BufrNumbers.uint3(this.raf);
        int reserved = this.raf.read();
        if (this.dds.getNumberDataSets() == 0) {
            return false;
        }
        if (this.dds.getDataType() == 192 || this.dds.getDataType() == 64) {
            this.isCompressed = true;
            this.compressed();
        } else if (this.dds.getDataType() == 128 || this.dds.getDataType() == 0) {
            this.isCompressed = false;
            this.uncompressed();
        } else {
            System.out.println("Unknown DDS DataType =" + this.dds.getDataType());
            return false;
        }
        return true;
    }

    private void compressed() throws IOException {
        int i;
        ArrayList dKeys = this.dds.getDescriptors();
        this.offset = new long[1];
        this.oBitPos = new int[1];
        this.oBitBuf = new int[1];
        this.offset[0] = this.raf.getFilePointer();
        this.oBitPos[0] = this.bitPos;
        this.oBitBuf[0] = this.bitBuf;
        for (i = 0; i < dKeys.size(); ++i) {
            String dKey = (String)dKeys.get(i);
            if (dKey.equals("0-32-0")) continue;
            if (dKey.startsWith("0")) {
                Descriptor des = (Descriptor)tableB.get(dKey);
                if (this.firstPass) {
                    this.doFirstPass(des);
                    continue;
                }
                this.setValue(des);
                continue;
            }
            if (dKey.startsWith("3")) {
                this.doSequence(dKey);
                continue;
            }
            if (dKey.startsWith("1")) {
                int rx = Integer.parseInt(dKey.substring(2, dKey.lastIndexOf("-")));
                ArrayList<String> rl = new ArrayList<String>();
                rl.add(dKey);
                dKey = (String)dKeys.get(i + 1);
                if (dKey.startsWith("0-31-")) {
                    ++rx;
                }
                for (int r = 0; r < rx; ++r) {
                    rl.add((String)dKeys.get(++i));
                }
                this.doReplication(rl);
                continue;
            }
            if (dKey.startsWith("2-1-")) {
                this.doChangeWidth(dKey);
                continue;
            }
            if (dKey.startsWith("2-2-")) {
                this.doChangeScale(dKey);
                continue;
            }
            if (dKey.startsWith("2-5-")) {
                int numberChars = Integer.parseInt(dKey.substring(dKey.lastIndexOf("-") + 1));
                String text = this.getString(numberChars).trim();
                System.out.println("compressed Text = " + text);
                continue;
            }
            if (dKey.startsWith("2-22-")) {
                for (int t = 0; t < this.dorder.size(); ++t) {
                    String bKey = (String)this.dorder.get(t);
                    BufrData bd = (BufrData)this.bufrdatas.get(bKey);
                    bd.shrinkData();
                }
                return;
            }
            if (dKey.startsWith("2-")) {
                return;
            }
            System.out.println("compressed " + dKey + "  not implemented yet");
        }
        for (i = 0; i < this.dorder.size(); ++i) {
            String bKey = (String)this.dorder.get(i);
            BufrData bd = (BufrData)this.bufrdatas.get(bKey);
            bd.shrinkData();
        }
    }

    private void getCompressNumeric(Descriptor des) throws IOException {
        int nb;
        BufrData bd = (BufrData)this.bufrdatas.get(des.getKey());
        double refVal = this.bits2UInt(des.getWidth() + this.xWidth);
        if (refVal == bitsmv1[des.getWidth() + this.xWidth]) {
            refVal = -9999.0;
        }
        if ((nb = this.bits2UInt(6)) == 0) {
            double value = refVal != -9999.0 ? (refVal + (double)des.getRefVal()) / Math.pow(10.0, des.getScale() + this.xScale) : refVal;
            for (int j = 0; j < this.dds.getNumberDataSets(); ++j) {
                bd.setValue((float)value);
            }
        } else {
            for (int j = 0; j < this.dds.getNumberDataSets(); ++j) {
                double value = this.bits2UInt(nb);
                value += refVal;
                value = (value + (double)des.getRefVal()) / Math.pow(10.0, des.getScale() + this.xScale);
                bd.setValue((float)value);
            }
        }
    }

    private static int doBitMapped(int idx, ArrayList dKeys) {
        return idx;
    }

    private void uncompressed() throws IOException {
        ArrayList dKeys = this.dds.getDescriptors();
        long reset = this.raf.getFilePointer();
        int tmpBitPos = this.bitPos;
        int tmpBitBuf = this.bitBuf;
        this.offset = new long[this.dds.getNumberDataSets()];
        this.oBitPos = new int[this.dds.getNumberDataSets()];
        this.oBitBuf = new int[this.dds.getNumberDataSets()];
        for (int k = -1; k < this.dds.getNumberDataSets(); ++k) {
            if (k > -1) {
                this.offset[k] = this.raf.getFilePointer();
                this.oBitPos[k] = this.bitPos;
                this.oBitBuf[k] = this.bitBuf;
            }
            for (int i = 0; i < dKeys.size(); ++i) {
                String dKey = (String)dKeys.get(i);
                if (dKey.equals("0-32-0")) continue;
                if (dKey.startsWith("0")) {
                    Descriptor des = (Descriptor)tableB.get(dKey);
                    if (des == null) {
                        System.out.println("dKey not in table " + dKey);
                    }
                    if (this.firstPass) {
                        this.doFirstPass(des);
                        continue;
                    }
                    this.setValue(des);
                    continue;
                }
                if (dKey.startsWith("3")) {
                    int cfr = this.checkForReplication(dKey, dKeys, i);
                    if (cfr == -1) {
                        this.doSequence(dKey);
                        continue;
                    }
                    i = cfr;
                    continue;
                }
                if (dKey.startsWith("1")) {
                    int rx = Integer.parseInt(dKey.substring(2, dKey.lastIndexOf("-")));
                    ArrayList<String> rl = new ArrayList<String>();
                    rl.add(dKey);
                    dKey = (String)dKeys.get(i + 1);
                    if (dKey.startsWith("0-31-")) {
                        ++rx;
                    }
                    for (int r = 0; r < rx; ++r) {
                        rl.add((String)dKeys.get(++i));
                    }
                    this.doReplication(rl);
                    continue;
                }
                if (dKey.startsWith("2-1-")) {
                    this.doChangeWidth(dKey);
                    continue;
                }
                if (dKey.startsWith("2-2-")) {
                    this.doChangeScale(dKey);
                    continue;
                }
                if (dKey.startsWith("2-5-")) {
                    int numberChars = Integer.parseInt(dKey.substring(dKey.lastIndexOf("-") + 1));
                    String text = this.getString(numberChars).trim();
                    System.out.println("uncompressed Text = " + text);
                    continue;
                }
                if (dKey.startsWith("2-6-")) {
                    this.localDes(dKey, (String)dKeys.get(++i));
                    continue;
                }
                System.out.println(dKey + " uncompressed not implemented");
            }
            if (!this.firstPass) continue;
            this.firstPass = false;
            this.raf.seek(reset);
            this.bitBuf = tmpBitBuf;
            this.bitPos = tmpBitPos;
            this.setArrays();
        }
    }

    private int checkForReplication(String dKey, ArrayList dKeys, int idx) throws IOException {
        ArrayList alr = (ArrayList)tableD.get(dKey);
        String drKey = (String)alr.get(0);
        if (drKey.startsWith("1") && drKey.endsWith("0")) {
            int r;
            int rx = Integer.parseInt(drKey.substring(2, drKey.lastIndexOf("-"))) + 1;
            ArrayList<String> rl = new ArrayList<String>();
            rl.add(drKey);
            for (r = 1; r <= rx && r < alr.size(); ++r) {
                rl.add((String)alr.get(r));
            }
            while (r <= rx) {
                rl.add((String)dKeys.get(++idx));
                ++r;
            }
            this.doReplication(rl);
            return idx;
        }
        return -1;
    }

    private void doChangeWidth(String dwKey) {
        this.xWidth = Integer.parseInt(dwKey.substring(dwKey.lastIndexOf("-") + 1));
        if (this.xWidth != 0) {
            this.xWidth -= 128;
        }
    }

    private void doChangeScale(String dsKey) {
        this.xScale = Integer.parseInt(dsKey.substring(dsKey.lastIndexOf("-") + 1));
        if (this.xScale != 0) {
            this.xScale -= 128;
        }
    }

    private void doSequence(String d3Key) throws IOException {
        ArrayList al3 = (ArrayList)tableD.get(d3Key);
        for (int i = 0; i < al3.size(); ++i) {
            String dKey = (String)al3.get(i);
            if (dKey.startsWith("0")) {
                Descriptor des = (Descriptor)tableB.get(dKey);
                if (des == null) {
                    System.out.println("dKey not in table " + dKey);
                }
                if (this.firstPass) {
                    this.doFirstPass(des);
                    continue;
                }
                this.setValue(des);
                continue;
            }
            if (dKey.startsWith("3")) {
                int cfr = this.checkForReplication(dKey, al3, i);
                if (cfr == -1) {
                    this.doSequence(dKey);
                    continue;
                }
                i = cfr;
                continue;
            }
            if (dKey.startsWith("1")) {
                int rx = Integer.parseInt(dKey.substring(2, dKey.lastIndexOf("-")));
                ArrayList<String> rl = new ArrayList<String>();
                rl.add(dKey);
                dKey = (String)al3.get(i + 1);
                if (dKey.startsWith("0-31-")) {
                    ++rx;
                }
                for (int r = 0; r < rx; ++r) {
                    rl.add((String)al3.get(++i));
                }
                this.doReplication(rl);
                continue;
            }
            if (dKey.startsWith("2-1-")) {
                this.doChangeWidth(dKey);
                continue;
            }
            if (dKey.startsWith("2-2-")) {
                this.doChangeScale(dKey);
                continue;
            }
            if (dKey.startsWith("2-5-")) {
                int numberChars = Integer.parseInt(dKey.substring(dKey.lastIndexOf("-") + 1));
                String text = this.getString(numberChars).trim();
                System.out.println(" Text = " + text);
                continue;
            }
            if (dKey.startsWith("2-6-")) {
                this.localDes(dKey, (String)al3.get(++i));
                continue;
            }
            System.out.println(dKey + " doSequence not implemented");
        }
    }

    private void doReplication(ArrayList rl) throws IOException {
        int rx = 0;
        int ry = 0;
        String dKey = (String)rl.get(0);
        if (dKey.endsWith("-0")) {
            dKey = (String)rl.get(1);
            ry = this.getRepetitions(dKey);
        } else {
            ry = Integer.parseInt(dKey.substring(dKey.lastIndexOf("-") + 1));
        }
        for (int k = 0; k < ry; ++k) {
            for (int i = 1; i < rl.size(); ++i) {
                dKey = (String)rl.get(i);
                if (dKey.startsWith("0-31-") && i == 1) continue;
                if (dKey.startsWith("0")) {
                    Descriptor des = (Descriptor)tableB.get(dKey);
                    if (this.firstPass) {
                        this.doFirstPass(des);
                        continue;
                    }
                    this.setValue(des);
                    continue;
                }
                if (dKey.startsWith("3")) {
                    this.doSequence(dKey);
                    continue;
                }
                if (dKey.startsWith("1")) {
                    rx = Integer.parseInt(dKey.substring(2, dKey.lastIndexOf("-")));
                    ArrayList<String> ral = new ArrayList<String>();
                    ral.add(dKey);
                    dKey = (String)rl.get(i + 1);
                    if (dKey.startsWith("0-31-")) {
                        ++rx;
                    }
                    for (int r = 0; r < rx; ++r) {
                        ral.add((String)rl.get(++i));
                    }
                    this.doReplication(ral);
                    continue;
                }
                if (dKey.startsWith("2-1-")) {
                    this.doChangeWidth(dKey);
                    continue;
                }
                if (dKey.startsWith("2-2-")) {
                    this.doChangeScale(dKey);
                    continue;
                }
                if (dKey.startsWith("2-5-")) {
                    int numberChars = Integer.parseInt(dKey.substring(dKey.lastIndexOf("-") + 1));
                    String text = this.getString(numberChars).trim();
                    System.out.println(" Text = " + text);
                    continue;
                }
                if (dKey.startsWith("2-6-")) {
                    this.localDes(dKey, (String)rl.get(++i));
                    continue;
                }
                System.out.println(dKey + " doReplication not implemented");
            }
        }
    }

    private void doFirstPass(Descriptor des) throws IOException {
        BufrData bd;
        if (this.bufrdatas.containsKey(des.getKey())) {
            bd = (BufrData)this.bufrdatas.get(des.getKey());
            bd.incrementVarCount();
        } else {
            bd = new BufrData(des);
            this.bufrdatas.put(bd.getKey(), bd);
            this.dorder.add(bd.getKey());
        }
        if (this.isCompressed) {
            bd.setAllocation(this.dds.getNumberDataSets());
            this.getCompressNumeric(des);
            return;
        }
        if (des.isNumeric()) {
            float value = this.getNumeric(des);
        } else {
            String string = this.getString(des);
        }
    }

    private void setArrays() {
        for (int i = 0; i < this.dorder.size(); ++i) {
            String bKey = (String)this.dorder.get(i);
            BufrData bd = (BufrData)this.bufrdatas.get(bKey);
            bd.setAllocation(this.dds.getNumberDataSets());
        }
    }

    private void localDes(String d2Key, String dlKey) throws IOException {
        int tmp = this.xWidth;
        this.xWidth = 0;
        int bitPad = Integer.parseInt(d2Key.substring(d2Key.lastIndexOf("-") + 1));
        Descriptor des = (Descriptor)tableB.get(dlKey);
        des.setWidth(bitPad);
        this.getNumeric(des);
        this.xWidth = tmp;
    }

    private int getRepetitions(String dKey) throws IOException {
        int ry = -1;
        if (dKey.equals("0-31-0")) {
            System.out.println("0-31-0 not implemented yet");
        } else if (dKey.equals("0-31-1")) {
            ry = this.bits2UInt(8);
        } else if (dKey.equals("0-31-2")) {
            ry = this.bits2UInt(16);
        } else {
            System.out.println("bad repetitions key =" + dKey);
        }
        return ry;
    }

    private void setValue(Descriptor des) throws IOException {
        if (!des.isNumeric()) {
            String value = this.getString(des);
            BufrData bd = (BufrData)this.bufrdatas.get(des.getKey());
            bd.setValue(value);
            return;
        }
        if (this.isCompressed) {
            this.getCompressNumeric(des);
        } else {
            float value = this.getNumeric(des);
            BufrData bd = (BufrData)this.bufrdatas.get(des.getKey());
            bd.setValue(value);
        }
    }

    private float getNumeric(Descriptor des) throws IOException {
        double f = this.bits2UInt(des.getWidth() + this.xWidth);
        if (f == bitsmv1[des.getWidth() + this.xWidth]) {
            return -9999.0f;
        }
        f = (f + (double)des.getRefVal()) / Math.pow(10.0, des.getScale() + this.xScale);
        return (float)f;
    }

    private String getString(int count) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append((char)this.bits2UInt(8));
        }
        return sb.toString();
    }

    private String getString(Descriptor des) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < des.getWidth() / 8; ++i) {
            sb.append((char)this.bits2UInt(8));
        }
        return sb.toString();
    }

    private int bits2UInt(int nb) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = this.raf.read();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = this.raf.read();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    public final ArrayList getDorder() {
        return this.dorder;
    }

    public final HashMap getBufrDatas() {
        return this.bufrdatas;
    }

    public final long[] getOffset() {
        return this.offset;
    }

    public final int[] getBitPos() {
        return this.oBitPos;
    }

    public final int[] getBitBuf() {
        return this.oBitBuf;
    }

    static {
        for (int i = 0; i < 33; ++i) {
            BufrDataSection.bitsmv1[i] = Math.pow(2.0, i) - 1.0;
        }
        tableA = null;
        tableB = null;
        tableD = null;
    }
}

