/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddyapplication;

import application.ApplicationContext;
import application.ResourceMap;
import ch.randelshofer.quaqua.util.Fonts;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.jhotdraw.samples.teddyapplication.TeddyView;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class PreferencesDialog
extends JDialog {
    private ResourceMap labels = ApplicationContext.getInstance().getResourceMap(TeddyView.class);
    private JRadioButton mdiRadio;
    private JRadioButton osxRadio;
    private JRadioButton sdiRadio;
    private ButtonGroup uiGroup;
    private JLabel uiLabel;

    public PreferencesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        PreferencesUtil.installFramePrefsHandler(prefs, "Preferences.Dialog", this);
        String ui = prefs.get("UserInterface", "SDI");
        if (ui.equals("SDI")) {
            this.sdiRadio.setSelected(true);
        } else if (ui.equals("MDI")) {
            this.mdiRadio.setSelected(true);
        } else {
            this.osxRadio.setSelected(true);
        }
        this.uiLabel.setFont(Fonts.getEmphasizedDialogFont());
    }

    public PreferencesDialog() {
        this((Frame)null, false);
    }

    private void initComponents() {
        this.uiGroup = new ButtonGroup();
        this.uiLabel = new JLabel();
        this.sdiRadio = new JRadioButton();
        this.mdiRadio = new JRadioButton();
        this.osxRadio = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.uiLabel.setText(this.labels.getString("Preferences.UserInterface.text", new Object[0]));
        this.uiGroup.add(this.sdiRadio);
        this.sdiRadio.setText(this.labels.getString("Preferences.SingleDocumentInterface.text", new Object[0]));
        this.sdiRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sdiRadio.setMargin(new Insets(0, 0, 0, 0));
        this.sdiRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.uiRadioPerformed(evt);
            }
        });
        this.uiGroup.add(this.mdiRadio);
        this.mdiRadio.setText(this.labels.getString("Preferences.MultipleDocumentInterface.text", new Object[0]));
        this.mdiRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mdiRadio.setMargin(new Insets(0, 0, 0, 0));
        this.mdiRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.uiRadioPerformed(evt);
            }
        });
        this.uiGroup.add(this.osxRadio);
        this.osxRadio.setText(this.labels.getString("Preferences.MacOSX.text", new Object[0]));
        this.osxRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.osxRadio.setEnabled(false);
        this.osxRadio.setMargin(new Insets(0, 0, 0, 0));
        this.osxRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.uiRadioPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.osxRadio).add((Component)this.mdiRadio).add((Component)this.uiLabel).add((Component)this.sdiRadio)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.uiLabel).addPreferredGap(0).add((Component)this.sdiRadio).addPreferredGap(0).add((Component)this.mdiRadio).addPreferredGap(0).add((Component)this.osxRadio).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void uiRadioPerformed(ActionEvent evt) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        if (this.sdiRadio.isSelected()) {
            prefs.put("UserInterface", "SDI");
        } else if (this.mdiRadio.isSelected()) {
            prefs.put("UserInterface", "MDI");
        } else {
            prefs.put("UserInterface", "OSX");
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PreferencesDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

