/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import ome.model.IObject;
import ome.security.basic.CurrentDetails;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogListener
implements PostUpdateEventListener,
PostDeleteEventListener,
PostInsertEventListener {
    private static final long serialVersionUID = 3245068515908082533L;
    private static Logger log = LoggerFactory.getLogger(EventLogListener.class);
    protected final CurrentDetails cd;

    public EventLogListener(CurrentDetails cd) {
        this.cd = cd;
    }

    public void onPostDelete(PostDeleteEvent event) {
        this.add("DELETE", event.getEntity());
    }

    public void onPostInsert(PostInsertEvent event) {
        this.add("INSERT", event.getEntity());
    }

    public void onPostUpdate(PostUpdateEvent event) {
        this.add("UPDATE", event.getEntity());
    }

    void add(String action, Object entity) {
        if (entity instanceof IObject) {
            Class<?> klass = entity.getClass();
            Long id = ((IObject)entity).getId();
            this.cd.addLog(action, klass, id);
        }
    }
}

