/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import ome.model.IObject;
import ome.model.internal.GraphHolder;
import ome.model.internal.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenHolder {
    private static Logger log = LoggerFactory.getLogger(TokenHolder.class);
    private final Token token = new Token();

    public void setToken(GraphHolder gh) {
        gh.setToken(this.token, this.token);
    }

    public void clearToken(GraphHolder gh) {
        gh.setToken(this.token, null);
    }

    public boolean hasPrivilegedToken(IObject obj) {
        if (obj == null) {
            return false;
        }
        GraphHolder gh = obj.getGraphHolder();
        return gh.hasToken() && gh.tokenMatches(this.token);
    }

    public void copyToken(IObject source, IObject copy) {
        if (source == null || copy == null || source == copy) {
            return;
        }
        GraphHolder gh1 = source.getGraphHolder();
        GraphHolder gh2 = copy.getGraphHolder();
        if (gh1.tokenMatches(this.token)) {
            gh2.setToken(this.token, this.token);
        }
    }
}

