/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementGenerator
implements IdentifierGenerator,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(IncrementGenerator.class);
    private Class returnClass;
    private String sql;
    private IntegralDataTypeHolder previousValueHolder;

    public synchronized Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        if (this.sql != null) {
            this.initializePreviousValueHolder(session);
        }
        return this.previousValueHolder.makeValueThenIncrement();
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.returnClass = type.getReturnedClass();
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String column = params.getProperty("column");
        if (column == null) {
            column = params.getProperty("target_column");
        }
        column = dialect.quote(normalizer.normalizeIdentifierQuoting(column));
        String tableList = params.getProperty("tables");
        if (tableList == null) {
            tableList = params.getProperty("identity_tables");
        }
        String[] tables = StringHelper.split(", ", tableList);
        String schema = dialect.quote(normalizer.normalizeIdentifierQuoting(params.getProperty("schema")));
        String catalog = dialect.quote(normalizer.normalizeIdentifierQuoting(params.getProperty("catalog")));
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < tables.length; ++i) {
            String tableName = dialect.quote(normalizer.normalizeIdentifierQuoting(tables[i]));
            if (tables.length > 1) {
                buf.append("select ").append(column).append(" from ");
            }
            buf.append(Table.qualify(catalog, schema, tableName));
            if (i >= tables.length - 1) continue;
            buf.append(" union ");
        }
        if (tables.length > 1) {
            buf.insert(0, "( ").append(" ) ids_");
            column = "ids_." + column;
        }
        this.sql = "select max(" + column + ") from " + buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePreviousValueHolder(SessionImplementor session) {
        this.previousValueHolder = IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.returnClass);
        log.debug("fetching initial value: " + this.sql);
        try {
            PreparedStatement st = session.getBatcher().prepareSelectStatement(this.sql);
            try {
                ResultSet rs = st.executeQuery();
                try {
                    if (rs.next()) {
                        this.previousValueHolder.initialize(rs, 0L).increment();
                    } else {
                        this.previousValueHolder.initialize(1L);
                    }
                    this.sql = null;
                    log.debug("first free id: " + this.previousValueHolder.makeValue());
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            session.getBatcher().closeStatement(st);
            {
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not fetch initial value for increment generator", this.sql);
        }
    }
}

