/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugAccumulator {
    private BugReporter reporter;
    private Map<BugInstance, List<SourceLineAnnotation>> map;

    public BugAccumulator(BugReporter reporter) {
        this.reporter = reporter;
        this.map = new HashMap<BugInstance, List<SourceLineAnnotation>>();
    }

    public void accumulateBug(BugInstance bug, SourceLineAnnotation sourceLine) {
        List<SourceLineAnnotation> where = this.map.get(bug);
        if (where == null) {
            where = new LinkedList<SourceLineAnnotation>();
            this.map.put(bug, where);
        }
        where.add(sourceLine);
    }

    public void accumulateBug(BugInstance bug, BytecodeScanningDetector visitor) {
        SourceLineAnnotation source = SourceLineAnnotation.fromVisitedInstruction(visitor);
        this.accumulateBug(bug, source);
    }

    public Iterator<Map.Entry<BugInstance, List<SourceLineAnnotation>>> entrySetIterator() {
        return this.map.entrySet().iterator();
    }

    public void reportAccumulatedBugs() {
        for (Map.Entry<BugInstance, List<SourceLineAnnotation>> e : this.map.entrySet()) {
            BugInstance bug = e.getKey();
            boolean first = true;
            for (SourceLineAnnotation source : e.getValue()) {
                if (source == null) continue;
                bug.addSourceLine(source);
                if (first) {
                    first = false;
                    continue;
                }
                bug.describe("SOURCE_LINE_ANOTHER_INSTANCE");
            }
            this.reporter.reportBug(bug);
        }
        this.map.clear();
    }
}

