/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.header.HeaderViolationMonitor;
import com.puppycrawl.tools.checkstyle.checks.header.RegexpHeaderChecker;
import com.puppycrawl.tools.checkstyle.checks.header.RegexpHeaderInfo;
import java.io.File;
import java.io.IOException;
import org.apache.commons.beanutils.ConversionException;

public final class CrossLanguageRegexpHeaderCheck
extends AbstractFileSetCheck {
    private RegexpHeaderInfo mHeaderInfo = new RegexpHeaderInfo();

    public CrossLanguageRegexpHeaderCheck() {
        this.setFileExtensions(new String[]{"java", "txt", "properties", "html", "jsp", "xml", "wsdl", "js", "css", "idl", "c", "cc", "cpp", "cxx", "h", "cs", "sh", "py", "bat"});
    }

    public void setMultiLines(int[] aList) {
        this.mHeaderInfo.setMultiLines(aList);
    }

    public void setHeaderFile(String aFileName) throws ConversionException {
        this.mHeaderInfo.setHeaderFile(aFileName);
    }

    public void setHeader(String aHeader) {
        this.mHeaderInfo.setHeader(aHeader);
    }

    protected void finishLocalSetup() throws CheckstyleException {
        if (this.mHeaderInfo.getHeaderLines() == null) {
            throw new CheckstyleException("property 'headerFile' is missing or invalid in module " + this.getConfiguration().getName());
        }
    }

    public void process(File[] aFiles) {
        MessageDispatcher msgDispatcher = this.getMessageDispatcher();
        RegexpHeaderChecker regexpHeaderChecker = new RegexpHeaderChecker(this.mHeaderInfo, new FileSetCheckViolationMonitor());
        File[] files = this.filter(aFiles);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String path = file.getPath();
            msgDispatcher.fireFileStarted(path);
            try {
                String[] lines = Utils.getLines(path);
                regexpHeaderChecker.checkLines(lines);
            }
            catch (IOException ex) {
                this.log(0, "unable to open file: " + ex);
            }
            this.fireErrors(path);
            msgDispatcher.fireFileFinished(path);
        }
    }

    private final class FileSetCheckViolationMonitor
    implements HeaderViolationMonitor {
        private FileSetCheckViolationMonitor() {
        }

        public void reportHeaderMismatch(int aLineNo, String aHeaderLine) {
            CrossLanguageRegexpHeaderCheck.this.log(aLineNo, "header.mismatch", aHeaderLine);
        }

        public void reportHeaderMissing() {
            CrossLanguageRegexpHeaderCheck.this.log(1, "header.missing");
        }
    }
}

