/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in.LeicaMicrosystemsMetadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import loci.common.Location;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSCollectionXmlDocument;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class LMSXmlDocument {
    protected Document doc;
    protected XPath xPath;
    protected String dir;
    protected String filepath;
    protected static final Logger LOGGER = LoggerFactory.getLogger(LMSXmlDocument.class);
    LMSCollectionXmlDocument parent;

    public LMSXmlDocument(String xml) {
        this.initFromXmlString(xml);
    }

    public LMSXmlDocument(String filepath, LMSCollectionXmlDocument parent) {
        this.initFromFilepath(filepath);
        this.parent = parent;
    }

    public Document getDoc() {
        return this.doc;
    }

    public String getFilepath() {
        return this.filepath;
    }

    private void initFromXmlString(String xml) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(xml)));
            doc.getDocumentElement().normalize();
            this.doc = doc;
            this.xPath = XPathFactory.newInstance().newXPath();
            LMSFileReader.log.trace(this.toString());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LMSFileReader.log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private void initFromFilepath(String filepath) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            FileInputStream fi = new FileInputStream(Location.getMappedId((String)filepath));
            Document doc = db.parse(fi);
            fi.close();
            doc.getDocumentElement().normalize();
            this.doc = doc;
            this.xPath = XPathFactory.newInstance().newXPath();
            LMSFileReader.log.trace(this.toString());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LMSFileReader.log.error(e.getMessage());
            e.printStackTrace();
        }
        this.dir = Paths.get(filepath, new String[0]).getParent().toString();
        this.filepath = Paths.get(filepath, new String[0]).normalize().toString();
    }

    public NodeList xPath(String expression) {
        try {
            return (NodeList)this.xPath.compile(expression).evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (Exception e) {
            LMSFileReader.log.error(e.getMessage());
            return null;
        }
    }

    public NodeList xPath(Node node, String expression) {
        try {
            return (NodeList)this.xPath.compile(expression).evaluate(node, XPathConstants.NODESET);
        }
        catch (Exception e) {
            LMSFileReader.log.error(e.getMessage());
            return null;
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.transform(new DOMSource(this.doc), new StreamResult(writer));
            return writer.getBuffer().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getAttr(Node node, String attrName) {
        Node item = node.getAttributes().getNamedItem(attrName);
        if (item != null) {
            return item.getTextContent();
        }
        return null;
    }

    protected String parseFilePath(String refPath) {
        String urlDecoded = "";
        try {
            urlDecoded = URLDecoder.decode(refPath, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            urlDecoded = refPath.replace("%5C", File.separator).replace("%5c", File.separator).replace("%20", " ");
        }
        urlDecoded = urlDecoded.replace('\\', File.separatorChar);
        urlDecoded = urlDecoded.replaceAll("/", File.separator);
        String path = this.dir + File.separator + urlDecoded;
        path = Paths.get(path, new String[0]).normalize().toString();
        LOGGER.info("Parsed path: " + path);
        return Location.getMappedId((String)path);
    }

    public String nodeToString(Node node) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            String xmlString = writer.getBuffer().toString();
            return xmlString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Node GetChildWithName(Node node, String name) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (!child.getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public List<String> getParentFiles() {
        ArrayList<String> parents = new ArrayList<String>();
        if (this.parent != null) {
            parents.add(this.parent.filepath);
            parents.addAll(this.parent.getParentFiles());
        }
        return parents;
    }

    protected static String fileExists(String path) {
        HashMap idMap = Location.getIdMap();
        if (idMap != null) {
            for (String key : idMap.keySet()) {
                if (!key.equalsIgnoreCase(path)) continue;
                path = idMap.get(key).toString();
            }
        }
        if (path != null && !path.trim().isEmpty()) {
            try {
                path = Location.getMappedId((String)path);
                File f = new File(path);
                if (f.exists()) {
                    return path;
                }
                String parent = LMSXmlDocument.fileExists(f.getParent());
                if (parent != null) {
                    f = new File(parent + File.separator + f.getName());
                    for (File file : f.getParentFile().listFiles()) {
                        if (!file.getName().toLowerCase().equals(f.getName().toLowerCase())) continue;
                        return parent + File.separator + file.getName();
                    }
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static enum InitFrom {
        XML,
        FILEPATH;

    }
}

