/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.stempel.StempelFilter;
import org.apache.lucene.analysis.stempel.StempelStemmer;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.plugin.ResourceLoaderAware;
import org.egothor.stemmer.Trie;

public class StempelPolishStemFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private Trie stemmer = null;
    private static final String STEMTABLE = "org/apache/lucene/analysis/pl/stemmer_20000.tbl";

    public TokenStream create(TokenStream input) {
        return new StempelFilter(input, new StempelStemmer(this.stemmer));
    }

    public void inform(ResourceLoader loader) {
        try {
            this.stemmer = StempelStemmer.load((InputStream)loader.openResource(STEMTABLE));
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load stem table: org/apache/lucene/analysis/pl/stemmer_20000.tbl");
        }
    }
}

