/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.recovery.IncrementalRecoverer;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceRegistrar {
    private static final Logger log = LoggerFactory.getLogger(ResourceRegistrar.class);
    public static final Charset UNIQUE_NAME_CHARSET = Charset.forName("US-ASCII");
    private static final Set<ProducerHolder> resources = new CopyOnWriteArraySet<ProducerHolder>();

    public static XAResourceProducer get(String uniqueName) {
        if (uniqueName != null) {
            for (ProducerHolder holder : resources) {
                if (!holder.isInitialized() || !uniqueName.equals(holder.getUniqueName())) continue;
                return holder.producer;
            }
        }
        return null;
    }

    public static Set<String> getResourcesUniqueNames() {
        HashSet<String> names = new HashSet<String>(resources.size());
        for (ProducerHolder holder : resources) {
            if (!holder.isInitialized()) continue;
            names.add(holder.getUniqueName());
        }
        return Collections.unmodifiableSet(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(XAResourceProducer producer) throws RecoveryException {
        block8: {
            try {
                ProducerHolder holder;
                boolean alreadyRunning = TransactionManagerServices.isTransactionManagerRunning();
                ProducerHolder producerHolder = holder = alreadyRunning ? new InitializableProducerHolder(producer) : new ProducerHolder(producer);
                if (resources.add(holder)) {
                    if (!(holder instanceof InitializableProducerHolder)) break block8;
                    boolean recovered = false;
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("Transaction manager is running, recovering resource '" + holder.getUniqueName() + "'.");
                        }
                        IncrementalRecoverer.recover(producer);
                        ((InitializableProducerHolder)holder).initialize();
                        recovered = true;
                        break block8;
                    }
                    finally {
                        if (!recovered) {
                            resources.remove(holder);
                        }
                    }
                }
                throw new IllegalStateException("A resource with uniqueName '" + holder.getUniqueName() + "' has already been registered. Cannot register XAResourceProducer '" + producer + "'.");
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot register the XAResourceProducer '" + producer + "' caused by invalid input.", e);
            }
        }
    }

    public static void unregister(XAResourceProducer producer) {
        ProducerHolder holder = new ProducerHolder(producer);
        if (!resources.remove(holder) && log.isDebugEnabled()) {
            log.debug("resource with uniqueName '{}' has not been registered", (Object)holder.getUniqueName());
        }
    }

    public static XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        boolean debug = log.isDebugEnabled();
        for (ProducerHolder holder : resources) {
            if (!holder.isInitialized()) continue;
            XAResourceProducer producer = holder.producer;
            Object resourceHolder = producer.findXAResourceHolder(xaResource);
            if (resourceHolder != null) {
                if (debug) {
                    log.debug("XAResource " + xaResource + " belongs to " + resourceHolder + " that itself belongs to " + producer);
                }
                return resourceHolder;
            }
            if (!debug) continue;
            log.debug("XAResource " + xaResource + " does not belong to any resource of " + producer);
        }
        return null;
    }

    private ResourceRegistrar() {
    }

    private static class InitializableProducerHolder
    extends ProducerHolder {
        private volatile boolean initialized;

        private InitializableProducerHolder(XAResourceProducer producer) {
            super(producer);
        }

        @Override
        boolean isInitialized() {
            return this.initialized;
        }

        void initialize() {
            this.initialized = true;
        }
    }

    private static class ProducerHolder {
        private final XAResourceProducer producer;

        private ProducerHolder(XAResourceProducer producer) {
            if (producer == null) {
                throw new IllegalArgumentException("XAResourceProducer may not be 'null'. Verify your call to ResourceRegistrar.[un]register(...).");
            }
            String uniqueName = producer.getUniqueName();
            if (uniqueName == null || uniqueName.length() == 0) {
                throw new IllegalArgumentException("The given XAResourceProducer '" + producer + "' does not specify a uniqueName.");
            }
            String transcodedUniqueName = new String(uniqueName.getBytes(UNIQUE_NAME_CHARSET), UNIQUE_NAME_CHARSET);
            if (!transcodedUniqueName.equals(uniqueName)) {
                throw new IllegalArgumentException("The given XAResourceProducer's uniqueName '" + uniqueName + "' is not compatible with the charset 'US-ASCII' (transcoding results in '" + transcodedUniqueName + "'). " + System.getProperty("line.separator") + "BTM requires unique names to be compatible with US-ASCII when used with a transaction journal.");
            }
            this.producer = producer;
        }

        boolean isInitialized() {
            return true;
        }

        String getUniqueName() {
            return this.producer.getUniqueName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProducerHolder)) {
                return false;
            }
            ProducerHolder that = (ProducerHolder)o;
            return this.getUniqueName().equals(that.getUniqueName());
        }

        public int hashCode() {
            return this.getUniqueName().hashCode();
        }

        public String toString() {
            return "ProducerHolder{producer=" + this.producer + ", initialized=" + this.isInitialized() + '}';
        }
    }
}

