/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.lrc;

import bitronix.tm.resource.jdbc.proxy.JdbcProxyFactory;
import bitronix.tm.utils.ClassLoaderUtils;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class LrcXADataSource
implements XADataSource {
    private volatile int loginTimeout;
    private volatile String driverClassName;
    private volatile String url;
    private volatile String user;
    private volatile String password;

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        try {
            Class driverClazz = ClassLoaderUtils.loadClass(this.driverClassName);
            Driver driver = (Driver)driverClazz.newInstance();
            Properties props = new Properties();
            if (this.user != null) {
                props.setProperty("user", this.user);
            }
            if (this.password != null) {
                props.setProperty("password", this.password);
            }
            Connection connection = driver.connect(this.url, props);
            XAConnection xaConnection = JdbcProxyFactory.INSTANCE.getProxyXaConnection(connection);
            return xaConnection;
        }
        catch (Exception ex) {
            throw new SQLException("unable to connect to non-XA resource " + this.driverClassName, ex);
        }
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        try {
            Class driverClazz = ClassLoaderUtils.loadClass(this.driverClassName);
            Driver driver = (Driver)driverClazz.newInstance();
            Properties props = new Properties();
            props.setProperty("user", user);
            props.setProperty("password", password);
            Connection connection = driver.connect(this.url, props);
            XAConnection xaConnection = JdbcProxyFactory.INSTANCE.getProxyXaConnection(connection);
            return xaConnection;
        }
        catch (Exception ex) {
            throw new SQLException("unable to connect to non-XA resource " + this.driverClassName, ex);
        }
    }

    public String toString() {
        return "a JDBC LrcXADataSource on " + this.driverClassName + " with URL " + this.url;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

