/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.LruStatementCache;
import bitronix.tm.resource.jdbc.PooledConnectionProxy;
import bitronix.tm.resource.jdbc.lrc.LrcXAResource;
import bitronix.tm.resource.jdbc.proxy.CallableStatementJavaProxy;
import bitronix.tm.resource.jdbc.proxy.ConnectionJavaProxy;
import bitronix.tm.resource.jdbc.proxy.JavaProxyBase;
import bitronix.tm.resource.jdbc.proxy.JdbcJavaProxyFactory;
import bitronix.tm.resource.jdbc.proxy.JdbcProxyFactory;
import bitronix.tm.resource.jdbc.proxy.PreparedStatementJavaProxy;
import bitronix.tm.resource.jdbc.proxy.ResultSetJavaProxy;
import bitronix.tm.resource.jdbc.proxy.StatementJavaProxy;
import bitronix.tm.utils.ClassLoaderUtils;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import javax.sql.XAConnection;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.LazyLoader;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class JdbcCglibProxyFactory
implements JdbcProxyFactory {
    private final Class<Connection> proxyConnectionClass = this.createProxyConnectionClass();
    private final Class<Statement> proxyStatementClass = this.createProxyStatementClass();
    private final Class<CallableStatement> proxyCallableStatementClass = this.createProxyCallableStatementClass();
    private final Class<PreparedStatement> proxyPreparedStatementClass = this.createProxyPreparedStatementClass();
    private final Class<ResultSet> proxyResultSetClass = this.createProxyResultSetClass();
    private final JdbcJavaProxyFactory lrcProxyFactory = new JdbcJavaProxyFactory();

    JdbcCglibProxyFactory() {
    }

    @Override
    public Connection getProxyConnection(JdbcPooledConnection jdbcPooledConnection, Connection connection) {
        ConnectionJavaProxy methodInterceptor = new ConnectionJavaProxy(jdbcPooledConnection, connection);
        Interceptor interceptor = new Interceptor(methodInterceptor);
        FastDispatcher fastDispatcher = new FastDispatcher(connection);
        try {
            Connection connectionCglibProxy = this.proxyConnectionClass.newInstance();
            ((Factory)connectionCglibProxy).setCallbacks(new Callback[]{fastDispatcher, interceptor});
            return connectionCglibProxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Statement getProxyStatement(JdbcPooledConnection jdbcPooledConnection, Statement statement) {
        StatementJavaProxy methodInterceptor = new StatementJavaProxy(jdbcPooledConnection, statement);
        Interceptor interceptor = new Interceptor(methodInterceptor);
        FastDispatcher fastDispatcher = new FastDispatcher(statement);
        try {
            Statement statementCglibProxy = this.proxyStatementClass.newInstance();
            ((Factory)statementCglibProxy).setCallbacks(new Callback[]{fastDispatcher, interceptor});
            return statementCglibProxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CallableStatement getProxyCallableStatement(JdbcPooledConnection jdbcPooledConnection, CallableStatement statement) {
        CallableStatementJavaProxy methodInterceptor = new CallableStatementJavaProxy(jdbcPooledConnection, statement);
        Interceptor interceptor = new Interceptor(methodInterceptor);
        FastDispatcher fastDispatcher = new FastDispatcher(statement);
        try {
            CallableStatement statementCglibProxy = this.proxyCallableStatementClass.newInstance();
            ((Factory)statementCglibProxy).setCallbacks(new Callback[]{fastDispatcher, interceptor});
            return statementCglibProxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PreparedStatement getProxyPreparedStatement(JdbcPooledConnection jdbcPooledConnection, PreparedStatement statement, LruStatementCache.CacheKey cacheKey) {
        PreparedStatementJavaProxy methodInterceptor = new PreparedStatementJavaProxy(jdbcPooledConnection, statement, cacheKey);
        Interceptor interceptor = new Interceptor(methodInterceptor);
        FastDispatcher fastDispatcher = new FastDispatcher(statement);
        try {
            PreparedStatement statementCglibProxy = this.proxyPreparedStatementClass.newInstance();
            ((Factory)statementCglibProxy).setCallbacks(new Callback[]{fastDispatcher, interceptor});
            return statementCglibProxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResultSet getProxyResultSet(Statement statement, ResultSet resultSet) {
        ResultSetJavaProxy methodInterceptor = new ResultSetJavaProxy(statement, resultSet);
        Interceptor interceptor = new Interceptor(methodInterceptor);
        FastDispatcher fastDispatcher = new FastDispatcher(resultSet);
        try {
            ResultSet resultSetCglibProxy = this.proxyResultSetClass.newInstance();
            ((Factory)resultSetCglibProxy).setCallbacks(new Callback[]{fastDispatcher, interceptor});
            return resultSetCglibProxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public XAConnection getProxyXaConnection(Connection connection) {
        return this.lrcProxyFactory.getProxyXaConnection(connection);
    }

    @Override
    public Connection getProxyConnection(LrcXAResource xaResource, Connection connection) {
        return this.lrcProxyFactory.getProxyConnection(xaResource, connection);
    }

    private Class<Connection> createProxyConnectionClass() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(Connection.class);
        interfaces.add(PooledConnectionProxy.class);
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(interfaces.toArray(new Class[0]));
        enhancer.setCallbackTypes(new Class[]{FastDispatcher.class, Interceptor.class});
        enhancer.setCallbackFilter((CallbackFilter)new InterceptorFilter(new ConnectionJavaProxy()));
        return enhancer.createClass();
    }

    private Class<PreparedStatement> createProxyPreparedStatementClass() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(PreparedStatement.class);
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(interfaces.toArray(new Class[0]));
        enhancer.setCallbackTypes(new Class[]{FastDispatcher.class, Interceptor.class});
        enhancer.setCallbackFilter((CallbackFilter)new InterceptorFilter(new PreparedStatementJavaProxy()));
        return enhancer.createClass();
    }

    private Class<Statement> createProxyStatementClass() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(Statement.class);
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(interfaces.toArray(new Class[0]));
        enhancer.setCallbackTypes(new Class[]{FastDispatcher.class, Interceptor.class});
        enhancer.setCallbackFilter((CallbackFilter)new InterceptorFilter(new StatementJavaProxy()));
        return enhancer.createClass();
    }

    private Class<CallableStatement> createProxyCallableStatementClass() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(CallableStatement.class);
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(interfaces.toArray(new Class[0]));
        enhancer.setCallbackTypes(new Class[]{FastDispatcher.class, Interceptor.class});
        enhancer.setCallbackFilter((CallbackFilter)new InterceptorFilter(new CallableStatementJavaProxy()));
        return enhancer.createClass();
    }

    private Class<ResultSet> createProxyResultSetClass() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(ResultSet.class);
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(interfaces.toArray(new Class[0]));
        enhancer.setCallbackTypes(new Class[]{FastDispatcher.class, Interceptor.class});
        enhancer.setCallbackFilter((CallbackFilter)new InterceptorFilter(new ResultSetJavaProxy()));
        return enhancer.createClass();
    }

    static class InterceptorFilter
    implements CallbackFilter {
        private final Map<String, Method> methodMap;

        public InterceptorFilter(JavaProxyBase<?> proxyClass) {
            this.methodMap = proxyClass.getMethodMap();
        }

        public int accept(Method method) {
            if (this.methodMap.containsKey(JavaProxyBase.getMethodKey(method))) {
                return 1;
            }
            return 0;
        }
    }

    static class Interceptor
    implements MethodInterceptor {
        private final JavaProxyBase<?> interceptor;

        public Interceptor(JavaProxyBase<?> interceptor) {
            this.interceptor = interceptor;
        }

        public Object intercept(Object enhanced, Method method, Object[] args, MethodProxy fastProxy) throws Throwable {
            this.interceptor.proxy = enhanced;
            return this.interceptor.invoke(this.interceptor, method, args);
        }
    }

    static class FastDispatcher
    implements LazyLoader {
        private final Object delegate;

        public FastDispatcher(Object delegate) {
            this.delegate = delegate;
        }

        public Object loadObject() throws Exception {
            return this.delegate;
        }
    }
}

