/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.proxy.JavaProxyBase;
import bitronix.tm.resource.jdbc.proxy.JdbcProxyFactory;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class StatementJavaProxy
extends JavaProxyBase<Statement> {
    private static final Map<String, Method> selfMethodMap = StatementJavaProxy.createMethodMap(StatementJavaProxy.class);
    private JdbcPooledConnection jdbcPooledConnection;

    public StatementJavaProxy(JdbcPooledConnection jdbcPooledConnection, Statement statement) {
        this.initialize(jdbcPooledConnection, statement);
    }

    public StatementJavaProxy() {
    }

    void initialize(JdbcPooledConnection jdbcPooledConnection, Statement statement) {
        this.proxy = this;
        this.jdbcPooledConnection = jdbcPooledConnection;
        this.delegate = statement;
    }

    public void close() throws SQLException {
        if (this.delegate == null) {
            return;
        }
        this.jdbcPooledConnection.unregisterUncachedStatement((Statement)this.delegate);
        ((Statement)this.delegate).close();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet resultSet = ((Statement)this.delegate).executeQuery(sql);
        if (resultSet == null) {
            return null;
        }
        return JdbcProxyFactory.INSTANCE.getProxyResultSet((Statement)this.getProxy(), resultSet);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet generatedKeys = ((Statement)this.delegate).getGeneratedKeys();
        if (generatedKeys == null) {
            return null;
        }
        return JdbcProxyFactory.INSTANCE.getProxyResultSet((Statement)this.getProxy(), generatedKeys);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(((Statement)this.delegate).getClass()) || StatementJavaProxy.isWrapperFor(this.delegate, iface);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(((Statement)this.delegate).getClass())) {
            return (T)this.delegate;
        }
        if (this.isWrapperFor(iface)) {
            return StatementJavaProxy.unwrap(this.delegate, iface);
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for " + iface);
    }

    @Override
    protected Map<String, Method> getMethodMap() {
        return selfMethodMap;
    }
}

